/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAspectAdapter<S extends Model, V>
extends AspectPropertyValueModelAdapter<S, V> {
    protected final String[] aspectNames;
    protected static final String[] EMPTY_ASPECT_NAMES = new String[0];
    protected final PropertyChangeListener aspectChangeListener;

    protected PropertyAspectAdapter(String aspectName, S subject) {
        this(new String[]{aspectName}, subject);
    }

    protected PropertyAspectAdapter(String[] aspectNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), aspectNames);
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectModel, String ... aspectNames) {
        super(subjectModel);
        if (aspectNames == null) {
            throw new NullPointerException();
        }
        this.aspectNames = aspectNames;
        this.aspectChangeListener = this.buildAspectChangeListener();
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectModel, Collection<String> aspectNames) {
        this(subjectModel, aspectNames.toArray(new String[aspectNames.size()]));
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectModel) {
        this(subjectModel, EMPTY_ASPECT_NAMES);
    }

    protected PropertyChangeListener buildAspectChangeListener() {
        return new AspectChangeListener();
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).addPropertyChangeListener(propertyName, this.aspectChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).removePropertyChangeListener(propertyName, this.aspectChangeListener);
            ++n2;
        }
    }

    protected void aspectChanged(PropertyChangeEvent event) {
        this.aspectChanged();
    }

    protected class AspectChangeListener
    extends PropertyChangeAdapter {
        protected AspectChangeListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            PropertyAspectAdapter.this.aspectChanged(event);
        }
    }
}

