/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.jpt.common.utility.internal.model.listener.awt.AWTListChangeListenerWrapper;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveListTreeModel
extends DefaultTreeModel {
    private final ListValueModel<?> listHolder;
    private final ListChangeListener listChangeListener;
    private static final long serialVersionUID = 1L;

    public PrimitiveListTreeModel(ListValueModel<?> listHolder) {
        super(new DefaultMutableTreeNode(null, true));
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new AWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new PrimitiveListChangeListener();
    }

    protected abstract void primitiveChanged(int var1, Object var2);

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        int index = ((TreeNode)this.getRoot()).getIndex(node);
        this.primitiveChanged(index, newValue);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.addListChangeListener("list values", this.listChangeListener);
            this.synchronizeList();
        }
        super.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        }
    }

    void synchronizeList() {
        this.clearList();
        this.buildList();
    }

    void clearList() {
        int childcount = this.root.getChildCount();
        int i = childcount - 1;
        while (i >= 0) {
            this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
            --i;
        }
    }

    private void buildList() {
        Iterator<?> stream = this.listHolder.iterator();
        while (stream.hasNext()) {
            this.addPrimitive(stream.next());
        }
    }

    private void addPrimitive(Object primitive) {
        this.insertPrimitive(this.root.getChildCount(), primitive);
    }

    void insertPrimitive(int index, Object primitive) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(primitive, false);
        this.insertNodeInto(node, (MutableTreeNode)this.root, index);
    }

    MutableTreeNode removeNode(int index) {
        MutableTreeNode node = (MutableTreeNode)this.root.getChildAt(index);
        this.removeNodeFromParent(node);
        return node;
    }

    void replacePrimitive(int index, Object primitive) {
        MutableTreeNode node = (MutableTreeNode)this.root.getChildAt(index);
        node.setUserObject(primitive);
        this.nodeChanged(node);
    }

    private class PrimitiveListChangeListener
    implements ListChangeListener {
        PrimitiveListChangeListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            int i = event.getIndex();
            for (Object item : event.getItems()) {
                PrimitiveListTreeModel.this.insertPrimitive(i++, item);
            }
        }

        public void itemsRemoved(ListRemoveEvent event) {
            int i = 0;
            while (i < event.getItemsSize()) {
                PrimitiveListTreeModel.this.removeNode(event.getIndex());
                ++i;
            }
        }

        public void itemsReplaced(ListReplaceEvent event) {
            int i = event.getIndex();
            for (Object item : event.getNewItems()) {
                PrimitiveListTreeModel.this.replacePrimitive(i++, item);
            }
        }

        public void itemsMoved(ListMoveEvent event) {
            ArrayList<MutableTreeNode> temp = new ArrayList<MutableTreeNode>(event.getLength());
            int i = 0;
            while (i < event.getLength()) {
                temp.add(PrimitiveListTreeModel.this.removeNode(event.getSourceIndex()));
                ++i;
            }
            i = event.getTargetIndex();
            for (MutableTreeNode node : temp) {
                PrimitiveListTreeModel.this.insertPrimitive(i++, node);
            }
        }

        public void listCleared(ListClearEvent event) {
            PrimitiveListTreeModel.this.clearList();
        }

        public void listChanged(ListChangeEvent event) {
            PrimitiveListTreeModel.this.synchronizeList();
        }
    }
}

