/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.operations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.operations.AbstractJpaFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmFileCreationDataModelProvider
extends AbstractJpaFileCreationDataModelProvider
implements OrmFileCreationDataModelProperties {
    protected static final DataModelPropertyDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new DataModelPropertyDescriptor[0];

    public IDataModelOperation getDefaultOperation() {
        return new OrmFileCreationOperation(this.getDataModel());
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = super.getPropertyNames();
        propertyNames.add("OrmFileCreationDataModelProperties.DEFAULT_ACCESS");
        propertyNames.add("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        propertyNames.add("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        }
        return super.isPropertyEnabled(propertyName);
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        PersistenceUnit pUnit;
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return null;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT") && (pUnit = this.getDefaultPersistenceUnit()) != null) {
            return pUnit.getName();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected String getDefaultFileName() {
        return XmlEntityMappings.DEFAULT_RUNTIME_PATH.lastSegment();
    }

    @Override
    protected IContentType getContentType() {
        return XmlEntityMappings.CONTENT_TYPE;
    }

    protected PersistenceUnit getDefaultPersistenceUnit() {
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        PersistenceXml persistenceXml = jpaProject.getContextModelRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() == 0) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("JptFileCreationDataModelProperties.CONTAINER_PATH")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 2);
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 4);
        } else if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 3);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            DataModelPropertyDescriptor[] accessTypes = new DataModelPropertyDescriptor[]{this.accessPropertyDescriptor(null), this.accessPropertyDescriptor("FIELD"), this.accessPropertyDescriptor("PROPERTY")};
            return accessTypes;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return (DataModelPropertyDescriptor[])ArrayTools.array((Iterable)IterableTools.transform((Iterable)IterableTools.insert(null, this.getPersistenceUnitNames()), (Transformer)new DataModelPropertyDescriptorTransformer()), (Object[])EMPTY_DESCRIPTOR_ARRAY);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return this.accessPropertyDescriptor((String)this.getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS"));
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.persistenceUnitPropertyDescriptor(this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor accessPropertyDescriptor(String accessType) {
        return accessType == null ? new DataModelPropertyDescriptor(null, JptJpaCoreMessages.NONE) : new DataModelPropertyDescriptor((Object)accessType);
    }

    DataModelPropertyDescriptor persistenceUnitPropertyDescriptor(String persistenceUnitName) {
        return StringTools.isBlank((String)persistenceUnitName) ? new DataModelPropertyDescriptor(null, JptJpaCoreMessages.NONE) : new DataModelPropertyDescriptor((Object)persistenceUnitName);
    }

    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT") || propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            status = this.validatePersistenceUnit();
        }
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    protected IStatus validatePersistenceUnit() {
        boolean addToPUnit = this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        String projectName = this.getProject().getName();
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        if (addToPUnit) {
            if (StringTools.isBlank((String)pUnitName)) {
                return JptJpaCorePlugin.instance().buildErrorStatus(JptJpaCoreMessages.VALIDATE_PERSISTENCE_UNIT_DOES_NOT_SPECIFIED, new Object[]{pUnitName});
            }
            if (this.getPersistenceUnit() == null) {
                return JptJpaCorePlugin.instance().buildErrorStatus(JptJpaCoreMessages.VALIDATE_PERSISTENCE_UNIT_NOT_IN_PROJECT, new Object[]{pUnitName, projectName});
            }
        }
        return Status.OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() {
        Persistence persistence;
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = StringTools.isBlank((String)pUnitName) ? null : this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getContextModelRoot().getPersistenceXml();
        Persistence persistence2 = persistence = persistenceXml == null ? null : persistenceXml.getRoot();
        if (persistence != null) {
            for (PersistenceUnit next : persistence.getPersistenceUnits()) {
                if (!pUnitName.equals(next.getName())) continue;
                return next;
            }
        }
        return null;
    }

    protected Iterable<PersistenceUnit> getPersistenceUnits() {
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getContextModelRoot().getPersistenceXml();
        Persistence persistence = persistenceXml == null ? null : persistenceXml.getRoot();
        return persistence == null ? EmptyIterable.instance() : persistence.getPersistenceUnits();
    }

    protected Iterable<String> getPersistenceUnitNames() {
        return IterableTools.transform(this.getPersistenceUnits(), PersistenceUnit.NAME_TRANSFORMER);
    }

    @Override
    protected boolean platformIsSupported(JpaPlatform jpaPlatform) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataModelPropertyDescriptorTransformer
    extends TransformerAdapter<String, DataModelPropertyDescriptor> {
        public DataModelPropertyDescriptor transform(String persistenceUnitName) {
            return OrmFileCreationDataModelProvider.this.persistenceUnitPropertyDescriptor(persistenceUnitName);
        }
    }
}

