/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpql.DefaultContentAssistExtension;
import org.eclipse.jpt.jpa.core.jpql.spi.IManagedTypeBuilder;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaQuery;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.AbstractJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistExtension;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.utility.XmlEscapeCharacterConverter;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaJpqlQueryHelper
extends AbstractJPQLQueryHelper {
    private JpaProject jpaProject;
    private IManagedTypeProvider managedTypeProvider;

    protected JpaJpqlQueryHelper(JPQLGrammar jpqlGrammar) {
        super(jpqlGrammar);
    }

    public ContentAssistProposals buildContentAssistProposals(int position) {
        return super.buildContentAssistProposals(position, this.buildContentAssistProposalsHelper());
    }

    protected ContentAssistExtension buildContentAssistProposalsHelper() {
        return new DefaultContentAssistExtension(this.jpaProject);
    }

    protected abstract IManagedTypeBuilder buildManagedTypeBuilder();

    protected abstract IMappingBuilder<AttributeMapping> buildMappingBuilder();

    public int[] buildPositions(JPQLQueryProblem problem, String parsedJpqlQuery, String jpqlQuery, String actualJpqlQuery, int offset, EscapeType escapeType) {
        int[] positions = new int[]{problem.getStartPosition(), problem.getEndPosition()};
        if (positions[0] == positions[1]) {
            positions[0] = Math.max(positions[0] - 1, 0);
        }
        ExpressionTools.reposition((CharSequence)parsedJpqlQuery, (int[])positions, (CharSequence)jpqlQuery);
        positions[0] = positions[0] + offset;
        positions[1] = positions[1] + offset;
        if (escapeType == EscapeType.JAVA) {
            ExpressionTools.repositionJava((CharSequence)actualJpqlQuery, (int[])positions);
        } else if (escapeType == EscapeType.XML) {
            XmlEscapeCharacterConverter.reposition((CharSequence)actualJpqlQuery, (int[])positions);
        }
        return positions;
    }

    protected List<IMessage> buildProblems(NamedQuery namedQuery, List<TextRange> textRanges, JPQLQueryProblem problem, String parsedJpqlQuery, String jpqlQuery, String actualJpqlQuery, int offset, EscapeType escapeType) {
        int[] positions = this.buildPositions(problem, parsedJpqlQuery, jpqlQuery, actualJpqlQuery, offset, escapeType);
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        int problemLength = positions[1] - positions[0];
        int problemOffset = positions[0];
        boolean done = false;
        for (TextRange textRange : textRanges) {
            int textRangeOffset = escapeType == EscapeType.JAVA ? 2 : 0;
            int textRangeLength = textRange.getLength() - textRangeOffset;
            if (problemOffset <= textRangeLength) {
                int partialProblemLength = problemLength;
                if (problemOffset + problemLength > textRangeLength) {
                    partialProblemLength = textRangeLength - problemOffset;
                    problemLength -= partialProblemLength;
                    textRangeLength = 0;
                } else {
                    done = true;
                }
                Message message = new Message("jpt_jpa_core_jpql_validation", 1, problem.getMessageKey(), problem.getMessageArguments(), (Object)namedQuery.getResource());
                message.setMarkerId(JpaProject.MARKER_TYPE);
                int lineNumber = textRange.getLineNumber();
                message.setLineNo(lineNumber);
                if (lineNumber == 0) {
                    message.setAttribute("location", (Object)" ");
                }
                message.setOffset(textRange.getOffset() + problemOffset);
                message.setLength(partialProblemLength);
                messages.add((IMessage)message);
                if (done) break;
            }
            int n = problemOffset = textRangeLength == 0 ? 0 : problemOffset - textRangeLength;
        }
        return messages;
    }

    protected JpaManagedTypeProvider buildProvider(JpaProject jpaProject, PersistenceUnit persistenceUnit) {
        return new JpaManagedTypeProvider(jpaProject, persistenceUnit, this.buildManagedTypeBuilder(), this.buildMappingBuilder());
    }

    protected int getValidationSeverity(NamedQuery namedQuery) {
        return JptJpaCorePlugin.instance().getValidationMessageSeverity(namedQuery.getResource().getProject(), JptJpaCoreValidationMessages.JPQL_QUERY_VALIDATION.getID(), JptJpaCoreValidationMessages.JPQL_QUERY_VALIDATION.getDefaultSeverity());
    }

    public void setQuery(NamedQuery namedQuery, String actualQuery) {
        this.jpaProject = namedQuery.getJpaProject();
        if (this.managedTypeProvider == null) {
            this.managedTypeProvider = this.buildProvider(this.jpaProject, namedQuery.getPersistenceUnit());
        }
        JpaQuery query = new JpaQuery(this.managedTypeProvider, namedQuery, actualQuery);
        super.setQuery((IQuery)query);
    }

    protected boolean shouldValidate(NamedQuery namedQuery) {
        return this.getValidationSeverity(namedQuery) != 8;
    }

    public void validate(NamedQuery namedQuery, String jpqlQuery, String actualJpqlQuery, List<TextRange> textRanges, int offset, EscapeType escapeType, List<IMessage> messages) {
        try {
            if (this.shouldValidate(namedQuery)) {
                this.setQuery(namedQuery, jpqlQuery);
                String parsedJpqlQuery = this.getParsedJPQLQuery();
                for (JPQLQueryProblem problem : this.validate()) {
                    List<IMessage> results = this.buildProblems(namedQuery, textRanges, problem, parsedJpqlQuery, jpqlQuery, actualJpqlQuery, offset, escapeType);
                    messages.addAll(results);
                }
            }
        }
        finally {
            this.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeType {
        JAVA,
        NONE,
        XML;

    }
}

