/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateRelationAttributesTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        if (!cu.isWorkingCopy()) {
            try {
                cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return cu;
    }

    @Test
    public void testAddAnnotation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = JPACreateFactory.instance().createEntityInProject(this.jpaProject.getProject(), new String[]{"abc"}, "Customer");
        IFile addressFile = JPACreateFactory.instance().createEntityInProject(this.jpaProject.getProject(), new String[]{"abc"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("abc.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("abc.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(t1, t2, null, "add", "add", false);
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        PersistenceUnit pu = (PersistenceUnit)this.jpaProject.getContextModelRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        t1 = pu.getPersistentType("abc.Customer");
        Assert.assertNotNull((Object)attr);
    }

    @Test
    public void testAddOneToOneUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(t1, t2, null, "address", "address", false);
        Assert.assertNotNull((Object)attr);
        JpaArtifactFactory.instance().addOneToOneUnidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr);
        PersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute cPersistentAttribute = pt.resolveAttribute("address");
        Assert.assertNotNull((Object)cPersistentAttribute);
    }

    @Test
    public void testAddOneToOneBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        IFile creditCardFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "CreditCard");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)creditCardFile.exists());
        JavaResourceAbstractType creditCardType = this.jpaProject.getJavaResourceType("com.CreditCard");
        Assert.assertNotNull((Object)creditCardFile);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(t1, t2, null, "creditCard", "creditCard", false);
        Assert.assertNotNull((Object)attr);
        PersistentAttribute attr2 = JpaArtifactFactory.instance().addAttribute(t2, t1, null, "customer", "customer", false);
        Assert.assertNotNull((Object)attr2);
        JpaArtifactFactory.instance().addOneToOneBidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr, t2, attr2);
        PersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (ownerPersistentType == null) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("creditCard");
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(ownerSideMapping instanceof OneToOneMapping));
        Assert.assertTrue((boolean)((OneToOneMapping)ownerSideMapping).isRelationshipOwner());
        PersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getTypeBinding().getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("customer");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof OneToOneMapping));
        Assert.assertFalse((boolean)((OneToOneMapping)inverseSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddOneToManyUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        IFile phoneFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Phone");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerType);
        PersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)phoneFile.exists());
        JavaResourceAbstractType phoneType = this.jpaProject.getJavaResourceType("com.Phone");
        Assert.assertNotNull((Object)customerType);
        PersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getTypeBinding().getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(t1, t2, null, "phones", "phones", true);
        Assert.assertNotNull((Object)attr);
        JpaArtifactFactory.instance().addOneToManyUnidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr, false);
        PersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute cPersistentAttribute = pt.resolveAttribute("phones");
        Assert.assertNotNull((Object)cPersistentAttribute);
        AttributeMapping mapping = cPersistentAttribute.getMapping();
        Assert.assertNotNull((Object)mapping);
        Assert.assertTrue((boolean)(mapping instanceof OneToManyMapping));
        Assert.assertTrue((boolean)((OneToManyMapping)mapping).isRelationshipOwner());
    }

    @Test
    public void testAddOneToManyBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile cruiseFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cruise");
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)cruiseFile.exists());
        JavaResourceAbstractType cruiseType = this.jpaProject.getJavaResourceType("com.Cruise");
        Assert.assertNotNull((Object)cruiseType);
        PersistentType singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        while (singleSidePersistentType == null) {
            Thread.sleep(200L);
            singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationFile);
        PersistentType manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        while (manySidePersistentType == null) {
            Thread.sleep(200L);
            manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute singleSideAttribute = JpaArtifactFactory.instance().addAttribute(singleSidePersistentType, manySidePersistentType, null, "reservations", "reservations", true);
        Assert.assertNotNull((Object)singleSideAttribute);
        PersistentAttribute manySideAttribute = JpaArtifactFactory.instance().addAttribute(manySidePersistentType, singleSidePersistentType, null, "cruise", "cruise", false);
        Assert.assertNotNull((Object)manySideAttribute);
        JpaArtifactFactory.instance().addOneToManyBidirectionalRelation((IFeatureProvider)this.featureProvider, singleSidePersistentType, singleSideAttribute, manySidePersistentType, manySideAttribute, false);
        PersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("reservations");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof OneToManyMapping));
        Assert.assertFalse((boolean)((OneToManyMapping)inverseSideMapping).isRelationshipOwner());
        PersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        int c = 0;
        while (ownerPersistentType == null && c < 50) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
            ++c;
        }
        Assert.assertNotNull((Object)ownerPersistentType);
        PersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("cruise");
        c = 0;
        while (ownerPersistentAttribute == null && c < 50) {
            Thread.sleep(200L);
            ownerPersistentAttribute = ownerPersistentType.resolveAttribute("cruise");
            ++c;
        }
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        c = 0;
        while (ownerSideMapping == null && c < 50) {
            Thread.sleep(200L);
            ownerSideMapping = ownerPersistentAttribute.getMapping();
            ++c;
        }
        if (ownerSideMapping == null) {
            return;
        }
        Assert.assertNotNull((String)"ownerSideMapping must not be null", (Object)ownerSideMapping);
        Assert.assertTrue((String)("ownerSideMapping class is " + ownerSideMapping.getClass().getName()), (boolean)ManyToOneMapping.class.isInstance(ownerSideMapping));
        Assert.assertTrue((boolean)((ManyToOneMapping)ownerSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToOneUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile cruiseFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cruise");
        IFile shipFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Ship");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)cruiseFile.exists());
        JavaResourceAbstractType cruiseType = this.jpaProject.getJavaResourceType("com.Cruise");
        Assert.assertNotNull((Object)cruiseType);
        PersistentType manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        while (manySidePersistentType == null) {
            Thread.sleep(200L);
            manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)shipFile.exists());
        JavaResourceAbstractType shipType = this.jpaProject.getJavaResourceType("com.Ship");
        Assert.assertNotNull((Object)cruiseType);
        PersistentType singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getTypeBinding().getQualifiedName());
        while (singleSidePersistentType == null) {
            Thread.sleep(200L);
            singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute mappedAttribute = JpaArtifactFactory.instance().addAttribute(manySidePersistentType, singleSidePersistentType, null, "ship", "ship", true);
        Assert.assertNotNull((Object)mappedAttribute);
        JpaArtifactFactory.instance().addManyToOneUnidirectionalRelation((IFeatureProvider)this.featureProvider, manySidePersistentType, mappedAttribute);
        PersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getTypeBinding().getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute cPersistentAttribute = pt.resolveAttribute("ship");
        int cnt = 0;
        while (cPersistentAttribute == null && cnt < 100) {
            Thread.sleep(250L);
            cPersistentAttribute = pt.resolveAttribute("ship");
            ++cnt;
        }
        Assert.assertNotNull((Object)cPersistentAttribute);
        AttributeMapping mapping = cPersistentAttribute.getMapping();
        cnt = 0;
        while (mapping == null && cnt < 100) {
            Thread.sleep(250L);
            mapping = cPersistentAttribute.getMapping();
            ++cnt;
        }
        Assert.assertNotNull((Object)mapping);
        Assert.assertTrue((boolean)(mapping instanceof ManyToOneMapping));
        Assert.assertTrue((boolean)((ManyToOneMapping)mapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToManyBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationType);
        PersistentType ownerSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        while (ownerSidePersistentType == null) {
            Thread.sleep(200L);
            ownerSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerFile);
        PersistentType inverseSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (inverseSidePersistentType == null) {
            Thread.sleep(200L);
            inverseSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute ownerSideAttribute = JpaArtifactFactory.instance().addAttribute(ownerSidePersistentType, inverseSidePersistentType, null, "customers", "customers", true);
        Assert.assertNotNull((Object)ownerSideAttribute);
        PersistentAttribute inverseSideAttributes = JpaArtifactFactory.instance().addAttribute(inverseSidePersistentType, ownerSidePersistentType, null, "reservations", "reservations", true);
        Assert.assertNotNull((Object)inverseSideAttributes);
        JpaArtifactFactory.instance().addManyToManyBidirectionalRelation((IFeatureProvider)this.featureProvider, ownerSidePersistentType, ownerSideAttribute, inverseSidePersistentType, inverseSideAttributes, false);
        PersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        while (ownerPersistentType == null) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("customers");
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(ownerSideMapping instanceof ManyToManyMapping));
        Assert.assertTrue((boolean)((ManyToManyMapping)ownerSideMapping).isRelationshipOwner());
        PersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("reservations");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof ManyToManyMapping));
        Assert.assertFalse((boolean)((ManyToManyMapping)inverseSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToManyUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        IFile cabinFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cabin");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationType);
        PersistentType annotatedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        while (annotatedPersistentType == null) {
            Thread.sleep(200L);
            annotatedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        }
        Assert.assertTrue((boolean)cabinFile.exists());
        JavaResourceAbstractType cabinType = this.jpaProject.getJavaResourceType("com.Cabin");
        Assert.assertNotNull((Object)cabinFile);
        PersistentType referencedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cabinType.getTypeBinding().getQualifiedName());
        while (referencedPersistentType == null) {
            Thread.sleep(200L);
            referencedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cabinType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute annotatedSideAttribute = JpaArtifactFactory.instance().addAttribute(annotatedPersistentType, referencedPersistentType, null, "cabins", "cabins", true);
        Assert.assertNotNull((Object)annotatedSideAttribute);
        JpaArtifactFactory.instance().addManyToManyUnidirectionalRelation((IFeatureProvider)this.featureProvider, annotatedPersistentType, annotatedSideAttribute, false);
        PersistentType persistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        while (persistentType == null) {
            Thread.sleep(200L);
            persistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getTypeBinding().getQualifiedName());
        }
        PersistentAttribute persistentAttribute = persistentType.resolveAttribute("cabins");
        Assert.assertNotNull((Object)persistentAttribute);
        AttributeMapping mapping = persistentAttribute.getMapping();
        Assert.assertTrue((boolean)(mapping instanceof ManyToManyMapping));
        Assert.assertTrue((boolean)((ManyToManyMapping)mapping).isRelationshipOwner());
    }
}

