/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.collection.EmptyBag;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class BagTests
extends TestCase {
    public BagTests(String name) {
        super(name);
    }

    public void testEmptyBag_iterator() throws Exception {
        BagTests.assertFalse((boolean)EmptyBag.instance().iterator().hasNext());
    }

    public void testEmptyBag_size() throws Exception {
        BagTests.assertEquals((int)0, (int)EmptyBag.instance().size());
    }

    public void testEmptyBag_uniqueIterator() throws Exception {
        BagTests.assertFalse((boolean)EmptyBag.instance().uniqueIterator().hasNext());
    }

    public void testEmptyBag_uniqueCount() throws Exception {
        BagTests.assertEquals((int)0, (int)EmptyBag.instance().uniqueCount());
    }

    public void testEmptyBag_count() throws Exception {
        BagTests.assertEquals((int)0, (int)EmptyBag.instance().count((Object)"foo"));
    }

    public void testEmptyBag_entries() throws Exception {
        BagTests.assertFalse((boolean)EmptyBag.instance().entries().hasNext());
    }

    public void testEmptyBag_remove() throws Exception {
        BagTests.assertFalse((boolean)EmptyBag.instance().remove((Object)"foo", 3));
    }

    public void testEmptyBag_add() throws Exception {
        boolean exCaught = false;
        try {
            EmptyBag.instance().add((Object)"foo", 3);
            BagTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyBag_equals() throws Exception {
        BagTests.assertTrue((boolean)EmptyBag.instance().equals((Object)EmptyBag.instance()));
        BagTests.assertFalse((boolean)EmptyBag.instance().equals((Object)"foo"));
        HashBag bag = new HashBag();
        BagTests.assertTrue((boolean)EmptyBag.instance().equals((Object)bag));
        bag.add((Object)"foo");
        BagTests.assertFalse((boolean)EmptyBag.instance().equals((Object)bag));
    }

    public void testEmptyBag_hashCode() throws Exception {
        BagTests.assertEquals((int)0, (int)EmptyBag.instance().hashCode());
    }

    public void testEmptyBag_serialization() throws Exception {
        Bag xxx = TestTools.serialize(EmptyBag.instance());
        BagTests.assertSame((Object)EmptyBag.instance(), (Object)xxx);
    }
}

