/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.resource.java;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.internal.SimpleAnnotationProvider;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceTypeCompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.NullAnnotationEditFormatter;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.command.DefaultCommandContext;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaResourceModelTestCase
extends AnnotationTestCase {
    private JavaElementChangeListener javaElementChangeListener;
    protected JavaResourceCompilationUnit javaResourceCompilationUnit;

    public JavaResourceModelTestCase(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.javaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.javaElementChangeListener = null;
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.javaResourceCompilationUnit == null) {
            return;
        }
        this.syncWithJavaDelta(event.getDelta());
    }

    protected void syncWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.syncWithJavaDeltaChildren(delta);
                break;
            }
            case 5: {
                this.javaCompilationUnitChanged(delta);
                break;
            }
        }
    }

    protected void syncWithJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.syncWithJavaDelta(child);
            ++n2;
        }
    }

    protected void javaCompilationUnitChanged(IJavaElementDelta delta) {
        if (this.deltaIsRelevant(delta)) {
            this.javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected boolean deltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    protected ICompilationUnit createAnnotationAndMembers(String packageName, String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String packageName, String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    protected JavaResourcePackage buildJavaResourcePackage(ICompilationUnit cu) throws JavaModelException {
        SourcePackageInfoCompilationUnit pkgCu = new SourcePackageInfoCompilationUnit(cu, this.buildAndVerifyAnnotationProvider(), NullAnnotationEditFormatter.instance(), DefaultCommandContext.instance());
        this.javaResourceCompilationUnit = pkgCu;
        return pkgCu.getPackage();
    }

    protected JavaResourceType buildJavaResourceType(ICompilationUnit cu) throws JavaModelException {
        return (JavaResourceType)this.buildJavaResourceType_(cu);
    }

    protected JavaResourceEnum buildJavaResourceEnum(ICompilationUnit cu) throws JavaModelException {
        return (JavaResourceEnum)this.buildJavaResourceType_(cu);
    }

    private JavaResourceAbstractType buildJavaResourceType_(ICompilationUnit cu) throws JavaModelException {
        this.javaResourceCompilationUnit = this.buildJavaResourceCompilationUnit(cu);
        return this.hackJavaResourceType();
    }

    protected JavaResourceField getField(JavaResourceType type, int index) {
        return (JavaResourceField)IterableTools.get((Iterable)type.getFields(), (int)index);
    }

    protected JavaResourceMethod getMethod(JavaResourceType type, int index) {
        return (JavaResourceMethod)IterableTools.get((Iterable)type.getMethods(), (int)index);
    }

    protected JavaResourceEnumConstant getEnumConstant(JavaResourceEnum resourceEnum, int index) {
        return (JavaResourceEnumConstant)IterableTools.get((Iterable)resourceEnum.getEnumConstants(), (int)index);
    }

    protected JavaResourceAbstractType hackJavaResourceType() {
        return (JavaResourceAbstractType)ObjectTools.get((Object)this.javaResourceCompilationUnit, (String)"primaryType");
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit cu) throws JavaModelException {
        if (this.javaResourceCompilationUnit != null) {
            throw new IllegalStateException();
        }
        return new SourceTypeCompilationUnit(cu, this.buildAndVerifyAnnotationProvider(), NullAnnotationEditFormatter.instance(), DefaultCommandContext.instance());
    }

    protected AnnotationProvider buildAndVerifyAnnotationProvider() throws JavaModelException {
        AnnotationProvider annotationProvider = this.buildAnnotationProvider();
        this.verifyAnnotationClassesExist(annotationProvider);
        return annotationProvider;
    }

    protected AnnotationProvider buildAnnotationProvider() {
        return new SimpleAnnotationProvider(this.annotationDefinitions(), this.nestableAnnotationDefinitions());
    }

    protected abstract AnnotationDefinition[] annotationDefinitions();

    protected abstract NestableAnnotationDefinition[] nestableAnnotationDefinitions();

    private void verifyAnnotationClassesExist(AnnotationProvider annotationProvider) throws JavaModelException {
        for (String annotationName : this.getAllAnnotationNames(annotationProvider)) {
            if (this.getJavaProject().getJavaProject().findType(annotationName) != null || annotationName.equals("javax.annotation.Generated")) continue;
            JavaResourceModelTestCase.fail((String)JavaResourceModelTestCase.errorMissingAnnotationClass(annotationName));
        }
    }

    private Iterable<String> getAllAnnotationNames(AnnotationProvider annotationProvider) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{annotationProvider.getAnnotationNames(), annotationProvider.getContainerAnnotationNames(), annotationProvider.getNestableAnnotationNames()});
    }

    private static String errorMissingAnnotationClass(String annotationName) {
        return "Annotation class " + annotationName + " is not on the classpath. Check the Java system property org.eclipse.jpt.jpa.jar";
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JavaResourceModelTestCase.this.javaElementChanged(event);
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }
}

