/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlDiscriminatorNode;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlDiscriminatorNodeTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlDiscriminatorNodeTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    private ICompilationUnit createTypeWithXmlDiscriminatorNode() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlDiscriminatorNode").append(CR);
            }
        });
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlDiscriminatorNode();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        ELXmlDiscriminatorNode discNode = classMapping.getXmlDiscriminatorNode();
        XmlDiscriminatorNodeAnnotation annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)discNode.getValue());
        discNode.setValue("foo");
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"foo", (String)discNode.getValue());
        discNode.setValue("");
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"", (String)discNode.getValue());
        discNode.setValue(null);
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)discNode.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlDiscriminatorNode();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        ELXmlDiscriminatorNode discNode = classMapping.getXmlDiscriminatorNode();
        XmlDiscriminatorNodeAnnotation annotation = (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)discNode.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode", "foo");
            }
        });
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"foo", (String)discNode.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorNodeTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode", "");
            }
        });
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertEquals((String)"", (String)discNode.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorNodeTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
            }
        });
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorNodeTests.assertNull((Object)discNode.getValue());
    }
}

