/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaPackageInfoTests
extends JaxbContextModelTestCase {
    public GenericJavaPackageInfoTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorType() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorType(value = XmlAccessType.PROPERTY)", new String[]{"javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
    }

    private ICompilationUnit createPackageInfoWithAccessorOrder() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)", new String[]{"javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
    }

    public void testModifyAccessType() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)contextPackageInfo.getSpecifiedAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)contextPackageInfo.getAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        XmlAccessorTypeAnnotation accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaPackageInfoTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.FIELD, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.FIELD, (Object)contextPackageInfo.getAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.PUBLIC_MEMBER);
        GenericJavaPackageInfoTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.PUBLIC_MEMBER, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaPackageInfoTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.NONE, (Object)accessorTypeAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.NONE, (Object)contextPackageInfo.getAccessType());
        contextPackageInfo.setSpecifiedAccessType(null);
        accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaPackageInfoTests.assertNull((Object)accessorTypeAnnotation.getValue());
        GenericJavaPackageInfoTests.assertNull((Object)contextPackageInfo.getSpecifiedAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getDefaultAccessType());
    }

    public void testUpdateAccessType() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)contextPackageInfo.getSpecifiedAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)contextPackageInfo.getAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getDefaultAccessType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.FIELD");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.FIELD, (Object)contextPackageInfo.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.NONE");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.NONE, (Object)contextPackageInfo.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlAccessorTypeAnnotation(declaration);
            }
        });
        GenericJavaPackageInfoTests.assertNull((Object)contextPackageInfo.getSpecifiedAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getAccessType());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)contextPackageInfo.getDefaultAccessType());
    }

    public void testModifyAccessOrder() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)contextPackageInfo.getSpecifiedAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)contextPackageInfo.getAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getDefaultAccessOrder());
        contextPackageInfo.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        XmlAccessorOrderAnnotation accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaPackageInfoTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessOrder.UNDEFINED, (Object)accessorOrderAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getAccessOrder());
        contextPackageInfo.setSpecifiedAccessOrder(null);
        accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaPackageInfoTests.assertNull((Object)accessorOrderAnnotation.getValue());
        GenericJavaPackageInfoTests.assertNull((Object)contextPackageInfo.getSpecifiedAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getDefaultAccessOrder());
    }

    public void testUpdateAccessOrder() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)contextPackageInfo.getSpecifiedAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)contextPackageInfo.getAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getDefaultAccessOrder());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorOrder", "javax.xml.bind.annotation.XmlAccessOrder.UNDEFINED");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getAccessOrder());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlAccessorOrderAnnotation(declaration);
            }
        });
        GenericJavaPackageInfoTests.assertNull((Object)contextPackageInfo.getSpecifiedAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getAccessOrder());
        GenericJavaPackageInfoTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)contextPackageInfo.getDefaultAccessOrder());
    }

    protected void removeXmlAccessorTypeAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchema");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
    }

    protected void removeXmlAccessorOrderAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchema");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorOrder");
    }

    public void testGetXmlSchemaTypes() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 0, "bar");
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 1, "foo");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        ListIterator xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
    }

    protected void addXmlSchemaType(ModifiedDeclaration declaration, int index, String name) {
        NormalAnnotation arrayElement = this.newXmlSchemaTypeAnnotation(declaration.getAst(), name);
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlSchemaTypes", index, "value", (Expression)arrayElement);
    }

    protected NormalAnnotation newXmlSchemaTypeAnnotation(AST ast, String name) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "javax.xml.bind.annotation.XmlSchemaType");
        this.addMemberValuePair(annotation, "name", name);
        return annotation;
    }

    public void testGetXmlSchemaTypesSize() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((int)0, (int)contextPackageInfo.getXmlSchemaTypesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 0, "bar");
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 1, "foo");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((int)2, (int)contextPackageInfo.getXmlSchemaTypesSize());
    }

    public void testAddXmlSchemaType() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("bar");
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("foo");
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("baz");
        Iterator<XmlSchemaTypeAnnotation> xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
    }

    protected Iterator<XmlSchemaTypeAnnotation> getSchemaTypeAnnotations(JavaResourcePackage resourcePackage) {
        return new SubListIterableWrapper(resourcePackage.getAnnotations("javax.xml.bind.annotation.XmlSchemaType")).iterator();
    }

    public void testAddXmlSchemaType2() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("bar");
        contextPackageInfo.addXmlSchemaType(1).getQName().setSpecifiedName("foo");
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("baz");
        Iterator<XmlSchemaTypeAnnotation> xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
    }

    public void testRemoveXmlSchemaType() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("bar");
        contextPackageInfo.addXmlSchemaType(1).getQName().setSpecifiedName("foo");
        contextPackageInfo.addXmlSchemaType(2).getQName().setSpecifiedName("baz");
        Iterator<XmlSchemaTypeAnnotation> xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
        contextPackageInfo.removeXmlSchemaType(1);
        xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
        contextPackageInfo.removeXmlSchemaType(1);
        xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
        contextPackageInfo.removeXmlSchemaType(0);
        xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
    }

    public void testMoveXmlSchemaType() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlSchemaType(0).getQName().setSpecifiedName("bar");
        contextPackageInfo.addXmlSchemaType(1).getQName().setSpecifiedName("foo");
        contextPackageInfo.addXmlSchemaType(2).getQName().setSpecifiedName("baz");
        Iterator<XmlSchemaTypeAnnotation> xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
        contextPackageInfo.moveXmlSchemaType(2, 0);
        xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
        contextPackageInfo.moveXmlSchemaType(0, 1);
        xmlSchemaTypes = this.getSchemaTypeAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlSchemaTypes.next().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.hasNext());
    }

    public void testSyncXmlSchemaTypes() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 0, "bar");
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 1, "foo");
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 2, "baz");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        ListIterator xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.moveXmlSchemaType(declaration, 2, 0);
            }
        });
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.moveXmlSchemaType(declaration, 0, 1);
            }
        });
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlSchemaType(declaration, 1);
            }
        });
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlSchemaType(declaration, 1);
            }
        });
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlSchemaType(declaration, 0);
            }
        });
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
    }

    public void testSyncAddXmlSchemaTypes() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypes.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 0, "bar");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        ListIterator xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 1, "foo");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 2, "baz");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlSchemaType(declaration, 0, "foobaz");
            }
        });
        xmlSchemaTypes = contextPackageInfo.getXmlSchemaTypes();
        xmlSchemaTypesIterator = xmlSchemaTypes.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlSchemaTypesIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"foobaz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlSchemaType)xmlSchemaTypesIterator.next()).getQName().getName());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlSchemaTypesIterator.hasNext());
    }

    protected void moveXmlSchemaType(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSchemaTypes"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlSchemaType(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSchemaTypes"), "value", index);
    }

    public void testGetXmlJavaTypeAdapters() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 0, "String");
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 1, "Integer");
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        ListIterator xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"String", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"Integer", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
    }

    protected void addXmlJavaTypeAdapter(ModifiedDeclaration declaration, int index, String name) {
        NormalAnnotation arrayElement = this.newXmlJavaTypeAdapterAnnotation(declaration.getAst(), name);
        this.addArrayElement(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters", index, "value", (Expression)arrayElement);
    }

    protected NormalAnnotation newXmlJavaTypeAdapterAnnotation(AST ast, String valueTypeName) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        this.addMemberValuePair(annotation, "value", (Expression)this.newTypeLiteral(ast, valueTypeName));
        return annotation;
    }

    public void testGetXmlJavaTypeAdaptersSize() throws Exception {
        this.createPackageInfoWithAccessorOrder();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaPackageInfoTests.assertEquals((int)0, (int)contextPackageInfo.getXmlJavaTypeAdaptersSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 0, "String");
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 1, "Integer");
            }
        });
        GenericJavaPackageInfoTests.assertEquals((int)2, (int)contextPackageInfo.getXmlJavaTypeAdaptersSize());
    }

    public void testAddXmlJavaTypeAdapter() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("bar");
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("foo");
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("baz");
        Iterator<XmlJavaTypeAdapterAnnotation> xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
    }

    protected Iterator<XmlJavaTypeAdapterAnnotation> getXmlJavaTypeAdapterAnnotations(JavaResourcePackage resourcePackage) {
        return new SubListIterableWrapper(resourcePackage.getAnnotations("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter")).iterator();
    }

    public void testAddXmlJavaTypeAdapter2() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("bar");
        contextPackageInfo.addXmlJavaTypeAdapter(1).setValue("foo");
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("baz");
        Iterator<XmlJavaTypeAdapterAnnotation> xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
    }

    public void testRemoveXmlJavaTypeAdapter() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("String");
        contextPackageInfo.addXmlJavaTypeAdapter(1).setValue("foo");
        contextPackageInfo.addXmlJavaTypeAdapter(2).setValue("baz");
        Iterator<XmlJavaTypeAdapterAnnotation> xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        XmlJavaTypeAdapterAnnotation adapterAnnotation = xmlJavaTypeAdapters.next();
        GenericJavaPackageInfoTests.assertEquals((String)"String", (String)adapterAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"java.lang.String", (String)adapterAnnotation.getFullyQualifiedValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
        contextPackageInfo.removeXmlJavaTypeAdapter(1);
        xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        adapterAnnotation = xmlJavaTypeAdapters.next();
        GenericJavaPackageInfoTests.assertEquals((String)"String", (String)adapterAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"java.lang.String", (String)adapterAnnotation.getFullyQualifiedValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
        contextPackageInfo.removeXmlJavaTypeAdapter(1);
        xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        adapterAnnotation = xmlJavaTypeAdapters.next();
        GenericJavaPackageInfoTests.assertEquals((String)"String", (String)adapterAnnotation.getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"java.lang.String", (String)adapterAnnotation.getFullyQualifiedValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
        contextPackageInfo.removeXmlJavaTypeAdapter(0);
        xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
    }

    public void testMoveXmlJavaTypeAdapter() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextPackageInfo.addXmlJavaTypeAdapter(0).setValue("bar");
        contextPackageInfo.addXmlJavaTypeAdapter(1).setValue("foo");
        contextPackageInfo.addXmlJavaTypeAdapter(2).setValue("baz");
        Iterator<XmlJavaTypeAdapterAnnotation> xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
        contextPackageInfo.moveXmlJavaTypeAdapter(2, 0);
        xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
        contextPackageInfo.moveXmlJavaTypeAdapter(0, 1);
        xmlJavaTypeAdapters = this.getXmlJavaTypeAdapterAnnotations(resourcePackage);
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)xmlJavaTypeAdapters.next().getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.hasNext());
    }

    public void testSyncXmlJavaTypeAdapters() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdapters.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 0, "bar");
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 1, "foo");
                GenericJavaPackageInfoTests.this.addXmlJavaTypeAdapter(declaration, 2, "baz");
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        ListIterator xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.moveXmlJavaTypeAdapter(declaration, 2, 0);
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.moveXmlJavaTypeAdapter(declaration, 0, 1);
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"foo", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlJavaTypeAdapter(declaration, 1);
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertEquals((String)"bar", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlJavaTypeAdapter(declaration, 1);
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertTrue((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        GenericJavaPackageInfoTests.assertEquals((String)"baz", (String)((XmlJavaTypeAdapter)xmlJavaTypeAdaptersIterator.next()).getValue());
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaPackageInfoTests.this.removeXmlJavaTypeAdapter(declaration, 0);
            }
        });
        xmlJavaTypeAdapters = contextPackageInfo.getXmlJavaTypeAdapters();
        xmlJavaTypeAdaptersIterator = xmlJavaTypeAdapters.iterator();
        GenericJavaPackageInfoTests.assertFalse((boolean)xmlJavaTypeAdaptersIterator.hasNext());
    }

    protected void moveXmlJavaTypeAdapter(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlJavaTypeAdapter(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters"), "value", index);
    }
}

