/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlValueAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlValueAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlValueAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlValue"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlValue");
            }
        });
    }

    public void testGetXmlValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlValueAnnotation xmlValueAnnotation = (XmlValueAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlValue");
        XmlValueAnnotationTests.assertTrue((xmlValueAnnotation != null ? 1 : 0) != 0);
        resourceAttribute.removeAnnotation("javax.xml.bind.annotation.XmlValue");
        this.assertSourceDoesNotContain("@XmlValue", cu);
    }
}

