/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaEmbeddedMappingTests
extends ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(JavaEmbeddedMappingTests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public JavaEmbeddedMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaEmbeddedMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedMappingTests.assertTrue((boolean)((EmbeddedMapping)persistentAttribute.getMapping()).getAttributeOverrideContainer().getOverrides().iterator().hasNext());
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testDefaultEmbeddedMappingGenericEmbeddable() throws Exception {
        this.createTestEntityWithDefaultEmbeddedMapping();
        this.createTestGenericEmbeddable();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Embeddable1");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedMappingTests.assertNotNull((Object)persistentAttribute.getMapping());
        JavaEmbeddedMappingTests.assertEquals((String)"embedded", (String)persistentAttribute.getDefaultMappingKey());
        JavaEmbeddedMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    private void createTestEntityWithDefaultEmbeddedMapping() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 { ").append(CR);
                sb.append("private Embeddable1<Integer> myEmbeddable;").append(CR);
                sb.append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericEmbeddable() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class Embeddable1<T> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Embeddable1.java", sourceWriter);
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        JavaEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaEmbeddedMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaEmbeddedMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedMapping embeddedMapping = (JavaEmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)((JavaSpecifiedAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        JavaEmbeddedMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaEmbeddedMappingTests.assertEquals((String)"myEmbedded", (String)resourceField.getName());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        AttributeOverride defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTableName());
        JavaEmbeddedMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTableName("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        JavaEmbeddedMappingTests.assertEquals((String)"myEmbedded", (String)resourceField.getName());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTableName());
        JavaEmbeddedMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTableName(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (AttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTableName());
        JavaEmbeddedMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("state");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((SpecifiedAttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).getName());
        JavaEmbeddedMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ((SpecifiedAttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((VirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverrides.next();
        ((VirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)this.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableZipCode();
        this.addXmlClassRef("test.Customer");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.ZipCode");
        ListIterator specifiedClassRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        JavaPersistentType customerPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaEmbeddedMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEmbeddedMappingTests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEmbeddedMappingTests.assertEquals((String)"city", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEmbeddedMappingTests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverrides.hasNext());
        JavaPersistentType addressPersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        JavaEmbeddedMappingTests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEmbeddedMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        JavaEmbeddedMappingTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        JavaPersistentType zipCodePersistentType = ((ClassRef)specifiedClassRefs.next()).getJavaPersistentType();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTableName("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour");
        JavaEmbeddedMappingTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        JavaEmbeddedMappingTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        JavaEmbeddedMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedMappingTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        JavaEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        JavaEmbeddedMappingTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        JavaEmbeddedMappingTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedMappingTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getOverrideNamed("zipCode.plusfour");
    }
}

