/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsIdAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOneAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaOneToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaOneToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(orphanRemoval=false)");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        SpecifiedJoinColumnRelationshipStrategy joinColumns = oneToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)oneToOneMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceField.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        DerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        DerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        ((MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId")).setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return oneToOneMapping.getOrphanRemoval();
    }

    public void testDefaultOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)this.getOrphanRemovalOf(oneToOneMapping).getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToOne.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericJavaOneToOneMapping2_0Tests.assertSame((Object)oneToOneMapping, (Object)persistentAttribute.getMapping());
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        resourceField.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationship2_0 rel = (OneToOneRelationship2_0)mapping.getRelationship();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToPrimaryKeyJoinColumn();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToMappedBy();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE)).getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationship2_0 rel = (OneToOneRelationship2_0)mapping.getRelationship();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }
}

