/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.VirtualOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmSpecifiedOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmAssociationOverride2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany");
                sb.append(CR);
                sb.append("    private java.util.Collection<AnnotationTestTypeChild> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public GenericOrmAssociationOverride2_0Tests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride ormVirtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormVirtualAssociationOverride.getName());
        ormVirtualAssociationOverride.convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)xmlAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertTrue((boolean)overrideContainer.getOverrides().iterator().hasNext());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)entityResource.getAssociationOverrides().isEmpty());
        xmlAssociationOverride.setName("FOO");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName(null);
        GenericOrmAssociationOverride2_0Tests.assertNull((Object)ormAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertNull((Object)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName("FOO");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        entityResource.getAssociationOverrides().remove(0);
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)overrideContainer.getSpecifiedOverrides().iterator().hasNext());
        GenericOrmAssociationOverride2_0Tests.assertTrue((boolean)entityResource.getAssociationOverrides().isEmpty());
    }

    public void testModifyName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride virtualAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)specifiedAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)xmlAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertTrue((boolean)overrideContainer.getOverrides().iterator().hasNext());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)entityResource.getAssociationOverrides().isEmpty());
        specifiedAssociationOverride.setName("foo");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"foo", (String)specifiedAssociationOverride.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"foo", (String)xmlAssociationOverride.getName());
        specifiedAssociationOverride.setName(null);
        GenericOrmAssociationOverride2_0Tests.assertNull((Object)specifiedAssociationOverride.getName());
        xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        GenericOrmAssociationOverride2_0Tests.assertNull((Object)xmlAssociationOverride.getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride ormAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormAssociationOverride.getName());
        OrmSpecifiedAssociationOverride specifiedOverride = ormAssociationOverride.convertToSpecified();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmSpecifiedJoinColumn joinColumn = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmSpecifiedJoinColumn joinColumn2 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmSpecifiedJoinColumn joinColumn3 = joiningStrategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericOrmAssociationOverride2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericOrmAssociationOverride2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride ormAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormAssociationOverride.getName());
        OrmSpecifiedAssociationOverride specifiedOverride = ormAssociationOverride.convertToSpecified();
        SpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)1, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)4, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)3, (int)xmlAssociationOverride.getJoinColumns().size());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)2, (int)xmlAssociationOverride.getJoinColumns().size());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)1, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)0, (int)xmlAssociationOverride.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride ormAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormAssociationOverride.getName());
        OrmSpecifiedAssociationOverride specifiedOverride = ormAssociationOverride.convertToSpecified();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)4, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        joiningStrategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        OrmVirtualAssociationOverride ormAssociationOverride = (OrmVirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address", (String)ormAssociationOverride.getName());
        OrmSpecifiedAssociationOverride specifiedOverride = ormAssociationOverride.convertToSpecified();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinColumns.next();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)joinColumn.getSpecifiedName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"id", (String)joinColumn.getSpecifiedReferencedColumnName());
        xmlAssociationOverride.getJoinColumns().add(0, (Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinColumns().add(1, (Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinColumns().add(2, (Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).setName("BAZ");
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(2, 0);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(0, 1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(0);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"address_id", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        xmlAssociationOverride.getJoinColumns().remove(0);
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joiningStrategy.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"AnnotationTestTypeChild", (String)ormEntity.getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmAssociationOverride2_0Tests.assertTrue((boolean)associationOverride.isVirtual());
    }

    public void testSetJoinTableName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        OrmVirtualAssociationOverride virtualOverride = (OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        OrmSpecifiedAssociationOverride associationOverride = virtualOverride.convertToSpecified();
        ((SpecifiedOverrideRelationship2_0)associationOverride.getRelationship()).setStrategyToJoinTable();
        SpecifiedJoinTableRelationshipStrategy joiningStrategy = ((SpecifiedOverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        SpecifiedJoinTable joinTable = joiningStrategy.getJoinTable();
        joinTable.setSpecifiedName("FOO");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getJoinTable().getName());
    }

    public void testUpdateJoinTable() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        OrmVirtualAssociationOverride virtualOverride = (OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        OrmSpecifiedAssociationOverride associationOverride = virtualOverride.convertToSpecified();
        ((OrmSpecifiedOverrideRelationship2_0)associationOverride.getRelationship()).setStrategyToJoinTable();
        OrmSpecifiedJoinTableRelationshipStrategy joiningStrategy = ((OrmSpecifiedOverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        xmlAssociationOverride.getJoinTable().setName("MY_JOIN_TABLE");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)joiningStrategy.getJoinTable().getSpecifiedName());
        xmlAssociationOverride.getJoinTable().getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinTable().getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinTable().getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)xmlAssociationOverride.getJoinTable().getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinTable().getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinTable().getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinTable().getJoinColumns().move(2, 0);
        joinColumns = joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinTable().getJoinColumns().move(0, 1);
        joinColumns = joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinTable().getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinTable().getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinTable().getJoinColumns().remove(0);
        GenericOrmAssociationOverride2_0Tests.assertFalse((boolean)joiningStrategy.getJoinTable().getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testDefaultJoinTableName() throws Exception {
        this.createTestMappedSuperclassManyToMany();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        VirtualJoinTableRelationshipStrategy joiningStrategy = ((VirtualOverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy();
        VirtualJoinTable joinTable = joiningStrategy.getJoinTable();
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"AnnotationTestTypeChild_AnnotationTestTypeChild", (String)joinTable.getName());
        ormEntity.getTable().setSpecifiedName("FOO");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"FOO_FOO", (String)joinTable.getName());
        PersistentType mappedSuperclass = ormPersistentType.getSuperPersistentType();
        ((OrmPersistentAttribute)mappedSuperclass.getAttributeNamed("address")).addToXml();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)mappedSuperclass.getAttributeNamed("address").getMapping();
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("BAR");
        GenericOrmAssociationOverride2_0Tests.assertEquals((String)"BAR", (String)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().getName());
    }
}

