/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.VirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.EmbeddedMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.VirtualOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaEmbeddedMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaSpecifiedOverrideRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmEmbeddedMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmEmbeddedMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";
    private static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    private static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    public GenericOrmEmbeddedMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityEmbeddedMappingAttributeOverrides() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericOrmEmbeddedMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    private void createAddressEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Address {");
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress2() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    private void createSelfReferentialEmbedded() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Foo embedded;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)embeddedResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(0);
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "embedded");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        ormEmbeddedMapping.setName("foo");
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"foo", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getVirtualOverrides().iterator().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("address");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        AttributeOverride attributeOverride = (AttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaEmbeddedMapping javaEmbeddedMapping = (JavaEmbeddedMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaSpecifiedColumn javaAttributeOverrideColumn = ((JavaSpecifiedAttributeOverride)javaEmbeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTableName("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType2.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        attributeOverride = (AttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("address").addToXml();
        embeddedMapping = (OrmEmbeddedMapping)persistentType.getAttributeNamed("address").getMapping();
        attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        AttributeOverride virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualOverride.getName());
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualOverride.getColumn().getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualOverride.getColumn().getScale());
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)virtualOverride.getColumn().getDefaultName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualOverride.getColumn().getDefaultTableName());
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualOverride.getName());
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)((SpecifiedAttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualOverride.getName());
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualOverride.getName());
        virtualOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EmbeddedMapping virtualEmbeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        AttributeOverrideContainer attributeOverrideContainer = virtualEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        AttributeOverride override = (AttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)override.getName());
        Column column = override.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)column.getSpecifiedName());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        override = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)override.getName());
        column = override.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)column.getName());
        override = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)override.getName());
        column = override.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"A_STATE", (String)column.getName());
        override = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)override.getName());
        column = override.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)column.getName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        EmbeddedMapping virtualEmbeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualEmbeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "embedded");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)ormEmbeddedMapping.getAttributeOverrideContainer().getSpecifiedOverridesSize());
    }

    public void testEmbeddedMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (SpecifiedAttributeOverride)((EmbeddedIdMapping)ormPersistentAttribute.getMapping()).getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"override", (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        SpecifiedAttributeOverride attributeOverride = (SpecifiedAttributeOverride)embeddedMapping.getAttributeOverrideContainer().getSpecifiedOverrides().iterator().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("FOO");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(1, (Object)associationOverride);
        associationOverride.setName("BAR");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("BAZ");
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(1, 0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmSpecifiedAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        VirtualJoinColumnRelationshipStrategy joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        VirtualJoinColumn virtualJoinColumn = (VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address_id", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        JavaPersistentType javaEmbeddable = ((ClassRef)this.getPersistenceUnit().getSpecifiedClassRefs().iterator().next()).getJavaPersistentType();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)javaEmbeddable.getAttributeNamed("address").getMapping();
        SpecifiedJoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTableName("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        joiningStrategy = virtualAssociationOverride.getRelationship().getJoinColumnStrategy();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.getJoinColumnsSize());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        virtualJoinColumn = (VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)((VirtualJoinColumn)joiningStrategy.getJoinColumns().iterator().next()).getName());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("FOO");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("BAR");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getSpecifiedOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.getVirtualOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getOverridesSize());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("bar");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)overrideContainer.getOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverrides.next();
        ((OrmVirtualAssociationOverride)virtualAssociationOverrides.next()).convertToSpecified();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
        ((OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)embeddedResource.getAssociationOverrides().size());
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((OrmSpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)embeddedResource.getAssociationOverrides().size());
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
        overrideContainer.moveSpecifiedOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        overrideContainer.moveSpecifiedOverride(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("FOO");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(1, (Object)associationOverride);
        associationOverride.setName("BAR");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(2, (Object)associationOverride);
        associationOverride.setName("BAZ");
        ListIterator associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(2, 0);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(0, 1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        associationOverrides = overrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((OrmVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.getVirtualOverrides().iterator();
        virtualAssociationOverride = (VirtualAssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideJoinTableDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("myEmbedded"), "embedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)IterableTools.get((Iterable)overrideContainer.getVirtualOverrides(), (int)1);
        VirtualJoinTableRelationshipStrategy joiningStrategy = ((VirtualOverrideRelationship2_0)virtualAssociationOverride.getRelationship()).getJoinTableStrategy();
        VirtualJoinTable joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joinTable.getJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        JoinColumn virtualInverseJoinColumn = (JoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses_id", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isNullable());
        JavaPersistentType javaEmbeddable = ((ClassRef)this.getPersistenceUnit().getSpecifiedClassRefs().iterator().next()).getJavaPersistentType();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)javaEmbeddable.getAttributeNamed("addresses").getMapping();
        SpecifiedJoinTableRelationshipStrategy joinTableStrategy = oneToManyMapping.getRelationship().getJoinTableStrategy();
        joinTableStrategy.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        SpecifiedJoinColumn joinColumn = joinTableStrategy.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTableName("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        SpecifiedJoinColumn inverseJoinColumn = joinTableStrategy.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("MY_INVERSE_JOIN_COLUMN");
        inverseJoinColumn.setSpecifiedReferencedColumnName("MY_INVERSE_REFERENCE_COLUMN");
        inverseJoinColumn.setSpecifiedTableName("INVERSE_BAR");
        inverseJoinColumn.setColumnDefinition("INVERSE_COLUMN_DEF");
        inverseJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUnique(Boolean.TRUE);
        inverseJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)IterableTools.get((Iterable)overrideContainer.getVirtualOverrides(), (int)1);
        joiningStrategy = ((VirtualOverrideRelationship2_0)virtualAssociationOverride.getRelationship()).getJoinTableStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.getJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        JavaEmbeddedMapping2_0 javaEmbeddedMapping = (JavaEmbeddedMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ListIterator javaAssociationOverrides = javaEmbeddedMapping.getAssociationOverrideContainer().getOverrides().iterator();
        javaAssociationOverrides.next();
        JavaSpecifiedAssociationOverride javaAssociationOverride = ((JavaVirtualAssociationOverride)javaAssociationOverrides.next()).convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)javaAssociationOverride.getName());
        JavaSpecifiedJoinTable javaJoinTable = ((JavaSpecifiedOverrideRelationship2_0)javaAssociationOverride.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("JAVA_FOO");
        JavaSpecifiedJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("JAVA_JOIN_COLUMN_NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("JAVA_JOIN_COLUMN_REFERENCED_NAME");
        JavaSpecifiedJoinColumn javaInverseJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        javaInverseJoinColumn.setSpecifiedName("JAVA_INVERSE_JOIN_COLUMN_NAME");
        javaInverseJoinColumn.setSpecifiedReferencedColumnName("JAVA_INVERSE_JOIN_COLUMN_REFERENCED_NAME");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.getVirtualOverridesSize());
        virtualAssociationOverride = (VirtualAssociationOverride)IterableTools.get((Iterable)overrideContainer.getVirtualOverrides(), (int)1);
        joiningStrategy = ((VirtualOverrideRelationship2_0)virtualAssociationOverride.getRelationship()).getJoinTableStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getJoinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.getJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.getInverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride.convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        ormPersistentAttribute.removeFromXml();
        EmbeddedMapping2_0 virtualEmbeddedMapping = (EmbeddedMapping2_0)ormPersistentType.getAttributeNamed("myEmbedded").getMapping();
        overrideContainer = virtualEmbeddedMapping.getAssociationOverrideContainer();
        SpecifiedAssociationOverride associationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)associationOverride.getName());
        JoinTableRelationshipStrategy strategy = ((OverrideRelationship2_0)associationOverride.getRelationship()).getJoinTableStrategy();
        joinTable = strategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)joinTable.getJoinColumnsSize());
        ListIterator joinColumns = joinTable.getJoinColumns().iterator();
        virtualJoinColumn = (JoinColumn)joinColumns.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_JOIN_COLUMN_NAME", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_JOIN_COLUMN_REFERENCED_NAME", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)virtualJoinColumn.getTableName());
        virtualJoinColumn = (JoinColumn)joinColumns.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)joinTable.getInverseJoinColumnsSize());
        ListIterator inverseJoinColumns = joinTable.getInverseJoinColumns().iterator();
        virtualInverseJoinColumn = (JoinColumn)inverseJoinColumns.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_INVERSE_JOIN_COLUMN_NAME", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_INVERSE_JOIN_COLUMN_REFERENCED_NAME", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)virtualInverseJoinColumn.getTableName());
        virtualInverseJoinColumn = (JoinColumn)inverseJoinColumns.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTableName());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress2();
        this.createTestEmbeddableZipCode();
        OrmPersistentType customerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Customer");
        OrmPersistentType addressPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType zipCodePersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        customerPersistentType.getAttributeNamed("address").addToXml();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverrideContainer.getVirtualOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTableName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        addressPersistentType.getAttributeNamed("zipCode").addToXml();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.getVirtualOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.getVirtualOverrides().iterator();
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        zipCodePersistentType.getAttributeNamed("plusfour").addToXml();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTableName("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = (VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = (VirtualAttributeOverride)((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getOverrideNamed("zipCode.plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        SpecifiedAttributeOverride specifiedAttributeOverride = ((VirtualAttributeOverride)((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getOverrideNamed("plusfour")).convertToSpecified();
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTableName("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        virtualAttributeOverride = (VirtualAttributeOverride)((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getOverrideNamed("zipCode.plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.convertToSpecified();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedTableName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testSelfReferentialEmbeddedMapping() throws Exception {
        this.createSelfReferentialEmbedded();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Foo");
        EmbeddedMapping2_0 embeddedMapping = (EmbeddedMapping2_0)persistentType.getAttributeNamed("embedded").getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.getAllOverridableAttributeMappingNames().iterator().hasNext());
    }
}

