/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.NamedStoredProcedureQueryAnnotation2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.StoredProcedureParameterAnnotation2_1;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.resource.java.JavaResourceModel2_1TestCase;

public class NamedStoredProcedureQueries2_1AnnotationTests
extends JavaResourceModel2_1TestCase {
    private static final String QUERY_NAME = "myQuery";
    private static final String QUERY_PROCEDURE_NAME = "myProcedure";

    public NamedStoredProcedureQueries2_1AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedStoredProcedureQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery)");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithName() throws Exception {
        return this.createTestQueryWithStringElement("name", QUERY_NAME);
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithProcedureName() throws Exception {
        return this.createTestQueryWithStringElement("procedureName", QUERY_PROCEDURE_NAME);
    }

    private ICompilationUnit createTestQueryWithStringElement(final String elementName, final String value) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery(" + elementName + " = \"" + value + "\"))");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithParameters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.StoredProcedureParameter", "javax.persistence.ParameterMode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery(parameters = {@StoredProcedureParameter(name = \"BAR\", mode=ParameterMode.IN, type=Integer.class), @StoredProcedureParameter}))");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithResultClasses() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery(resultClasses={Employee.class, Address.class})");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithResultSetMappings() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery(resultSetMappings={\"EmployeeResultSetMapping\", \"AddressResultSetMapping\"})");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQueryWithHints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQueries", "javax.persistence.NamedStoredProcedureQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQueries(@NamedStoredProcedureQuery(hints = {@QueryHint(name = \"BAR\", value = \"FOO\"), @QueryHint}))");
            }
        });
    }

    private ICompilationUnit createTestNamedStoredProcedureQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedStoredProcedureQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))");
            }
        });
    }

    public void testNamedStoredProcedureQuery() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertNotNull((Object)namedQuery);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)QUERY_NAME, (String)namedQuery.getName());
        namedQuery.setName("foo");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"foo", (String)namedQuery.getName());
        this.assertSourceContains("@NamedStoredProcedureQuery(name = \"foo\")", cu);
        namedQuery.setName(null);
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)namedQuery.getName());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testGetProcedureName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithProcedureName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)QUERY_PROCEDURE_NAME, (String)namedQuery.getProcedureName());
    }

    public void testSetProcedureName() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithProcedureName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)QUERY_PROCEDURE_NAME, (String)namedQuery.getProcedureName());
        namedQuery.setProcedureName("foo");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"foo", (String)namedQuery.getProcedureName());
        this.assertSourceContains("@NamedStoredProcedureQuery(procedureName = \"foo\")", cu);
        namedQuery.setProcedureName(null);
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)namedQuery.getProcedureName());
        this.assertSourceDoesNotContain("@NamedStoredProcedureQuery(", cu);
    }

    public void testParameters1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getParametersSize());
    }

    public void testParameters2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithParameters();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getParametersSize());
        ListIterator iterator = namedQuery.getParameters().iterator();
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"BAR", (String)((StoredProcedureParameterAnnotation2_1)iterator.next()).getName());
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)((StoredProcedureParameterAnnotation2_1)iterator.next()).getName());
    }

    public void testResultClasses1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultClassesSize());
    }

    public void testResultClasses2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultClasses();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultClassesSize());
        ListIterator iterator = namedQuery.getResultClasses().iterator();
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"Employee", (String)((String)iterator.next()));
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"Address", (String)((String)iterator.next()));
    }

    public void testResultSetMappings1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getResultSetMappingsSize());
    }

    public void testResultSetMappings2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithResultSetMappings();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getResultSetMappingsSize());
        ListIterator iterator = namedQuery.getResultSetMappings().iterator();
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"EmployeeResultSetMapping", (String)((String)iterator.next()));
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"AddressResultSetMapping", (String)((String)iterator.next()));
    }

    public void testHints1() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueries();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)0, (int)namedQuery.getHintsSize());
    }

    public void testHints2() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQueryWithHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)2, (int)namedQuery.getHintsSize());
        ListIterator iterator = namedQuery.getHints().iterator();
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"BAR", (String)((QueryHintAnnotation)iterator.next()).getName());
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)((QueryHintAnnotation)iterator.next()).getName());
    }

    public void testAddNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedStoredProcedureQueries({";
        String expected2 = "@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedStoredProcedureQuery(name = \"BAR\") })";
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.addAnnotation(1, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.NamedStoredProcedureQuery"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertNotNull((Object)resourceType.getContainerAnnotation("javax.persistence.NamedStoredProcedureQueries"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)2, (int)resourceType.getAnnotationsSize("javax.persistence.NamedStoredProcedureQuery"));
    }

    public void testAddNamedQueryToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedStoredProcedureQueries({";
        String expected2 = "@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedStoredProcedureQuery(name = \"BAR\") })";
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.addAnnotation(1, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@NamedStoredProcedureQuery(name = \"BAZ\"),";
        expected3 = "@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")), @NamedStoredProcedureQuery(name = \"BAR\") })";
        namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.addAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator namedQueries = resourceType.getAnnotations("javax.persistence.NamedStoredProcedureQuery").iterator();
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"BAZ", (String)((NamedStoredProcedureQueryAnnotation2_1)namedQueries.next()).getName());
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"foo", (String)((NamedStoredProcedureQueryAnnotation2_1)namedQueries.next()).getName());
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((String)"BAR", (String)((NamedStoredProcedureQueryAnnotation2_1)namedQueries.next()).getName());
        NamedStoredProcedureQueries2_1AnnotationTests.assertNull((Object)resourceType.getAnnotation("javax.persistence.NamedStoredProcedureQuery"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertNotNull((Object)resourceType.getContainerAnnotation("javax.persistence.NamedStoredProcedureQueries"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertNotNull((Object)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery"));
        NamedStoredProcedureQueries2_1AnnotationTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("javax.persistence.NamedStoredProcedureQuery"));
    }

    public void testRemoveNamedQueryCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestNamedStoredProcedureQuery();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        String expected1 = "@NamedStoredProcedureQueries({";
        String expected2 = "@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\")),";
        String expected3 = "@NamedStoredProcedureQuery(name = \"BAR\") })";
        NamedStoredProcedureQueryAnnotation2_1 namedQuery = (NamedStoredProcedureQueryAnnotation2_1)resourceType.addAnnotation(1, "javax.persistence.NamedStoredProcedureQuery");
        namedQuery.setName("BAR");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@NamedStoredProcedureQuery(name = \"foo\", hints = @QueryHint(name = \"BAR\", value = \"FOO\"))";
        resourceType.removeAnnotation(1, "javax.persistence.NamedStoredProcedureQuery");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@NamedStoredProcedureQueries", cu);
    }
}

