/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class QueryHintTests
extends JpaJavaResourceModelTestCase {
    private static final String QUERY_HINT_NAME = "myHint";
    private static final String QUERY_HINT_VALUE = "myValue";

    public QueryHintTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestNamedQueryWithQueryHints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.NamedQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@NamedQuery(hints = {@QueryHint(name = \"myHint\", value = \"myValue\"), @QueryHint})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHint = namedQuery.hintAt(0);
        QueryHintTests.assertEquals((String)QUERY_HINT_NAME, (String)queryHint.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestNamedQueryWithQueryHints();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)resourceType.getAnnotation(0, "javax.persistence.NamedQuery");
        QueryHintAnnotation queryHint = namedQuery.hintAt(0);
        QueryHintTests.assertEquals((String)QUERY_HINT_NAME, (String)queryHint.getName());
        queryHint.setName("foo");
        QueryHintTests.assertEquals((String)"foo", (String)queryHint.getName());
        this.assertSourceContains("@QueryHint(name = \"foo\", value = \"myValue\")", cu);
    }
}

