/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0OrmManyToOneMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0OrmManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithManyToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("foo");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId("bar");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceMapping.setMapsId(null);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute contextAttribute = (OrmSpecifiedPersistentAttribute)contextType.getAttributeNamed("manyToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        resourceManyToOne.setId(Boolean.TRUE);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceOneToOne.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        resourceManyToOne.setId(Boolean.TRUE);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getMapsId());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ManyToOneMapping2_0 javaManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        SpecifiedJoinTable ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getName());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.getSpecifiedJoinColumnsSize());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.getSpecifiedInverseJoinColumnsSize());
        SpecifiedJoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTableName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        SpecifiedJoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTableName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaSpecifiedJoinTable javaJoinTable = ((JavaManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaSpecifiedJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaSpecifiedJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.getSpecifiedJoinColumnsSize());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.getSpecifiedInverseJoinColumnsSize());
        ormJoinColumn = (SpecifiedJoinColumn)ormJoinTable.getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (SpecifiedJoinColumn)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().next();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "manyToOne");
        ManyToOneMapping2_0 ormManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        OrmSpecifiedJoinTable ormJoinTable = ((OrmManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ManyToOneMapping2_0 javaManyToOneMapping = (ManyToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.removeFromXml();
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("address");
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute2.getMapping();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute2.isVirtual());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormJoinTable.getSpecifiedName());
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().removeStrategy();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable);
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        ManyToOneMapping2_0 contextMapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        EclipseLink2_0OrmManyToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)virtualPersistentAttribute.getMapping();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"address", (String)virtualManyToOneMapping.getName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualManyToOneMapping.getSpecifiedFetch());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualManyToOneMapping.getSpecifiedOptional());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"Address", (String)virtualManyToOneMapping.getSpecifiedTargetEntity());
        SpecifiedJoinColumn virtualJoinColumn = (SpecifiedJoinColumn)virtualManyToOneMapping.getRelationship().getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTableName());
        Cascade2_0 cascade = virtualManyToOneMapping.getCascade();
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isDetach());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualManyToOneMapping).getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"oneToOne", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLink2_0OrmManyToOneMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("manyToOne");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = (OrmSpecifiedPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        ManyToOneMapping2_0 ormManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        Cascade2_0 cascade = ormManyToOneMapping.getCascade();
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isDetach());
        EclipseLink2_0OrmManyToOneMappingTests.assertEquals(null, (Object)((EclipseLinkJoinFetchMapping)ormManyToOneMapping).getJoinFetch().getValue());
    }
}

