/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkConnection2_0;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLink2_0PersistenceUnitTestCase;

public class EclipseLink2_0ConnectionTests
extends EclipseLink2_0PersistenceUnitTestCase {
    private EclipseLinkConnection2_0 connection;
    public static final String NATIVE_SQL_KEY = "eclipselink.jdbc.native-sql";
    public static final Boolean NATIVE_SQL_TEST_VALUE = false;
    public static final Boolean NATIVE_SQL_TEST_VALUE_2 = NATIVE_SQL_TEST_VALUE == false;
    public static final String DRIVER_KEY = "javax.persistence.jdbc.driver";
    public static final String DRIVER_TEST_VALUE = "connection.driver";
    public static final String DRIVER_TEST_VALUE_2 = "connection.driver.2";
    public static final String LEGACY_DRIVER_KEY = "eclipselink.jdbc.driver";
    public static final String LEGACY_DRIVER_TEST_VALUE = "legacy.connection.driver";
    public static final String URL_KEY = "javax.persistence.jdbc.url";
    public static final String URL_TEST_VALUE = "test";
    public static final String URL_TEST_VALUE_2 = "test_2";
    public static final String LEGACY_URL_KEY = "eclipselink.jdbc.url";
    public static final String LEGACY_URL_TEST_VALUE = "legacy.connection.url";
    public static final String USER_KEY = "javax.persistence.jdbc.user";
    public static final String USER_TEST_VALUE = "test";
    public static final String USER_TEST_VALUE_2 = "test_2";
    public static final String LEGACY_USER_KEY = "eclipselink.jdbc.user";
    public static final String LEGACY_USER_TEST_VALUE = "legacy.connection.user";
    public static final String PASSWORD_KEY = "javax.persistence.jdbc.password";
    public static final String PASSWORD_TEST_VALUE = "test";
    public static final String PASSWORD_TEST_VALUE_2 = "test_2";
    public static final String LEGACY_PASSWORD_KEY = "eclipselink.jdbc.password";
    public static final String LEGACY_PASSWORD_TEST_VALUE = "legacy.connection.password";

    public EclipseLink2_0ConnectionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.subject.getConnection();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.connection.addPropertyChangeListener("driver", propertyChangeListener);
        this.connection.addPropertyChangeListener("url", propertyChangeListener);
        this.connection.addPropertyChangeListener("user", propertyChangeListener);
        this.connection.addPropertyChangeListener("password", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 8;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 1;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty("misc.property.1", "value.1");
        this.persistenceUnitSetProperty(LEGACY_DRIVER_KEY, LEGACY_DRIVER_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(DRIVER_KEY, DRIVER_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(LEGACY_URL_KEY, LEGACY_URL_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(URL_KEY, "test".toString());
        this.persistenceUnitSetProperty(LEGACY_USER_KEY, LEGACY_USER_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(USER_KEY, "test".toString());
        this.persistenceUnitSetProperty(LEGACY_PASSWORD_KEY, LEGACY_PASSWORD_TEST_VALUE.toString());
        this.persistenceUnitSetProperty(PASSWORD_KEY, "test".toString());
    }

    protected PersistenceUnitProperties getModel() {
        return this.connection;
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        String modelValue = null;
        if (propertyName.equals("driver")) {
            modelValue = this.connection.getDriver();
        } else if (propertyName.equals("url")) {
            modelValue = this.connection.getUrl();
        } else if (propertyName.equals("user")) {
            modelValue = this.connection.getUser();
        } else if (propertyName.equals("password")) {
            modelValue = this.connection.getPassword();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("driver")) {
            this.connection.setDriver((String)newValue);
        } else if (propertyName.equals("url")) {
            this.connection.setUrl((String)newValue);
        } else if (propertyName.equals("user")) {
            this.connection.setUser((String)newValue);
        } else if (propertyName.equals("password")) {
            this.connection.setPassword((String)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    public void testDriverPropertyNameMigration() throws Exception {
        EclipseLink2_0ConnectionTests.assertTrue((String)"Legacy driver not exists", (boolean)this.propertyValueEquals(LEGACY_DRIVER_KEY, LEGACY_DRIVER_TEST_VALUE));
        EclipseLink2_0ConnectionTests.assertEquals((String)"Incorrect driver read", (String)this.connection.getDriver(), (String)DRIVER_TEST_VALUE);
        this.connection.setDriver(DRIVER_TEST_VALUE_2);
        EclipseLink2_0ConnectionTests.assertEquals((String)"Driver not set", (String)this.connection.getDriver(), (String)DRIVER_TEST_VALUE_2);
        EclipseLink2_0ConnectionTests.assertTrue((String)"PersistenceUnit property not set", (boolean)this.propertyValueEquals(DRIVER_KEY, DRIVER_TEST_VALUE_2));
        this.verifyPuHasNotProperty(LEGACY_DRIVER_KEY, "Legacy property has not been deleted");
    }

    public void testPropertiesNamesMigration() throws Exception {
        this.verifyPuHasProperty(USER_KEY, "Property not exists");
        this.verifyPuHasProperty(PASSWORD_KEY, "Property not exists");
        this.verifyPuHasProperty(LEGACY_USER_KEY, "Legacy property not exists");
        this.verifyPuHasProperty(LEGACY_PASSWORD_KEY, "Legacy property not exists");
        this.connection.setNativeSql(NATIVE_SQL_TEST_VALUE);
        this.verifyPuHasNotProperty(LEGACY_DRIVER_KEY, "Legacy property has not been deleted");
        this.verifyPuHasNotProperty(LEGACY_URL_KEY, "Legacy property has not been deleted");
        this.verifyPuHasNotProperty(LEGACY_USER_KEY, "Legacy property has not been deleted");
        this.verifyPuHasNotProperty(LEGACY_PASSWORD_KEY, "Legacy property has not been deleted");
    }
}

