/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkDdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class SchemaGenerationAdapterTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkSchemaGeneration schemaGeneration;
    public static final String DDL_GENERATION_TYPE_KEY = "eclipselink.ddl-generation";
    public static final EclipseLinkDdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = EclipseLinkDdlGenerationType.drop_and_create_tables;
    public static final EclipseLinkDdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE_2 = EclipseLinkDdlGenerationType.none;
    public static final String OUTPUT_MODE_KEY = "eclipselink.ddl-generation.output-mode";
    public static final EclipseLinkOutputMode OUTPUT_MODE_TEST_VALUE = EclipseLinkOutputMode.sql_script;
    public static final EclipseLinkOutputMode OUTPUT_MODE_TEST_VALUE_2 = EclipseLinkOutputMode.database;
    private static final String CREATE_FILE_NAME_KEY = "eclipselink.create-ddl-jdbc-file-name";
    private static final String CREATE_FILE_NAME_TEST_VALUE = "create-file-name.test";
    private static final String CREATE_FILE_NAME_TEST_VALUE_2 = "create-file-name-2.test";
    private static final String DROP_FILE_NAME_KEY = "eclipselink.drop-ddl-jdbc-file-name";
    private static final String DROP_FILE_NAME_TEST_VALUE = "drop-file-name.test";
    private static final String DROP_FILE_NAME_TEST_VALUE_2 = "drop-file-name-2.test";
    private static final String APPLICATION_LOCATION_KEY = "eclipselink.application-location";
    private static final String APPLICATION_LOCATION_TEST_VALUE = "C:/temp";
    private static final String APPLICATION_LOCATION_TEST_VALUE_2 = "C:/tmp";

    public SchemaGenerationAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGeneration = this.subject.getEclipseLinkSchemaGeneration();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.schemaGeneration.addPropertyChangeListener("outputMode", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("ddlGenerationType", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("createFileName", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("dropFileName", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("applicationLocation", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.propertiesTotal = 9;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal = 5;
        this.persistenceUnitSetProperty("property.0", "value.0");
        this.persistenceUnitSetProperty(OUTPUT_MODE_KEY, this.getPropertyStringValueOf(OUTPUT_MODE_TEST_VALUE));
        this.persistenceUnitSetProperty("property.2", "value.2");
        this.persistenceUnitSetProperty("property.3", "value.3");
        this.persistenceUnitSetProperty("property.4", "value.4");
        this.persistenceUnitSetProperty(DDL_GENERATION_TYPE_KEY, this.getPropertyStringValueOf(DDL_GENERATION_TYPE_TEST_VALUE));
        this.persistenceUnitSetProperty(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE);
        this.persistenceUnitSetProperty(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE);
        this.persistenceUnitSetProperty(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE);
    }

    public void testSetCreateFileName() throws Exception {
        this.verifyModelInitialized(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE);
        this.verifySetProperty(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE, CREATE_FILE_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveCreateFileName() throws Exception {
        this.verifyAddRemoveProperty(CREATE_FILE_NAME_KEY, CREATE_FILE_NAME_TEST_VALUE, CREATE_FILE_NAME_TEST_VALUE_2);
    }

    public void testSetDropFileName() throws Exception {
        this.verifyModelInitialized(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE);
        this.verifySetProperty(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE, DROP_FILE_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveDropFileName() throws Exception {
        this.verifyAddRemoveProperty(DROP_FILE_NAME_KEY, DROP_FILE_NAME_TEST_VALUE, DROP_FILE_NAME_TEST_VALUE_2);
    }

    public void testSetApplicationLocation() throws Exception {
        this.verifyModelInitialized(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE);
        this.verifySetProperty(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE, APPLICATION_LOCATION_TEST_VALUE_2);
    }

    public void testAddRemoveApplicationLocation() throws Exception {
        this.verifyAddRemoveProperty(APPLICATION_LOCATION_KEY, APPLICATION_LOCATION_TEST_VALUE, APPLICATION_LOCATION_TEST_VALUE_2);
    }

    public void testSetEmptyApplicationLocation() throws Exception {
        String puKey = APPLICATION_LOCATION_KEY;
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.verifyPuHasProperty(puKey, "persistenceUnit.properties doesn't contains: ");
        this.setProperty(propertyName, "");
        this.verifyPuHasNotProperty(puKey, "Property was not deleted");
        this.verifyPutProperty(propertyName, null);
        SchemaGenerationAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(puKey));
    }

    public void testSetOutputMode() throws Exception {
        this.verifyModelInitialized(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE);
        this.verifySetProperty(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE, OUTPUT_MODE_TEST_VALUE_2);
    }

    public void testAddRemoveOutputMode() throws Exception {
        this.verifyAddRemoveProperty(OUTPUT_MODE_KEY, OUTPUT_MODE_TEST_VALUE, OUTPUT_MODE_TEST_VALUE_2);
    }

    public void testSetDdlGenerationType() throws Exception {
        this.verifyModelInitialized(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE);
        this.verifySetProperty(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE, DDL_GENERATION_TYPE_TEST_VALUE_2);
    }

    public void testAddRemoveDdlGenerationType() throws Exception {
        this.verifyAddRemoveProperty(DDL_GENERATION_TYPE_KEY, DDL_GENERATION_TYPE_TEST_VALUE, DDL_GENERATION_TYPE_TEST_VALUE_2);
    }

    protected void setProperty(String propertyName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("outputMode")) {
            this.schemaGeneration.setOutputMode((EclipseLinkOutputMode)newValue);
        } else if (propertyName.equals("ddlGenerationType")) {
            this.schemaGeneration.setDdlGenerationType((EclipseLinkDdlGenerationType)newValue);
        } else if (propertyName.equals("applicationLocation")) {
            this.schemaGeneration.setApplicationLocation((String)newValue);
        } else if (propertyName.equals("createFileName")) {
            this.schemaGeneration.setCreateFileName((String)newValue);
        } else if (propertyName.equals("dropFileName")) {
            this.schemaGeneration.setDropFileName((String)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("outputMode")) {
            modelValue = this.schemaGeneration.getOutputMode();
        } else if (propertyName.equals("ddlGenerationType")) {
            modelValue = this.schemaGeneration.getDdlGenerationType();
        } else if (propertyName.equals("applicationLocation")) {
            modelValue = this.schemaGeneration.getApplicationLocation();
        } else if (propertyName.equals("createFileName")) {
            modelValue = this.schemaGeneration.getCreateFileName();
        } else if (propertyName.equals("dropFileName")) {
            modelValue = this.schemaGeneration.getDropFileName();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected PersistenceUnitProperties getModel() {
        return this.schemaGeneration;
    }
}

