/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.StructConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class StructConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public StructConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestStructConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter");
            }
        });
    }

    private ICompilationUnit createTestStructConverterWithConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter(converter=\"Foo\")");
            }
        });
    }

    private ICompilationUnit createTestStructConverterWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@StructConverter(name=\"bar\")");
            }
        });
    }

    public void testStructConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestStructConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("org.eclipse.persistence.annotations.StructConverter"));
        resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter"));
    }

    public void testGetConverter() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
    }

    public void testSetConverter() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
        converter.setConverter("Bar");
        StructConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getConverter());
        this.assertSourceContains("@StructConverter(converter=\"Bar\")", cu);
    }

    public void testSetConverterNull() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getConverter());
        converter.setConverter(null);
        StructConverterAnnotationTests.assertNull((Object)converter.getConverter());
        this.assertSourceContains("@StructConverter", cu);
        this.assertSourceDoesNotContain("converter", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        StructConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@StructConverter(name=\"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestStructConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        StructConverterAnnotation converter = (StructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        StructConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        StructConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@StructConverter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }
}

