/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.project.facet.ProductManager;

public class WebFacetInstallDataModelProvider
extends J2EEModuleFacetInstallDataModelProvider
implements IWebFacetInstallDataModelProperties {
    protected void handleJavaFacetSourceFoldersChanged(JavaFacetInstallConfig.ChangeEvent event) {
        List sourceFolders = event.getJavaFacetInstallConfig().getSourceFolders();
        String sourceFolder = sourceFolders.isEmpty() ? null : ((IPath)sourceFolders.get(0)).toPortableString();
        this.getDataModel().setProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", (Object)sourceFolder);
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
        names.add("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        names.add("IWebFacetInstallDataModelProperties.INSTALL_WEB_LIBRARY");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            if (this.model.isPropertySet("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
                IVirtualComponent c;
                IVirtualFolder ejbroot;
                IPath configFolderPath;
                IProject project;
                String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                Path path = new Path(projectName);
                IProject iProject = project = projectName.length() > 0 && path.isValidSegment(projectName) ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName) : null;
                if (project != null && project.exists() && ModuleCoreNature.isFlexibleProject((IProject)project) && (configFolderPath = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)(ejbroot = (c = ComponentCore.createComponent((IProject)project, (boolean)true)).getRootFolder()))) != null && project.getFolder(configFolderPath).exists()) {
                    return configFolderPath.toString();
                }
            }
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("dynWebSource");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.web";
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI")) {
            String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
            return String.valueOf(projectName) + ".war";
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            String facetVersion = this.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
            if ("2.5".equals(facetVersion)) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("dynamic_web_generate_dd");
            }
            if ("3.0".equals(facetVersion)) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("ee6_dynamic_web_generate_dd");
            }
            if ("3.1".equals(facetVersion)) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("ee7_dynamic_web_generate_dd");
            }
            return Boolean.TRUE;
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.INSTALL_WEB_LIBRARY")) {
            return J2EEComponentClasspathContainerUtils.getDefaultUseWebAppLibraries();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 3);
        } else if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 4);
            if (!this.model.isPropertySet("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                this.model.notifyPropertyChange("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", 2);
            }
        } else {
            if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                return true;
            }
            if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER") && this.javaFacetInstallConfig != null) {
                if (propertyValue == null) {
                    this.javaFacetInstallConfig.setSourceFolder(null);
                } else {
                    Path sourceFolder = new Path((String)propertyValue);
                    if (!this.javaFacetInstallConfig.getSourceFolders().contains(sourceFolder)) {
                        this.javaFacetInstallConfig.setSourceFolder((IPath)sourceFolder);
                    }
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public boolean isPropertyEnabled(String propertyName) {
        return super.isPropertyEnabled(propertyName);
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version.getVersionString());
    }

    public IStatus validate(String name) {
        if (name.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.validateContextRoot(this.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
        }
        if (name.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            IStatus status = this.validateFolderName(this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER"));
            if (status.isOK()) {
                return this.validateSourceAndContentFolderUniqueness();
            }
            return status;
        }
        if (name.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            IStatus status = super.validate("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            if (status.isOK()) {
                status = this.validateSourceAndContentFolderUniqueness();
            }
            if (status.isOK()) {
                String configFolder = this.model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                String outFolder = null;
                if (this.javaFacetInstallConfig != null) {
                    outFolder = this.javaFacetInstallConfig.getDefaultOutputFolder().toString();
                }
                if (outFolder != null) {
                    status = WebFacetInstallDataModelProvider.validateWebConfigAndOutputFolder(configFolder, outFolder);
                }
            }
            return status;
        }
        return super.validate(name);
    }

    protected IStatus validateContextRoot(String contextRoot) {
        if (contextRoot == null || contextRoot.length() == 0) {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[]{contextRoot}), null);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    int cp = UTF16.charAt((String)token, (int)i);
                    if (token.charAt(i) == ' ') {
                        return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_contain_whitespace_, (Object[])new Object[]{contextRoot}), null);
                    }
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        String invalidCharString = null;
                        invalidCharString = UTF16.getCharCount((int)cp) > 1 ? UTF16.valueOf((int)cp) : new Character(token.charAt(i)).toString();
                        Object[] invalidChar = new Object[]{invalidCharString};
                        String errorStatus = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])invalidChar);
                        return J2EEPlugin.newErrorStatus((String)errorStatus, null);
                    }
                    i += UTF16.getCharCount((int)cp);
                }
            }
        } else {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_contain_whitespace_, (Object[])new Object[]{contextRoot}), null);
        }
        return OK_STATUS;
    }

    protected IStatus validateSourceAndContentFolderUniqueness() {
        String srcFolder = this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        String contentFolder = this.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        if (srcFolder != null && contentFolder != null && srcFolder.equals(contentFolder)) {
            String errorMessage = ProjectSupportResourceHandler.DYNAMIC_WEB_DISTINCT_SRC_WEBCONTENT_ERROR;
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        return OK_STATUS;
    }

    public static IStatus validateWebConfigAndOutputFolder(String rawConfigFolder, String outFolder) {
        String expectedOutFolder;
        if (ProductManager.shouldUseSingleRootStructure() && !outFolder.equals(expectedOutFolder = String.valueOf(rawConfigFolder) + "/" + "WEB-INF/classes")) {
            String message = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.DYNAMIC_WEB_PERFORMANCE_VALIDATION, (Object[])new Object[]{expectedOutFolder});
            return WTPCommonPlugin.createWarningStatus((String)message);
        }
        return OK_STATUS;
    }
}

