/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.eclipselink.ui;

import org.eclipse.osgi.util.NLS;

/**
 * Localized messages used by Dali JPA ElipseLink UI.
 */
public class JptJpaEclipseLinkUiMessages {

	private static final String BUNDLE_NAME = "jpt_jpa_eclipselink_ui"; //$NON-NLS-1$
	private static final Class<?> BUNDLE_CLASS = JptJpaEclipseLinkUiMessages.class;
	static {
		NLS.initializeMessages(BUNDLE_NAME, BUNDLE_CLASS);
	}
	
	public static String MAPPING_FILE_WIZARD_TITLE;
	public static String MAPPING_FILE_WIZARD_PAGE_NEW_FILE_TITLE;
	public static String MAPPING_FILE_WIZARD_PAGE_NEW_FILE_DESC;
	public static String MAPPING_FILE_WIZARD_PAGE_OPTIONS_TITLE;
	public static String MAPPING_FILE_WIZARD_PAGE_OPTIONS_DESC;

	public static String PERSISTENCE_XML_GENERAL_TAB_NAME;
	public static String PERSISTENCE_XML_GENERAL_TAB_PROVIDER;
	public static String PERSISTENCE_XML_GENERAL_TAB_BROWSE;
	public static String PERSISTENCE_XML_GENERAL_TAB_DESCRIPTION;

	// General
	public static String PERSISTENCE_XML_GENERAL_TAB_TITLE;
	public static String PERSISTENCE_XML_GENERAL_TAB_GENERAL_SECTION_TITLE;
	public static String PERSISTENCE_XML_GENERAL_TAB_MAPPED_CLASSES_SECTION_TITLE;
	public static String PERSISTENCE_XML_GENERAL_TAB_MAPPED_CLASSES_SECTION_DESCRIPTION;
	public static String PERSISTENCE_XML_GENERAL_TAB_XML_MAPPING_FILES_SECTION_TITLE;
	public static String PERSISTENCE_XML_GENERAL_TAB_XML_MAPPING_FILES_SECTION_DESCRIPTION;
	
	public static String PERSISTENCE_XML_GENERAL_TAB_NAME_LABEL;
	public static String PERSISTENCE_XML_GENERAL_TAB_PERSISTENCE_PROVIDER_LABEL;
	public static String PERSISTENCE_XML_GENERAL_TAB_DESCRIPTION_LABEL;
	
	public static String PERSISTENCE_XML_GENERAL_TAB_EXCLUDE_UNLISTED_MAPPED_CLASSES;
	public static String PERSISTENCE_XML_GENERAL_TAB_EXCLUDE_UNLISTED_MAPPED_CLASSES_WITH_DEFAULT;
	public static String PERSISTENCE_XML_GENERAL_TAB_MAPPED_CLASSES_NO_NAME;
	public static String PERSISTENCE_XML_GENERAL_TAB_OPEN;
	
	public static String PERSISTENCE_XML_GENERAL_TAB_XML_MAPPING_FILES_DIALOG_TITLE;
	public static String PERSISTENCE_XML_GENERAL_TAB_XML_MAPPING_FILES_DIALOG_MESSAGE;
	public static String PERSISTENCE_XML_GENERAL_TAB_ORM_NO_NAME;
	public static String PERSISTENCE_XML_GENERAL_TAB_EXCLUDE_ECLIPSELINK_ORM;
	public static String PERSISTENCE_XML_GENERAL_TAB_EXCLUDE_ECLIPSELINK_ORM_WITH_DEFAULT;

	// Connection
	public static String PERSISTENCE_XML_CONNECTION_TAB_TITLE;
	public static String PERSISTENCE_XML_CONNECTION_TAB_SECTION_TITLE;
	public static String PERSISTENCE_XML_CONNECTION_TAB_SECTION_DESCRIPTION;

	public static String PERSISTENCE_XML_CONNECTION_TAB_TRANSACTION_TYPE_LABEL;

	public static String CONNECTION_PROPERTIES_COMPOSITE_DATABASE_GROUP_BOX;

	public static String JDBC_PROPERTIES_COMPOSITE_ECLIPSELINK_CONNECTION_POOL_GROUP_BOX;

	public static String JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_MESSAGE;
	public static String JDBC_CONNECTION_PROPERTIES_COMPOSITE_CONNECTION_DIALOG_TITLE;

	public static String TRANSACTION_TYPE_COMPOSITE_JTA;
	public static String TRANSACTION_TYPE_COMPOSITE_RESOURCE_LOCAL;

	public static String PERSISTENCE_XML_CONNECTION_TAB_NATIVE_SQL_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_NATIVE_SQL_LABEL_DEFAULT;

	public static String PERSISTENCE_XML_CONNECTION_TAB_BATCH_WRITING_LABEL;

	public static String BATCH_WRITING_COMPOSITE_NONE;
	public static String BATCH_WRITING_COMPOSITE_JDBC;
	public static String BATCH_WRITING_COMPOSITE_BUFFERED;
	public static String BATCH_WRITING_COMPOSITE_ORACLE_JDBC;

	public static String PERSISTENCE_XML_CONNECTION_TAB_CACHE_STATEMENTS_LABEL;

	public static String PERSISTENCE_XML_CONNECTION_TAB_JTA_DATA_SOURCE_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_NON_JTA_DATA_SOURCE_LABEL;

	public static String PERSISTENCE_XML_CONNECTION_TAB_DRIVER_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_URL_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_USER_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_PASSWORD_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_BIND_PARAMETERS_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_BIND_PARAMETERS_LABEL_DEFAULT;

	public static String PERSISTENCE_XML_CONNECTION_TAB_read_Connections_Shared_Label;
	public static String PERSISTENCE_XML_CONNECTION_TAB_READ_CONNECTIONS_SHARED_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CONNECTION_TAB_READ_CONNECTIONS_SECTION_TITLE;
	public static String PERSISTENCE_XML_CONNECTION_TAB_READ_CONNECTIONS_MIN_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_READ_CONNECTIONS_MAX_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_WRITE_CONNECTIONS_SECTION_TITLE;
	public static String PERSISTENCE_XML_CONNECTION_TAB_WRITE_CONNECTIONS_MIN_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_WRITE_CONNECTIONS_MAX_LABEL;

	public static String JDBC_EXCLUSIVE_CONNECTIONS_PROPERTIES_COMPOSITE_GROUP_BOX;
	
	public static String PERSISTENCE_XML_CONNECTION_TAB_EXCLUSIVE_CONNECTION_MODE_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_LAZY_CONNECTION_LABEL;
	public static String PERSISTENCE_XML_CONNECTION_TAB_LAZY_CONNECTION_LABEL_DEFAULT;

	public static String JDBC_EXCLUSIVE_CONNECTION_MODE_COMPOSITE_ALWAYS;
	public static String JDBC_EXCLUSIVE_CONNECTION_MODE_COMPOSITE_ISOLATED;
	public static String JDBC_EXCLUSIVE_CONNECTION_MODE_COMPOSITE_TRANSACTIONAL;
	
	// EclipseLink SchemaGeneration
	public static String PERSISTENCE_XML_ECLIPSELINK_SCHEMA_GENERATION_PAGE_TITLE;
	public static String PERSISTENCE_XML_ECLIPSELINK_SCHEMA_GENERATION_TAB_SECTION_TITLE;
	
	// SchemaGeneration
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_TITLE;
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_SECTION_TITLE;
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_SECTION_DESCRIPTION;
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_DEFAULT_DOT;

	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_DDL_GENERATION_TYPE_LABEL;
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_OUTPUT_MODE_LABEL;

	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_CREATE_DDL_FILE_NAME_LABEL;
	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_DROP_DDL_FILE_NAME_LABEL;

	public static String OUTPUT_MODE_COMPOSITE_BOTH;
	public static String OUTPUT_MODE_COMPOSITE_SQL_SCRIPT;
	public static String OUTPUT_MODE_COMPOSITE_DATABASE;

	public static String DDL_GENERATION_TYPE_COMPOSITE_NONE;
	public static String DDL_GENERATION_TYPE_COMPOSITE_CREATE_TABLES;
	public static String DDL_GENERATION_TYPE_COMPOSITE_DROP_AND_CREATE_TABLES;

	public static String PERSISTENCE_XML_SCHEMA_GENERATION_TAB_DDL_GENERATION_LOCATION_LABEL;

	public static String DDL_GENERATION_LOCATION_COMPOSITE_DIALOG_TITLE;
	public static String DDL_GENERATION_LOCATION_COMPOSITE_DIALOG_MESSAGE;

	// Caching
	public static String PERSISTENCE_XML_CACHING_TAB_TITLE;
	public static String PERSISTENCE_XML_CACHING_TAB_SECTION_TITLE;
	public static String PERSISTENCE_XML_CACHING_TAB_SECTION_DESCRIPTION;
	
	public static String CACHE_DEFAULTS_COMPOSITE_GROUP_TITLE;

	public static String PERSISTENCE_XML_CACHING_TAB_DEFAULT_CACHE_TYPE_LABEL;
	public static String PERSISTENCE_XML_CACHING_TAB_CACHE_TYPE_LABEL;

	public static String PERSISTENCE_XML_CACHING_TAB_DEFAULT_SHARED_CACHE_LABEL;
	public static String PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_LABEL;

	public static String PERSISTENCE_XML_CACHING_TAB_DEFAULT_SHARED_CACHE_DEFAULT_LABEL;
	public static String PERSISTENCE_XML_CACHING_TAB_SHARED_CACHE_DEFAULT_LABEL;

	public static String CACHE_SIZE_COMPOSITE_CACHE_SIZE;

	public static String CACHE_TYPE_COMPOSITE_FULL;
	public static String CACHE_TYPE_COMPOSITE_HARD_WEAK;
	public static String CACHE_TYPE_COMPOSITE_NONE;
	public static String CACHE_TYPE_COMPOSITE_SOFT;
	public static String CACHE_TYPE_COMPOSITE_SOFT_WEAK;
	public static String CACHE_TYPE_COMPOSITE_WEAK;

	public static String DEFAULT_CACHE_SIZE_COMPOSITE_DEFAULT_CACHE_SIZE;

	public static String DEFAULT_CACHE_TYPE_COMPOSITE_FULL;
	public static String DEFAULT_CACHE_TYPE_COMPOSITE_HARD_WEAK;
	public static String DEFAULT_CACHE_TYPE_COMPOSITE_NONE;
	public static String DEFAULT_CACHE_TYPE_COMPOSITE_SOFT;
	public static String DEFAULT_CACHE_TYPE_COMPOSITE_SOFT_WEAK;
	public static String DEFAULT_CACHE_TYPE_COMPOSITE_WEAK;

	public static String ENTITY_DIALOG_SELECT_ENTITY;
	public static String ENTITY_DIALOG_NAME;

	public static String CACHING_ENTITY_LIST_COMPOSITE_GROUP_TITLE;
	public static String CACHING_ENTITY_LIST_COMPOSITE_EDIT_BUTTON;

	public static String CACHING_ENTITY_LIST_COMPOSITE_DIALOG_MESSAGE;
	public static String CACHING_ENTITY_LIST_COMPOSITE_DIALOG_TITLE;

	public static String PERSISTENCE_XML_CACHING_TAB_FLUSH_CLEAR_CACHE_LABEL;
	
	public static String FLUSH_CLEAR_CACHE_COMPOSITE_DROP;
	public static String FLUSH_CLEAR_CACHE_COMPOSITE_DROP_INVALIDATE;
	public static String FLUSH_CLEAR_CACHE_COMPOSITE_MERGE;
	
	// Customization
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_TITLE;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_SECTION_TITLE;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_SECTION_DESCRIPTION;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_OTHER_SECTION;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_CUSTOMIZERS_SECTION;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_PROPERTIES_GROUP_BOX;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_LABEL;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_LAZY_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_LAZY_LABEL;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_CHANGE_TRACKING_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_CHANGE_TRACKING_LABEL;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_FETCH_GROUPS_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_FETCH_GROUPS_LABEL;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_INTERNAL_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_INTERNAL_LABEL;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_EAGER_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_WEAVING_EAGER_LABEL;
	
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_THROW_EXCEPTIONS_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_THROW_EXCEPTIONS_LABEL;
	
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_EXCEPTION_HANDLER_LABEL;

	public static String WEAVING_COMPOSITE_TRUE_;
	public static String WEAVING_COMPOSITE_FALSE_;
	public static String WEAVING_COMPOSITE_STATIC_;

	public static String CUSTOMIZATION_ENTITY_LIST_COMPOSITE_GROUP_TITLE;
	public static String CUSTOMIZATION_ENTITY_LIST_COMPOSITE_EDIT_BUTTON;

	public static String CUSTOMIZATION_ENTITY_LIST_COMPOSITE_DIALOG_MESSAGE;
	public static String CUSTOMIZATION_ENTITY_LIST_COMPOSITE_DIALOG_TITLE;
	
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_CUSTOMIZER_LABEL;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_SESSION_CUSTOMIZER_LABEL;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_NO_NAME;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_VALIDATION_ONLY_LABEL;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_VALIDATION_ONLY_LABEL_DEFAULT;

	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_VALIDATE_SCHEMA_LABEL;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_VALIDATE_SCHEMA_LABEL_DEFAULT;
	
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_PROFILER_LABEL;
	public static String PERSISTENCE_XML_CUSTOMIZATION_TAB_BROWSE;
	
	public static String PROFILER_COMPOSITE_PERFORMANCE_PROFILER;
	public static String PROFILER_COMPOSITE_QUERY_MONITOR;
	public static String PROFILER_COMPOSITE_NO_PROFILER;

	// Logging
	public static String PERSISTENCE_XML_LOGGING_TAB_TITLE;
	public static String PERSISTENCE_XML_LOGGING_TAB_SECTION_TITLE;
	public static String PERSISTENCE_XML_LOGGING_TAB_SECTION_DESCRIPTION;
	public static String PERSISTENCE_XML_LOGGING_TAB_DEFAULT_STDOUT;

	public static String PERSISTENCE_XML_LOGGING_TAB_CATEGORY_LOGGING_LEVEL_SECTION_TITLE;
	public static String PERSISTENCE_XML_LOGGING_TAB_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_SQL_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_TRANSACTION_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_EVENT_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_QUERY_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_CACHE_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_PROPAGATION_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_SEQUENCING_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_EJB_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_DMS_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_EJB_OR_METADATA_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_JPA_METAMODEL_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_WEAVER_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_PROPERTIES_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_SERVER_LOGGING_LEVEL_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_METADATA_LOGGING_LEVEL_LABEL; // EclipseLink 2.4
	public static String PERSISTENCE_XML_LOGGING_TAB_METAMODEL_LOGGING_LEVEL_LABEL; // EclipseLink 2.4
	public static String PERSISTENCE_XML_LOGGING_TAB_JPA_LOGGING_LEVEL_LABEL; // EclipseLink 2.4
	public static String PERSISTENCE_XML_LOGGING_TAB_DDL_LOGGING_LEVEL_LABEL; // EclipseLink 2.4
		
	public static String LOGGING_LEVEL_COMPOSITE_OFF;
	public static String LOGGING_LEVEL_COMPOSITE_SEVERE;
	public static String LOGGING_LEVEL_COMPOSITE_WARNING;
	public static String LOGGING_LEVEL_COMPOSITE_INFO;
	public static String LOGGING_LEVEL_COMPOSITE_CONFIG;
	public static String LOGGING_LEVEL_COMPOSITE_FINE;
	public static String LOGGING_LEVEL_COMPOSITE_FINER;
	public static String LOGGING_LEVEL_COMPOSITE_FINEST;
	public static String LOGGING_LEVEL_COMPOSITE_ALL;

	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_OFF;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_SEVERE;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_WARNING;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_INFO;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_CONFIG;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINE;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINER;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_FINEST;
	public static String ECLIPSELINK_CATEGORY_LOGGING_LEVEL_COMPOSITE_ALL;

	public static String PERSISTENCE_XML_LOGGING_TAB_LOGGER_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_BROWSE;

	public static String LOGGER_COMPOSITE_DEFAULT_LOGGER;
	public static String LOGGER_COMPOSITE_JAVA_LOGGER;
	public static String LOGGER_COMPOSITE_SERVER_LOGGER;

	public static String PERSISTENCE_XML_LOGGING_TAB_TIMESTAMP_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_TIMESTAMP_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_LOGGING_TAB_THREAD_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_THREAD_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_LOGGING_TAB_SESSION_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_SESSION_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_LOGGING_TAB_EXCEPTIONS_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_EXCEPTIONS_LABEL_DEFAULT;
	public static String PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_CONNECTION_LABEL_DEFAULT;
	
	public static String PERSISTENCE_XML_LOGGING_TAB_LOGGERS_LABEL;
	public static String PERSISTENCE_XML_LOGGING_TAB_LOGGING_FILE_LABEL;

	public static String LOGGING_FILE_LOCATION_COMPOSITE_DIALOG_TITLE;

	// Session Options
	public static String PERSISTENCE_XML_OPTIONS_TAB_TITLE;
	public static String PERSISTENCE_XML_OPTIONS_TAB_SESSION_SECTION_TITLE;
	public static String PERSISTENCE_XML_OPTIONS_TAB_SESSION_SECTION_DESCRIPTION;

	public static String PERSISTENCE_XML_OPTIONS_TAB_SESSION_NAME;
	public static String PERSISTENCE_XML_OPTIONS_TAB_SESSIONS_XML;

	public static String PERSISTENCE_XML_OPTIONS_TAB_INCLUDE_DESCRIPTOR_QUERIES_LABEL;
	public static String PERSISTENCE_XML_OPTIONS_TAB_INCLUDE_DESCRIPTOR_QUERIES_LABEL_DEFAULT;

	public static String PERSISTENCE_XML_OPTIONS_TAB_EVENT_LISTENER_LABEL;
	public static String PERSISTENCE_XML_OPTIONS_TAB_TARGET_DATABASE_LABEL;
	
	public static String PERSISTENCE_XML_OPTIONS_TAB_MISCELLANEOUS_SECTION_TITLE;
	public static String PERSISTENCE_XML_OPTIONS_TAB_MISCELLANEOUS_SECTION_DESCRIPTION;
	
	public static String PERSISTENCE_XML_OPTIONS_TAB_TEMPORAL_MUTABLE_LABEL;
	public static String PERSISTENCE_XML_OPTIONS_TAB_TEMPORAL_MUTABLE_LABEL_DEFAULT;

	public static String TARGET_DATABASE_COMPOSITE_ATTUNITY;
	public static String TARGET_DATABASE_COMPOSITE_AUTO;
	public static String TARGET_DATABASE_COMPOSITE_CLOUDSCAPE;
	public static String TARGET_DATABASE_COMPOSITE_DATABASE;
	public static String TARGET_DATABASE_COMPOSITE_DB2;
	public static String TARGET_DATABASE_COMPOSITE_DB2_MAINFRAME;
	public static String TARGET_DATABASE_COMPOSITE_DBASE;
	public static String TARGET_DATABASE_COMPOSITE_DERBY;
	public static String TARGET_DATABASE_COMPOSITE_HSQL;
	public static String TARGET_DATABASE_COMPOSITE_INFORMIX;
	public static String TARGET_DATABASE_COMPOSITE_JAVADB;
	public static String TARGET_DATABASE_COMPOSITE_MAXDB;
	public static String TARGET_DATABASE_COMPOSITE_MYSQL;
	public static String TARGET_DATABASE_COMPOSITE_ORACLE;
	public static String TARGET_DATABASE_COMPOSITE_ORACLE11;
	public static String TARGET_DATABASE_COMPOSITE_ORACLE10;
	public static String TARGET_DATABASE_COMPOSITE_ORACLE9;
	public static String TARGET_DATABASE_COMPOSITE_ORACLE8;
	public static String TARGET_DATABASE_COMPOSITE_POINTBASE;
	public static String TARGET_DATABASE_COMPOSITE_POSTGRESQL;
	public static String TARGET_DATABASE_COMPOSITE_SQLANYWHERE;
	public static String TARGET_DATABASE_COMPOSITE_SQLSERVER;
	public static String TARGET_DATABASE_COMPOSITE_SYBASE;
	public static String TARGET_DATABASE_COMPOSITE_SYMFOWARE;
	public static String TARGET_DATABASE_COMPOSITE_TIMESTEN;

	public static String PERSISTENCE_XML_OPTIONS_TAB_TARGET_SERVER_LABEL;
	public static String PERSISTENCE_XML_OPTIONS_TAB_NO_NAME;
	
	public static String TARGET_SERVER_COMPOSITE_NONE;
	public static String TARGET_SERVER_COMPOSITE_OC4J;
	public static String TARGET_SERVER_COMPOSITE_SUNAS9;
	public static String TARGET_SERVER_COMPOSITE_WEBSPHERE;
	public static String TARGET_SERVER_COMPOSITE_WEBSPHERE_6_1;
	public static String TARGET_SERVER_COMPOSITE_WEBSPHERE_7;
	public static String TARGET_SERVER_COMPOSITE_WEBLOGIC;
	public static String TARGET_SERVER_COMPOSITE_WEBLOGIC_9;
	public static String TARGET_SERVER_COMPOSITE_WEBLOGIC_10;
	public static String TARGET_SERVER_COMPOSITE_JBOSS;
	public static String TARGET_SERVER_COMPOSITE_NETWEAVER_7_1;

	// DDL Generation
	public static String ECLIPSELINK_DDL_GENERATOR_UI_GENERATING_DDL_WARNING_TITLE;
	public static String ECLIPSELINK_DDL_GENERATOR_UI_GENERATING_DDL_WARNING_MESSAGE;
	public static String ECLIPSELINK_DDL_GENERATOR_UI_ERROR;
	public static String ECLIPSELINK_GENERATE_TABLES_JOB;
	public static String ECLIPSELINK_GENERATE_TABLES_TASK;
	
	public static String GENERATION_OUTPUT_MODE_WIZARD_PAGE_TITLE;
	public static String GENERATION_OUTPUT_MODE_WIZARD_PAGE_DESC;
	public static String GENERATION_OUTPUT_MODE_WIZARD_PAGE_GENERATION_OUTPUT_MODE;
	
	// Metadata Conversion
	public static String JAVA_METADATA_CONVERSION_NO_CONVERTERS_TO_CONVERT;
	public static String JAVA_CONVERTER_CONVERSION_WIZARD_PAGE_TITLE;
	public static String JAVA_CONVERTER_CONVERSION_WIZARD_PAGE_DESCRIPTION;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_CONVERTERS_WARNING_TITLE;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_CONVERTERS_WARNING_MESSAGE;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_GENERATORS_WARNING_TITLE;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_GENERATORS_WARNING_MESSAGE;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_QUERIES_WARNING_TITLE;
	public static String JAVA_METADATA_CONVERSION_EQUIVALENT_QUERIES_WARNING_MESSAGE;

	// Static Weaving
	public static String ECLIPSELINK_PREFERENCE_PAGE_DESCRIPTION;
	public static String ECLIPSELINK_PREFERENCE_PAGE_STATIC_WEAVING_GROUP_BOX;
	public static String ECLIPSELINK_PREFERENCE_PAGE_WEAVE_CLASSES_ON_BUILD_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_SOURCE_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_SELECT_SOURCE_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_SOURCE_FOLDER_SELECTION_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_TARGET_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_SELECT_TARGET_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_TARGET_FOLDER_SELECTION_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_PERSISTENCE_INFO_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_SELECT_PERSISTENCE_INFO_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_PERSISTENCE_INFO_FOLDER_SELECTION_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_LOG_LEVEL_LABEL;
	public static String ECLIPSELINK_PREFERENCE_PAGE_BROWSE;

	// New Dynamic Entity
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_APPLY_EMBEDDED_ID_MAPPING_INFO;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_BOTH_ID_AND_EMBEDDED_ID_DEFINED_ERROR;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_BROWSE_BUTTON_LABEL;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_DYNAMIC_TYPE_EXISTS_ERROR;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_DYNAMIC_TYPE_WITH_DIFF_CASE_EXISTS_ERROR;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_INVALID_ARGUMENT;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_INVALID_PK_TYPE;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_MULTIPLE_EMBEDDED_IDS_DEFINED_ERROR;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_ECLIPSELINK_PROJECT_NOT_FOUND_ERROR;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TITLE;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_EXISTS_WARNING;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_NOT_IN_PROJECT_CLASSPATH;
	public static String ECLIPSELINK_DYNAMIC_ENTITY_WIZARD_TYPE_WITH_DIFF_CASE_EXISTS_WARNING;

	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CHOOSE_XML_DIALOG_TITLE;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CHOOSE_XML_DIALOG_MSG;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_CLASS_NAME_LABEL;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_DEFAULT_PACKAGE_WARNING;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_DESC;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_EMPTY_STRING;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_ENTITY_NAME;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_INVALID_XML_NAME;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_JAVA_PACKAGE_LABEL;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_DESC;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_MSG;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PACKAGE_SELECTION_DIALOG_TITLE;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_PROJECT_NAME_LABEL;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TABLE_NAME;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TABLE_NAME_GROUP;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_TITLE;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_USE_DEFULT;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_GROUP;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_NAME_LABEL;
	public static String DYNAMIC_ENTITY_CLASS_WIZARD_PAGE_XML_NOT_LISTED_ERROR;

	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ADD_BUTTON_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ADD_DYNAMIC_ENTITY_FIELD_DIALOG_TITLE;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ATTRIBUTE_TYPE_COLUMN_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_DESC;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_DUPLICATE_ENTITY_FIELDS_ERROR;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_EDIT_BUTTON_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ENTITY_FIELD_GROUP;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_MAPPING_TYPE_COLUMN_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_NAME_COLUMN_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_NO_JPA_PROJECTS;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_REMOVE_BUTTON_LABEL;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_TITLE;
	public static String DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_TARGET_TYPE_COLUMN_LABEL;

	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_TITLE;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_NAME_LABEL;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_MAPPING_LABEL;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_ATTRIBUTE_TYPE_LABEL;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_NO_MAPPING_KEY_ERROR;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_NO_NAME_ERROR;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_NO_ATTRIBUTE_TYPE_ERROR;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_TARGET_TYPE_LABEL;
	public static String ADD_VIRTUAL_ATTRIBUTE_DIALOG_NO_TARGET_TYPE_ERROR;

	public static String MULTITENANCY_CATEGORY;
	public static String VIRTUAL_CATEGORY;

	private JptJpaEclipseLinkUiMessages() {
		throw new UnsupportedOperationException();
	}
}
