/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaPlatformUiManager;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.InternalJpaWorkbench;
import org.eclipse.jpt.jpa.ui.internal.platform.JpaPlatformUiConfig;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;

public class InternalJpaPlatformUiManager
implements JpaPlatformUiManager {
    private final InternalJpaWorkbench jpaWorkbench;
    private final ArrayList<JpaPlatformUiConfig> jpaPlatformUiConfigs = new ArrayList();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "jpaPlatformUis";
    private static final String JPA_PLATFORM_UI_ELEMENT = "jpaPlatformUi";
    private static final String ID_ATTRIBUTE = "id";
    private static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    private static final String JPA_PLATFORM_ATTRIBUTE = "jpaPlatform";

    public InternalJpaPlatformUiManager(InternalJpaWorkbench jpaWorkbench) {
        this.jpaWorkbench = jpaWorkbench;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                JpaPlatformUiConfig config;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(JPA_PLATFORM_UI_ELEMENT) && (config = this.buildJpaPlatformUiConfig(element)) != null) {
                    this.jpaPlatformUiConfigs.add(config);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private JpaPlatformUiConfig buildJpaPlatformUiConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (StringTools.isBlank((String)id)) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.containsJpaPlatformUiConfig(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String factoryClassName = element.getAttribute(FACTORY_CLASS_ATTRIBUTE);
        if (factoryClassName == null) {
            this.logMissingAttribute(element, FACTORY_CLASS_ATTRIBUTE);
            return null;
        }
        String jpaPlatformID = element.getAttribute(JPA_PLATFORM_ATTRIBUTE);
        if (jpaPlatformID == null) {
            this.logMissingAttribute(element, JPA_PLATFORM_ATTRIBUTE);
            return null;
        }
        if (this.containsJpaPlatformUiConfigForJpaPlatform(jpaPlatformID)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, JPA_PLATFORM_ATTRIBUTE, jpaPlatformID);
            return null;
        }
        if (this.jpaPlatformConfigIsMissing(jpaPlatformID)) {
            this.logMissingJpaPlatform(element, jpaPlatformID);
            return null;
        }
        JpaPlatformUiConfig config = new JpaPlatformUiConfig(this, id, factoryClassName, jpaPlatformID);
        config.setPluginID(contributor);
        return config;
    }

    public JpaPlatformUi getJpaPlatformUi(JpaPlatform jpaPlatform) {
        JpaPlatformUiConfig config = this.getJpaPlatformUiConfigForJpaPlatform(jpaPlatform.getId());
        return config == null ? null : config.getJpaPlatformUi();
    }

    private boolean containsJpaPlatformUiConfig(String id) {
        return this.getJpaPlatformUiConfig(id) != null;
    }

    private JpaPlatformUiConfig getJpaPlatformUiConfig(String id) {
        for (JpaPlatformUiConfig config : this.jpaPlatformUiConfigs) {
            if (!config.getID().equals(id)) continue;
            return config;
        }
        return null;
    }

    private boolean containsJpaPlatformUiConfigForJpaPlatform(String jpaPlatformID) {
        return this.getJpaPlatformUiConfigForJpaPlatform(jpaPlatformID) != null;
    }

    private JpaPlatformUiConfig getJpaPlatformUiConfigForJpaPlatform(String jpaPlatformID) {
        for (JpaPlatformUiConfig config : this.jpaPlatformUiConfigs) {
            if (!config.getJpaPlatformID().equals(jpaPlatformID)) continue;
            return config;
        }
        return null;
    }

    private void logMissingJpaPlatform(IConfigurationElement element, String jpaPlatformID) {
        this.logError(JptJpaUiMessages.JpaPlatformUi_missingJpaPlatform, jpaPlatformID, element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), element.getContributor().getName());
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage((IConfigurationElement)element, (String)attributeName));
    }

    public InternalJpaWorkbench getJpaWorkbench() {
        return this.jpaWorkbench;
    }

    String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptJpaUiPlugin getPlugin() {
        return JptJpaUiPlugin.instance();
    }

    private boolean jpaPlatformConfigIsMissing(String jpaPlatformID) {
        return this.getJpaPlatformConfig(jpaPlatformID) == null;
    }

    private JpaPlatform.Config getJpaPlatformConfig(String jpaPlatformID) {
        JpaPlatformManager jpaPlatformManager = this.getJpaPlatformManager();
        return jpaPlatformManager == null ? null : jpaPlatformManager.getJpaPlatformConfig(jpaPlatformID);
    }

    private JpaPlatformManager getJpaPlatformManager() {
        JpaWorkspace jpaWorkspace = this.getJpaWorkspace();
        return jpaWorkspace == null ? null : jpaWorkspace.getJpaPlatformManager();
    }

    private JpaWorkspace getJpaWorkspace() {
        return this.jpaWorkbench.getJpaWorkspace();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.jpaPlatformUiConfigs);
    }
}

