/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.base;

import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.OrmXmlItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceUnitItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceXmlItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.JpaStructureNodeItemContentProvider;

public abstract class AbstractNavigatorItemContentProviderFactory
implements ItemTreeContentProvider.Factory {
    protected AbstractNavigatorItemContentProviderFactory() {
    }

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof PersistenceXml) {
            return this.buildPersistenceXmlProvider((PersistenceXml)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof OrmXml) {
            return this.buildOrmXmlProvider((OrmXml)item, manager);
        }
        if (item instanceof JpaStructureNode) {
            return this.buildJpaStructureNodeProvider((JpaStructureNode)item, manager);
        }
        return null;
    }

    protected ItemTreeContentProvider buildPersistenceXmlProvider(PersistenceXml item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceXmlItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceUnitItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildOrmXmlProvider(OrmXml item, ItemTreeContentProvider.Manager manager) {
        return new OrmXmlItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildJpaStructureNodeProvider(JpaStructureNode item, ItemTreeContentProvider.Manager manager) {
        return new JpaStructureNodeItemContentProvider(item, manager);
    }
}

