/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RenameEntityCommand
implements Command {
    private PersistentType jpt;
    private String newEntityName;

    public RenameEntityCommand(PersistentType jpt, String newEntityName) {
        this.jpt = jpt;
        this.newEntityName = newEntityName;
    }

    public void execute() {
        this.renameEntityClass(JPAEditorUtil.getCompilationUnit(this.jpt), this.newEntityName);
        this.jpt.getJpaProject().getContextModelRoot().synchronizeWithResourceModel();
        JavaResourceType jrt = this.jpt.getJavaResourceType();
        jrt.getJavaResourceCompilationUnit().synchronizeWithJavaSource();
        this.jpt.update();
    }

    private void renameEntityClass(ICompilationUnit cu, String newName) {
        IJavaProject jp = JavaCore.create((IProject)this.jpt.getJpaProject().getProject());
        try {
            IType javaType = jp.findType(this.jpt.getName());
            this.renameType(javaType, newName);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void renameType(IType type, String newName) {
        if (!type.exists()) {
            return;
        }
        String oldName = type.getElementName();
        try {
            RenameSupport s = RenameSupport.create((IType)type, (String)newName, (int)1);
            IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            Shell sh = ww.getShell();
            s.perform(sh, (IRunnableContext)ww);
        }
        catch (Exception e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the type " + oldName, e1);
        }
    }
}

