/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;

public final class JSON {
    static boolean TRACE = false;
    public static final String LINE_FEED = "\r\n";
    public static final String CONTENT_LENGTH = "Content-Length:";

    public static void setTracing(boolean trace) {
        TRACE = trace;
    }

    private JSON() {
    }

    public static void writeKeyValue(String key, Object value, StringBuffer buffer) {
        JSON.writeString(key, buffer);
        buffer.append(':');
        JSON.writeValue(value, buffer);
    }

    public static void writeValue(Object value, StringBuffer buffer) {
        if (value == null) {
            buffer.append("null");
        } else if (value instanceof Boolean || value instanceof Number) {
            buffer.append(value.toString());
        } else if (value instanceof String) {
            JSON.writeString((String)value, buffer);
        } else if (value instanceof Collection) {
            JSON.writeArray((Collection)value, buffer);
        } else if (value instanceof Map) {
            JSON.writeObject((Map)value, buffer);
        }
    }

    public static void writeString(String string, StringBuffer buffer) {
        buffer.append('\"');
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        buffer.append("\\u");
                        String hexString = Integer.toHexString(c);
                        int j = hexString.length();
                        while (j < 4) {
                            buffer.append('0');
                            ++j;
                        }
                        buffer.append(hexString);
                        break;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        buffer.append('\"');
    }

    static void writeArray(Collection collection, StringBuffer buffer) {
        buffer.append('[');
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JSON.writeValue(iterator.next(), buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(']');
    }

    public static void writeObject(Map map, StringBuffer buffer) {
        buffer.append('{');
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            JSON.writeString(key, buffer);
            buffer.append(':');
            JSON.writeValue(map.get(key), buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
    }

    public static void writeContentLength(StringBuffer buffer, int length) {
        StringBuffer buff = new StringBuffer(18);
        buff.append(CONTENT_LENGTH).append(length).append(LINE_FEED).append(LINE_FEED);
        buffer.insert(0, buff.toString());
    }

    public static String serialize(CFPacket packet) {
        Map json = packet.toJSON();
        StringBuffer buffer = new StringBuffer();
        JSON.writeValue(json, buffer);
        int length = buffer.length();
        JSON.writeContentLength(buffer, length);
        buffer.append(LINE_FEED);
        if (TRACE) {
            Tracing.writeString("SERIALIZE: " + packet.getType() + " packet as " + buffer.toString());
        }
        return buffer.toString();
    }

    public static Object read(String jsonString) {
        return JSON.parse(new StringCharacterIterator(jsonString));
    }

    public static Object parse(CharacterIterator it) {
        JSON.parseWhitespace(it);
        Object result = JSON.parseValue(it);
        JSON.parseWhitespace(it);
        if (it.current() != '\uffff') {
            throw JSON.error("should be done", it);
        }
        return result;
    }

    private static RuntimeException error(String message, CharacterIterator it) {
        return new IllegalStateException("[" + it.getIndex() + "] " + message);
    }

    private static void parseWhitespace(CharacterIterator it) {
        char c = it.current();
        while (Character.isWhitespace(c)) {
            c = it.next();
        }
    }

    private static Object parseValue(CharacterIterator it) {
        switch (it.current()) {
            case '{': {
                return JSON.parseObject(it);
            }
            case '[': {
                return JSON.parseArray(it);
            }
            case '\"': {
                return JSON.parseString(it);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JSON.parseNumber(it);
            }
            case 't': {
                JSON.parseText(Boolean.TRUE.toString(), it);
                return Boolean.TRUE;
            }
            case 'f': {
                JSON.parseText(Boolean.FALSE.toString(), it);
                return Boolean.FALSE;
            }
            case 'n': {
                JSON.parseText("null", it);
                return null;
            }
            case 'u': {
                JSON.parseText("undefined", it);
                return null;
            }
        }
        throw JSON.error("Bad JSON starting character '" + it.current() + "'", it);
    }

    private static String parseString(CharacterIterator it) {
        char c = it.next();
        if (c == '\"') {
            it.next();
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        while (c != '\uffff' && c != '\"') {
            block15: {
                block16: {
                    if (Character.isISOControl(c)) {
                        c = it.next();
                        continue;
                    }
                    if (c != '\\') break block16;
                    c = it.next();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            buffer.append(c);
                            break block15;
                        }
                        case 'b': {
                            buffer.append('\b');
                            break block15;
                        }
                        case 'f': {
                            buffer.append('\f');
                            break block15;
                        }
                        case 'n': {
                            buffer.append('\n');
                            break block15;
                        }
                        case 'r': {
                            buffer.append('\r');
                            break block15;
                        }
                        case 't': {
                            buffer.append('\t');
                            break block15;
                        }
                        case 'u': {
                            StringBuffer unicode = new StringBuffer(4);
                            int i = 0;
                            while (i < 4) {
                                unicode.append(it.next());
                                ++i;
                            }
                            try {
                                buffer.append((char)Integer.parseInt(unicode.toString(), 16));
                                break block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JSON.error("expected a unicode hex number but was '" + unicode.toString() + "'", it);
                            }
                        }
                        default: {
                            throw JSON.error("illegal escape character '" + c + "'", it);
                        }
                    }
                }
                buffer.append(c);
            }
            c = it.next();
        }
        c = it.next();
        return buffer.toString();
    }

    private static Map parseObject(CharacterIterator it) {
        it.next();
        JSON.parseWhitespace(it);
        if (it.current() == '}') {
            it.next();
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (it.current() != '\uffff') {
            if (it.current() != '\"') {
                throw JSON.error("expected a string start '\"' but was '" + it.current() + "'", it);
            }
            String key = JSON.parseString(it);
            if (map.containsKey(key)) {
                throw JSON.error("' already definedkey '" + key, it);
            }
            JSON.parseWhitespace(it);
            if (it.current() != ':') {
                throw JSON.error("expected a pair separator ':' but was '" + it.current() + "'", it);
            }
            it.next();
            JSON.parseWhitespace(it);
            Object value = JSON.parseValue(it);
            map.put(key, value);
            JSON.parseWhitespace(it);
            if (it.current() == ',') {
                it.next();
                JSON.parseWhitespace(it);
                continue;
            }
            if (it.current() == '}') break;
            throw JSON.error("expected an object close '}' but was '" + it.current() + "'", it);
        }
        it.next();
        return map;
    }

    private static List parseArray(CharacterIterator it) {
        it.next();
        JSON.parseWhitespace(it);
        if (it.current() == ']') {
            it.next();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.current() != '\uffff') {
            Object value = JSON.parseValue(it);
            list.add(value);
            JSON.parseWhitespace(it);
            if (it.current() == ',') {
                it.next();
                JSON.parseWhitespace(it);
                continue;
            }
            if (it.current() == ']') break;
            throw JSON.error("expected an array close ']' but was '" + it.current() + "'", it);
        }
        it.next();
        return list;
    }

    private static void parseText(String string, CharacterIterator it) {
        int length = string.length();
        char c = it.current();
        int i = 0;
        while (i < length) {
            if (c != string.charAt(i)) {
                throw JSON.error("expected to parse '" + string + "' but character " + (i + 1) + " was '" + c + "'", it);
            }
            c = it.next();
            ++i;
        }
    }

    private static Object parseNumber(CharacterIterator it) {
        StringBuffer buffer = new StringBuffer();
        char c = it.current();
        while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') {
            buffer.append(c);
            c = it.next();
        }
        try {
            return new BigDecimal(buffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw JSON.error("expected a number but was '" + buffer.toString() + "'", it);
        }
    }
}

