/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSNonNegativeInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSPositiveInteger
extends XSNonNegativeInteger {
    private static final String XS_POSITIVE_INTEGER = "xs:positiveInteger";

    public XSPositiveInteger() {
        this(BigInteger.valueOf(1L));
    }

    public XSPositiveInteger(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_POSITIVE_INTEGER;
    }

    public String type_name() {
        return "positiveInteger";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(1L);
            if (bigInt.compareTo(min) < 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSPositiveInteger(bigInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_POSITIVEINTEGER;
    }

    public Object getNativeValue() {
        return this.getValue();
    }
}

