/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.NameTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameToolsTests
extends TestCase {
    public NameToolsTests(String name) {
        super(name);
    }

    public void testStringAbsentIgnoreCase() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameIgnoreCase((String)"Taupe", colorCollection);
        NameToolsTests.assertEquals((String)"Taupe", (String)returned);
    }

    public void testStringPresentCaseDiffers() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueName((String)"green", colorCollection);
        NameToolsTests.assertEquals((String)"green", (String)returned);
    }

    public void testStringPresentIgnoreCase() {
        List<String> colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameIgnoreCase((String)"green", colorCollection);
        NameToolsTests.assertEquals((String)"green2", (String)returned);
    }

    public void testStringPresentWithAppendices() {
        List<String> colorCollection = this.buildColorCollection();
        colorCollection.add("Red1");
        colorCollection.add("red2");
        String returned = NameTools.uniqueNameIgnoreCase((String)"red", colorCollection);
        colorCollection.remove("Red1");
        colorCollection.remove("red2");
        NameToolsTests.assertEquals((String)"red3", (String)returned);
    }

    private List<String> buildColorCollection() {
        ArrayList<String> colorCollection = new ArrayList<String>();
        colorCollection.add("Red");
        colorCollection.add("Orange");
        colorCollection.add("Yellow");
        colorCollection.add("Green");
        colorCollection.add("Blue");
        colorCollection.add("Indigo");
        colorCollection.add("Violet");
        return colorCollection;
    }

    public void testUniqueNameForCollection1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueName((String)"Test", strings));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueName((String)"Test", strings));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
    }

    public void testUniqueNameForIterable1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueName((String)"Test", strings));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForIterable2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueName((String)"Test", strings));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForIterable3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueName((String)"Oracle", strings));
    }

    public void testBuildQualifiedDatabaseObjectName() {
        NameToolsTests.assertEquals((String)"catalog.schema.name", (String)NameTools.buildQualifiedName((String[])new String[]{"catalog", "schema", "name"}));
        NameToolsTests.assertEquals((String)"catalog..name", (String)NameTools.buildQualifiedName((String[])new String[]{"catalog", null, "name"}));
        NameToolsTests.assertEquals((String)"schema.name", (String)NameTools.buildQualifiedName((String[])new String[]{null, "schema", "name"}));
        NameToolsTests.assertEquals((String)"name", (String)NameTools.buildQualifiedName((String[])new String[]{null, null, "name"}));
    }

    public void testJavaReservedWords() {
        NameToolsTests.assertTrue((boolean)NameTools.JAVA_RESERVED_WORDS.contains("class"));
        NameToolsTests.assertFalse((boolean)NameTools.JAVA_RESERVED_WORDS.contains("Class"));
        NameToolsTests.assertTrue((boolean)NameTools.JAVA_RESERVED_WORDS.contains("private"));
    }

    public void testconvertToJavaIdentifierString() {
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo"));
        NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1"));
        NameToolsTests.assertEquals((String)"private_", (String)NameTools.convertToJavaIdentifier((String)"private"));
        NameToolsTests.assertEquals((String)"throw_", (String)NameTools.convertToJavaIdentifier((String)"throw"));
        NameToolsTests.assertEquals((String)"_foo", (String)NameTools.convertToJavaIdentifier((String)"1foo"));
        NameToolsTests.assertEquals((String)"foo_", (String)NameTools.convertToJavaIdentifier((String)"foo%"));
        NameToolsTests.assertEquals((String)"foo__bar__", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  "));
    }

    public void testconvertToJavaIdentifierStringChar() {
        boolean exCaught;
        block8: {
            String s;
            block7: {
                block6: {
                    NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1", (char)'$'));
                    NameToolsTests.assertEquals((String)"private$", (String)NameTools.convertToJavaIdentifier((String)"private", (char)'$'));
                    NameToolsTests.assertEquals((String)"throwss", (String)NameTools.convertToJavaIdentifier((String)"throw", (char)'s'));
                    NameToolsTests.assertEquals((String)"$foo", (String)NameTools.convertToJavaIdentifier((String)"1foo", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo$", (String)NameTools.convertToJavaIdentifier((String)"foo%", (char)'$'));
                    NameToolsTests.assertEquals((String)"foo$$bar$$", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  ", (char)'$'));
                    exCaught = false;
                    try {
                        s = NameTools.convertToJavaIdentifier((String)"1foo", (char)'7');
                        NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage().indexOf(55) == -1) break block6;
                        exCaught = true;
                    }
                }
                NameToolsTests.assertTrue((boolean)exCaught);
                exCaught = false;
                try {
                    s = NameTools.convertToJavaIdentifier((String)"foo%", (char)'^');
                    NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().indexOf(94) == -1) break block7;
                    exCaught = true;
                }
            }
            NameToolsTests.assertTrue((boolean)exCaught);
            exCaught = false;
            try {
                s = NameTools.convertToJavaIdentifier((String)"private", (char)'^');
                NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().indexOf(94) == -1) break block8;
                exCaught = true;
            }
        }
        NameToolsTests.assertTrue((boolean)exCaught);
    }

    public void testStringIsLegalJavaIdentifier() {
        NameToolsTests.assertFalse((boolean)NameTools.isLegalJavaIdentifier((String)"class"));
        NameToolsTests.assertTrue((boolean)NameTools.isLegalJavaIdentifier((String)"clasS"));
        NameToolsTests.assertFalse((boolean)NameTools.isLegalJavaIdentifier((String)"7foo"));
        NameToolsTests.assertFalse((boolean)NameTools.isLegalJavaIdentifier((String)"foo@bar"));
        NameToolsTests.assertTrue((boolean)NameTools.isLegalJavaIdentifier((String)"_foo"));
    }

    public void testConvertGetterOrSetterMethodNameToPropertyName() {
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"getFoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"setFoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"isFoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"getfoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"setfoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"isfoo"));
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"foo"));
        NameToolsTests.assertEquals((String)"Foo", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"Foo"));
        NameToolsTests.assertEquals((String)"get", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"get"));
        NameToolsTests.assertEquals((String)"set", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"set"));
        NameToolsTests.assertEquals((String)"is", (String)NameTools.convertGetterOrSetterMethodNameToPropertyName((String)"is"));
    }
}

