/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test.newapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xerces.jaxp.validation.XSGrammarPoolContainer;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSModel;
import org.custommonkey.xmlunit.XMLTestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.XPath2Expression;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.Engine;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.xerces.XercesTypeModel;
import org.eclipse.wst.xml.xpath2.processor.util.DynamicContextBuilder;
import org.eclipse.wst.xml.xpath2.processor.util.StaticContextBuilder;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CompleteNewApiTest
extends XMLTestCase {
    protected Document domDoc = null;
    protected Bundle bundle = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        if (this.bundle == null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        }
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
    }

    protected void loadDOMDocument(URL fileURL) throws IOException {
        InputStream is = fileURL.openStream();
        XercesLoader domloader = new XercesLoader();
        domloader.set_validating(false);
        this.domDoc = domloader.load(is);
        this.domDoc.setDocumentURI(fileURL.toString());
    }

    protected XSModel getGrammar() {
        ElementPSVI rootPSVI = (ElementPSVI)this.domDoc.getDocumentElement();
        XSModel schema = rootPSVI.getSchemaInformation();
        return schema;
    }

    protected XSModel getGrammar(URL schemaURL) throws IOException, SAXException {
        InputStream schemaIs = schemaURL.openStream();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(schemaIs));
        XSGrammarPoolContainer poolContainer = (XSGrammarPoolContainer)schema;
        XMLGrammarPool pool = poolContainer.getGrammarPool();
        Grammar[] grammars = pool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        XSGrammar[] xsGrammars = new XSGrammar[grammars.length];
        System.arraycopy(grammars, 0, xsGrammars, 0, grammars.length);
        return xsGrammars[0].toXSModel(xsGrammars);
    }

    protected String buildResultString(ResultSequence rs) {
        String actual = new String();
        for (AnyType anyType : rs) {
            actual = String.valueOf(actual) + anyType.getStringValue() + " ";
        }
        return actual.trim();
    }

    protected Object evaluateSimpleXPath(String xpath, StaticContext sc, Document doc, Class resultClass) {
        Object[] objectArray;
        XPath2Expression path = new Engine().parseExpression(xpath, sc);
        DynamicContextBuilder dynamicContext = new DynamicContextBuilder(sc);
        if (doc != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = doc;
        } else {
            objectArray = new Object[]{};
        }
        ResultSequence rs = path.evaluate((DynamicContext)dynamicContext, objectArray);
        CompleteNewApiTest.assertEquals((String)("Expected single result from '" + xpath + "'"), (int)1, (int)rs.size());
        Object result = rs.value(0);
        CompleteNewApiTest.assertTrue((String)("Exected XPath result instanceof class " + resultClass.getSimpleName() + " from '" + xpath + "', got " + result.getClass()), (boolean)resultClass.isInstance(result));
        return result;
    }

    public void testSimpleMath() throws Exception {
        String xpath = "2+2 = 4";
        Boolean b = (Boolean)this.evaluateSimpleXPath(xpath, (StaticContext)new StaticContextBuilder(), null, Boolean.class);
        CompleteNewApiTest.assertEquals((Object)Boolean.TRUE, (Object)b);
    }

    public void testNamesWhichAreKeywords() throws Exception {
        this.bundle = Platform.getBundle((String)"org.eclipse.wst.xml.xpath2.processor.tests");
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug311480.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        String xpath = "((/element/eq eq 'eq') or //child::xs:*) and false";
        Boolean b = (Boolean)this.evaluateSimpleXPath(xpath, (StaticContext)new StaticContextBuilder().withNamespace("xs", "urn:joe").withTypeModel((TypeModel)new XercesTypeModel(schema)), this.domDoc, Boolean.class);
        CompleteNewApiTest.assertEquals((Object)Boolean.FALSE, (Object)b);
    }
}

