/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class LookupTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public LookupTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LookupTest.buildAllCompliancesTestSuite(LookupTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tprivate static int value = 23;\t\t\t\t\t\n\tclass B {\t\t\t\t\t\t\t\t\t\t\n\t\tprivate int value;\t\t\t\t\t\t\t\n\t\tB (int val) {\t\t\t\t\t\t\t\t\n\t\t\tvalue = (A.value * 2) + val;\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String args[]) {\t\t\n\t\tint result = new A().new B(12).value; \t\t\n\t\tint expected = 58; \t\t\t\t\t\t\t\n\t\tSystem.out.println( \t\t\t\t\t\t\n\t\t\tresult == expected \t\t\t\t\t\t\n\t\t\t\t? \"SUCCESS\"  \t\t\t\t\t\t\n\t\t\t\t: \"FAILED : got \"+result+\" instead of \"+ expected); \n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tprivate int value;\t\t\t\t\t\t\t\t\n\tstatic class B {\t\t\t\t\t\t\t\t\n\t\tB () {\t\t\t\t\t\t\t\t\t\t\n\t\t\tvalue = 2;\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tB result = new B();\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. WARNING in p1\\A.java (at line 3)\n\tprivate int value;\t\t\t\t\t\t\t\t\n\t            ^^^^^\nThe field A.value is never read locally\n----------\n2. ERROR in p1\\A.java (at line 6)\n\tvalue = 2;\t\t\t\t\t\t\t\t\n\t^^^^^\nCannot make a static reference to the non-static field value\n----------\n");
    }

    public void test003() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tprivate static int value;\t\t\t\t\t\t\n\tstatic class B {\t\t\t\t\t\t\t\t\n\t\tB () {\t\t\t\t\t\t\t\t\t\t\n\t\t\tvalue = 2;\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tB result = new B();\t\t\t\t\t\t\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}", "SUCCESS"});
    }

    public void test004() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tprivate String value;\t\t\t\t\t\t\t\n\tprivate A (String strIn) {\t\t\t\t\t\t\n\t\tvalue = new B(strIn, \"E\").str;\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tclass B {\t\t\t\t\t\t\t\t\t\t\n\t\tString str;\t\t\t\t\t\t\t\t\t\n\t\t\tprivate B (String strFromA, String strIn)\t{\n\t\t\t\tstr = strFromA + strIn + new C(\"S\").str;\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\tclass C {\t\t\t\t\t\t\t\t\t\n\t\t\tString str;\t\t\t\t\t\t\t\t\n\t\t\tprivate C (String strIn) {\t\t\t\t\n\t\t\t\tstr = strIn + new D(\"S\").str;\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\tclass D {\t\t\t\t\t\t\t\t\n\t\t\t\tString str;\t\t\t\t\t\t\t\n\t\t\t\tprivate D (String strIn) {\t\t\t\n\t\t\t\t\tstr = strIn;\t\t\t\t\t\n\t\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tSystem.out.println(new A(\"SUCC\").value);\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test005() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tprivate static void doSomething(String showThis) {\n\t\tSystem.out.print(showThis);\t\t\t\t\t\n\t\treturn;\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tclass B {\t\t\t\t\t\t\t\t\t\t\n\t\tvoid aMethod () {\t\t\t\t\t\t\t\n\t\t\tp1.A.doSomething(\"SUCC\");\t\t\t\t\n\t\t\tA.doSomething(\"ES\");\t\t\t\t\t\n\t\t\tdoSomething(\"S\");\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tB foo = new A().new B();\t\t\t\t\t\n\t\tfoo.aMethod();\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tprivate static String success = \"SUCCESS\";\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aTask();\t\t\t\t\n\t\tclass C extends A implements B {\t\t\t\n\t\t\tpublic void aTask() {System.out.println(this.success);}\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String[] argv) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. WARNING in p1\\A.java (at line 3)\n\tprivate static String success = \"SUCCESS\";\t\n\t                      ^^^^^^^\nThe field A.success is never read locally\n----------\n2. ERROR in p1\\A.java (at line 7)\n\tpublic void aTask() {System.out.println(this.success);}\n\t                                             ^^^^^^^\nThe field A.success is not visible\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tprivate static String success = \"SUCCESS\";\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aTask();\t\t\t\t\n\t\tclass C extends A implements B {\t\t\t\n\t\t\tpublic void aTask() {System.out.println(A.success);}\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String[] argv) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test008() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tprivate static String success = \"SUCCESS\";\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aTask();\t\t\t\t\n\t\tclass C extends A implements B {\t\t\t\n\t\t\tpublic void aTask() {System.out.println(A.this.success);}\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String[] argv) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p1\\A.java (at line 7)\n\tpublic void aTask() {System.out.println(A.this.success);}\n\t                                        ^^^^^^\nNo enclosing instance of the type A is accessible in scope\n----------\n2. WARNING in p1\\A.java (at line 7)\n\tpublic void aTask() {System.out.println(A.this.success);}\n\t                                               ^^^^^^^\nThe static field A.success should be accessed in a static way\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tprivate String success = \"SUCCESS\";\t\t\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aTask();\t\t\t\t\n\t\tclass C extends A implements B {\t\t\t\n\t\t\tpublic void aTask() {System.out.println(this.success);}\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String[] argv) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. WARNING in p1\\A.java (at line 3)\n\tprivate String success = \"SUCCESS\";\t\t\t\n\t               ^^^^^^^\nThe field A.success is never read locally\n----------\n2. ERROR in p1\\A.java (at line 7)\n\tpublic void aTask() {System.out.println(this.success);}\n\t                                             ^^^^^^^\nThe field A.success is not visible\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nclass A {\t\t\t\t\t\t\t\t\t\t\t\n\tprivate String success = \"SUCCESS\";\t\t\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aTask();\t\t\t\t\n\t\tclass C extends A implements B {\t\t\t\n\t\t\tpublic void aTask() {System.out.println(A.success);}\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String[] argv) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. WARNING in p1\\A.java (at line 3)\n\tprivate String success = \"SUCCESS\";\t\t\t\n\t               ^^^^^^^\nThe field A.success is never read locally\n----------\n2. ERROR in p1\\A.java (at line 7)\n\tpublic void aTask() {System.out.println(A.success);}\n\t                                        ^^^^^^^^^\nCannot make a static reference to the non-static field A.success\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"p2/Aa.java", "package p2;\t\t\t\t\t\t\t\t\t\t\nclass Aa extends p1.A{\t\t\t\t\t\t\t\t\n\tclass B implements p1.A.C {\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String args[]) {\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}", "p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n   public A() {\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tclass B implements C {\t\t\t\t\t\t\t\n\t\tpublic int sMethod() {\t\t\t\t\t\t\n\t\t\treturn 23;\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic interface C {\t\t\t\t\t\t\t\n\t\tpublic abstract int sMethod();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p2\\Aa.java (at line 3)\n\tclass B implements p1.A.C {\t\t\t\t\t\t\n\t      ^\nThe type Aa.B must implement the inherited abstract method A.C.sMethod()\n----------\n");
    }

    public void test012() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aMethod (int A);\t\t\n\t\tpublic interface C {\t\t\t\t\t\t\n\t\t\tpublic abstract void anotherMethod();\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class aClass implements B, B.C {\t\t\t\n\t\tpublic void aMethod (int A) {\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t\tpublic void anotherMethod(){}\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n   \tpublic static void main (String argv[]) {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tpublic interface B {\t\t\t\t\t\t\t\n\t\tpublic abstract void aMethod (int A);\t\t\n\t\tpublic interface C {\t\t\t\t\t\t\n\t\t\tpublic abstract void anotherMethod(int A);\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class aClass implements B, B.C {\t\t\t\n\t\tpublic void aMethod (int A) {\t\t\t\t\n\t\t\tpublic void anotherMethod(int A) {};\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n   \tpublic static void main (String argv[]) {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p1\\A.java (at line 9)\n\tpublic class aClass implements B, B.C {\t\t\t\n\t             ^^^^^^\nThe type A.aClass must implement the inherited abstract method A.B.C.anotherMethod(int)\n----------\n2. ERROR in p1\\A.java (at line 11)\n\tpublic void anotherMethod(int A) {};\t\n\t                         ^\nSyntax error on token \"(\", ; expected\n----------\n3. ERROR in p1\\A.java (at line 11)\n\tpublic void anotherMethod(int A) {};\t\n\t                               ^\nSyntax error on token \")\", ; expected\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"pack1/First.java", "package pack1;\t\t\t\t\t\t\t\t\t\t\npublic class First {\t\t\t\t\t\t\t\t\n\tpublic static void something() {}\t\t\t\t\n\t\tclass Inner {}\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tFirst.Inner foo = new First().new Inner();\t\n\t\tfoo.something();\t\t\t\t\t\t\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in pack1\\First.java (at line 7)\n\tfoo.something();\t\t\t\t\t\t\t\n\t    ^^^^^^^^^\nThe method something() is undefined for the type First.Inner\n----------\n");
    }

    public void test015() {
        this.runConformTest(new String[]{"pack1/First.java", "package pack1;\t\t\t\t\t\t\t\t\t\t\npublic class First {\t\t\t\t\t\t\t\t\n\t\tclass Inner {\t\t\t\t\t\t\t\t\n\t\t\tpublic void something() {}\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tFirst.Inner foo = new First().new Inner();\t\n\t\tfoo.something();\t\t\t\t\t\t\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test016() {
        this.runConformTest(new String[]{"pack1/Outer.java", "package pack1;\t\t\t\t\t\t\t\t\t\t\nimport pack2.*;\t\t\t\t\t\t\t\t\t\npublic class Outer {\t\t\t\t\t\t\t\t\n\tint time, distance;\t\t\t\t\t\t\t\t\n\tpublic Outer() {\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic Outer(int d) {\t\t\t\t\t\t\t\n\t\tdistance = d;\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic void aMethod() {\t\t\t\t\t\t\t\n\t\tthis.distance *= 2;\t\t\t\t\t\t\t\n\t\treturn;\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}", "pack2/OuterTwo.java", "package pack2;\t\t\t\t\t\t\t\t\t\t\nimport pack1.*;\t\t\t\t\t\t\t\t\t\npublic class OuterTwo extends Outer {\t\t\t\t\n\tpublic OuterTwo(int bar) {\t\t\t\t\t\t\n\t\tOuter A = new Outer(3) {\t\t\t\t\t\n\t\t\tpublic void bMethod(){\t\t\t\t\t\n\t\t\t\tfinal class X {\t\t\t\t\t\t\n\t\t\t\t\tint price;\t\t\t\t\t\t\n\t\t\t\t\tpublic X(int inp) {\t\t\t\t\n\t\t\t\t\t\tprice = inp + 32;\t\t\t\n\t\t\t\t\t}\t\t\t\t\t\t\t\t\n\t\t\t\t}\t\t\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t};\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tSystem.out.println(\"\");\t\t\t\t\t\n\t\tOuterTwo foo = new OuterTwo(12);\t\t\t\n\t\tOuter bar = new Outer(8);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test017() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A\t{\t\t\t\t\t\t\t\t\t\n\tint value;\t\t\t\t\t\t\t\t\t\t\n\tpublic A(B bVal) {\t\t\t\t\t\t\t\t\n\t\tbVal.sval += \"V\";\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tstatic class B {\t\t\t\t\t\t\t\t\n\t\tpublic static String sval;\t\t\t\t\t\n\t\tpublic void aMethod() {\t\t\t\t\t\t\n\t\t\tsval += \"S\";\t\t\t\t\t\t\t\n\t\t\tA bar = new A(this);\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tB foo = new B();\t\t\t\t\t\t\t\n\t\tfoo.sval = \"U\";\t\t\t\t\t\t\t\n\t\tfoo.aMethod();\t\t\t\t\t\t\t\t\n\t\tSystem.out.println(foo.sval);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "USV");
    }

    public void test018() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A\t{\t\t\t\t\t\t\t\t\t\n\tprivate String rating;\t\t\t\t\t\t\t\n\tpublic class B {\t\t\t\t\t\t\t\t\n\t\tString rating;\t\t\t\t\t\t\t\t\n\t\tpublic B (A sth) {\t\t\t\t\t\t\t\n\t\t\tsth.rating = \"m\";\t\t\t\t\t\t\n\t\t\trating = \"er\";\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tA foo = new A();\t\t\t\t\t\t\t\n\t\tfoo.rating = \"o\";\t\t\t\t\t\t\t\n\t\tB bar = foo.new B(foo);\t\t\t\t\t\t\n\t\tSystem.out.println(foo.rating + bar.rating);\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "mer");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A\t{\t\t\t\t\t\t\t\t\t\n\tprivate String rating;\t\t\t\t\t\t\t\n\tpublic void setRating(A sth, String setTo) {\t\n\t\tsth.rating = setTo;\t\t\t\t\t\t\t\n\t\treturn;\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class B {\t\t\t\t\t\t\t\t\n\t\tpublic B (A sth) {\t\t\t\t\t\t\t\n\t\t\tsetRating(sth, \"m\");\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tA foo = new A();\t\t\t\t\t\t\t\n\t\tfoo.rating = \"o\";\t\t\t\t\t\t\t\n\t\tB bar = foo.new B(foo);\t\t\t\t\t\t\n\t\tSystem.out.println(foo.rating + bar.other);\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p1\\A.java (at line 17)\n\tSystem.out.println(foo.rating + bar.other);\t\n\t                                ^^^^^^^^^\nbar.other cannot be resolved or is not a field\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A\t{\t\t\t\t\t\t\t\t\t\n\tprivate String rating;\t\t\t\t\t\t\t\n\tpublic class B {\t\t\t\t\t\t\t\t\n\t\tpublic B (A sth) {\t\t\t\t\t\t\t\n\t\t\tsth.rating = \"m\";\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tA foo = new A();\t\t\t\t\t\t\t\n\t\tfoo.rating = \"o\";\t\t\t\t\t\t\t\n\t\tB bar = foo.new B(foo);\t\t\t\t\t\t\n\t\tSystem.out.println(foo.rating + bar.other);\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. WARNING in p1\\A.java (at line 6)\n\tsth.rating = \"m\";\t\t\t\t\t\t\n\t    ^^^^^^\nWrite access to enclosing field A.rating is emulated by a synthetic accessor method. Increasing its visibility will improve your performance\n----------\n2. ERROR in p1\\A.java (at line 13)\n\tSystem.out.println(foo.rating + bar.other);\t\n\t                                ^^^^^^^^^\nbar.other cannot be resolved or is not a field\n----------\n");
    }

    public void test021() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\npublic class A\t{\t\t\t\t\t\t\t\t\t\n\tprivate String rating;\t\t\t\t\t\t\t\n\tpublic class B {\t\t\t\t\t\t\t\t\n\t\tpublic B (A sth) {\t\t\t\t\t\t\t\n\t\t\tsth.rating = \"m\";\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tA foo = new A();\t\t\t\t\t\t\t\n\t\tfoo.rating = \"o\";\t\t\t\t\t\t\t\n\t\tB bar = foo.new B(foo);\t\t\t\t\t\t\n\t\tSystem.out.println(foo.rating);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test022() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\t\nimport p2.*;\t\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\t\n\tpublic int aValue;\t\t\t\t\t\t\t\t\n\tpublic A() {}\t\t\t\t\t\t\t\t\t\n\tpublic static class C extends A {\t\t\t\t\n\t\tpublic String aString;\t\t\t\t\t\t\n\t\tpublic C() {\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}", "p2/B.java", "package p2;\t\t\t\t\t\t\t\t\t\t\nimport p1.*;\t\t\t\t\t\t\t\t\t\t\npublic class B extends A.C {\t\t\t\t\t\t\n\tpublic B() {}\t\t\t\t\t\t\t\t\t\n\tpublic class D extends A {\t\t\t\t\t\t\n\t\tpublic D() {\t\t\t\t\t\t\t\t\n\t\t\tC val2 = new C();\t\t\t\t\t\t\n\t\t\tval2.aString = \"s\";\t\t\t\t\t\n\t\t\tA val = new A();\t\t\t\t\t\t\n\t\t\tval.aValue = 23;\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\t\n\t\tD foo = new B().new D();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test023() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\npublic class A implements B {\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\ninterface B {\t\t\t\t\t\t\t\t\t\t\n\tpublic class A implements B {\t\t\t\t\t\n\t\tpublic static void main (String argv[]) {\t\n\t\t\tclass Ba {\t\t\t\t\t\t\t\t\n\t\t\t\tint time;\t\t\t\t\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t\tBa foo = new Ba();\t\t\t\t\t\t\n\t\t\tfoo.time = 3;\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t\tinterface C {\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t\tinterface Bb extends C {\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test024() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\n\tprotected static String bleh;\t\t\t\t\n\tinterface B {\t\t\t\t\t\t\t\t\n\t\tpublic String bleh();\t\t\t\t\t\n\t\tclass C{\t\t\t\t\t\t\t\t\n\t\t\tpublic String bleh() {return \"B\";}\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tclass C implements B {\t\t\t\t\t\t\n\t\tpublic String bleh() {return \"A\";}\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]) {\t\n\t\tC foo = new A().new C();\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}"});
    }

    public void test025() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\nimport p2.*;\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\n\tpublic static class B {\t\t\t\t\t\n\t\tpublic static int B;\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]) {\n\t\tB foo = new A.B();\t\t\t\t\t\n\t\tB bar = new B();\t\t\t\t\t\n\t\tfoo.B = 2;\t\t\t\t\t\t\t\n\t\tp2.B bbar = new p2.B();\t\t\t\t\n\t\tif (bar.B == 35) {\t\t\t\t\t\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\telse {\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println(bar.B);\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}", "p2/B.java", "package p2;\t\t\t\t\t\t\t\t\nimport p1.*;\t\t\t\t\t\t\t\t\npublic class B extends A {\t\t\t\t\t\n\tpublic B() {\t\t\t\t\t\t\t\n\t\tA.B bleh = new A.B();\t\t\t\t\n\t\tbleh.B = 35;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\n\tpublic static class B {\t\t\t\t\t\n\t\tprotected static int B;\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]) {\n\t\tB foo = new A.B();\t\t\t\t\t\n\t\tB bar = new B();\t\t\t\t\t\n\t\tB.B = 2;\t\t\t\t\t\t\t\n\t\tp2.B bbar = new p2.B();\t\t\t\t\n\t\tif (B.B == 35) {\t\t\t\t\t\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\telse {\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println(B.B);\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}", "p2/B.java", "package p2;\t\t\t\t\t\t\t\t\nimport p1.*;\t\t\t\t\t\t\t\t\npublic class B extends A {\t\t\t\t\t\n\tpublic B() {\t\t\t\t\t\t\t\n\t\tA.B bleh = new A.B();\t\t\t\t\n\t\tbleh.B = 35;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p2\\B.java (at line 6)\n\tbleh.B = 35;\t\t\t\t\t\t\n\t     ^\nThe field A.B.B is not visible\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\n\tprotected static class B {\t\t\t\t\n\t\tpublic static int B;\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main(String argv[]) {\n\t\tB foo = new A.B();\t\t\t\t\t\n\t\tB bar = new B();\t\t\t\t\t\n\t\tB.B = 2;\t\t\t\t\t\t\t\n\t\tp2.B bbar = new p2.B();\t\t\t\t\n\t\tif (B.B == 35) {\t\t\t\t\t\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\t\t\t\t\t\t\t\t\t\n\t\telse {\t\t\t\t\t\t\t\t\n\t\t\tSystem.out.println(B.B);\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}", "p2/B.java", "package p2;\t\t\t\t\t\t\t\t\nimport p1.*;\t\t\t\t\t\t\t\t\npublic class B extends A {\t\t\t\t\t\n\tpublic B() {\t\t\t\t\t\t\t\n\t\tA.B bleh = new A.B();\t\t\t\t\n\t\tA.B.B = 35;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}"}, "----------\n1. ERROR in p2\\B.java (at line 5)\n\tA.B bleh = new A.B();\t\t\t\t\n\t           ^^^^^^^^^\nThe constructor A.B() is not visible\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"p1/A.java", "package p1;\t\t\t\t\t\t\t\t\t\npublic class A {\t\t\t\t\t\t\t\t\n\tstatic class B {\t\t\t\t\t\t\t\n\t\tpublic static class C {\t\t\t\t\t\n\t\t\tprivate static int a;\t\t\t\t\n\t\t\tprivate int b;\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tclass D extends B {\t\t\t\t\t\t\t\n\t\tint j = p1.A.B.C.a;\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic static void main (String argv[]) {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}"}, "SUCCESS");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"p1/X.java", "package p1;\t\nimport p2.Top;\t\npublic class X extends Top {\t\n\tMember field;\t\n}\t\n", "p2/Top.java", "package p2;\t\npublic class Top {\t\n\tclass Member {\t\n\t\tvoid foo(){}\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p1\\X.java (at line 4)\n\tMember field;\t\n\t^^^^^^\nThe type Member is not visible\n----------\n");
    }

    public void test030() {
        Hashtable<String, String> target1_2 = new Hashtable<String, String>();
        target1_2.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
        this.runConformTest(new String[]{"p1/A.java", "package p1; \npublic abstract class A implements I {\t\n  public static void main(String[] args) {\t\n    System.out.println(\"SUCCESS\");\t\n  }\t\n} \ninterface I {\t\n\tvoid foo();\t\n}\t\n"}, "SUCCESS", null, true, null, target1_2, null);
        this.runConformTest(new String[]{"p1/C.java", "package p1; \npublic class C {\t\n\tvoid bar(A a){ \n\t\ta.foo();\t\n\t}\t\n  public static void main(String[] args) {\t\n    System.out.println(\"SUCCESS\");\t\n  }\t\n} \n"}, "SUCCESS", null, false, null, null, null);
    }

    public void test031() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X extends AbstractY {\t\n\tpublic void init() {\t\n\t\tsuper.init();\t\n\t}\t\n\tpublic static void main(String[] arguments) {\t\n\t\tnew X().init();\t\n\t}\t\n}\t\nabstract class AbstractY extends AbstractZ implements I {\t\n\tpublic void init(int i) {\t\n\t}\t\n}\t\nabstract class AbstractZ implements I {\t\n\tpublic void init() {\t\n\t\tSystem.out.println(\"SUCCESS\");\t\n\t}\t\n}\t\ninterface I {\t\n\tvoid init();\t\n\tvoid init(int i);\t\n}\t\n"}, "SUCCESS");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] arguments) {\n\t\tSystem.out.println(p.Bar.array[0].length);\n\t\tSystem.out.println(p.Bar.array.length);\n\t\tSystem.out.println(p.Bar.array[0].foo());\n\t}\n}\n", "p/Bar.java", "package p;\npublic class Bar {\n\tpublic static Z[] array;\n}\nclass Z {\n\tpublic String foo(){ \n\t\treturn \"\";\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(p.Bar.array[0].length);\n\t                   ^^^^^^^^^^^^^^\nThe type Z is not visible\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(p.Bar.array.length);\n\t                   ^^^^^^^^^^^^^^^^^^\nThe type Z is not visible\n----------\n3. ERROR in X.java (at line 5)\n\tSystem.out.println(p.Bar.array[0].foo());\n\t                   ^^^^^^^^^^^^^^\nThe type Z is not visible\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n}\t\n", "q/Y.java", "package q;\t\npublic class Y extends p.X {\t\n\tvoid foo(){}\t\n}\t\n"}, "----------\n1. ERROR in q\\Y.java (at line 2)\n\tpublic class Y extends p.X {\t\n\t             ^\nThis class must implement the inherited abstract method X.foo(), but cannot override it since it is not visible from Y. Either make the type abstract or make the inherited method visible\n----------\n2. WARNING in q\\Y.java (at line 3)\n\tvoid foo(){}\t\n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X {\t\n\tvoid foo(){}\t\n}\t\nclass Z extends Y {\t\n}\t\n"}, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo(){}\t\n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n2. ERROR in q\\Y.java (at line 5)\n\tclass Z extends Y {\t\n\t      ^\nThis class must implement the inherited abstract method X.foo(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n\tabstract void bar();\t\n}\t\n", "p/Y.java", "package p;\t\npublic abstract class Y extends X {\t\n\tvoid foo(){};\t\n}\t\n", "q/Z.java", "package q;\t\nclass Z extends p.Y {\t\n}\t\n"}, "----------\n1. ERROR in q\\Z.java (at line 2)\n\tclass Z extends p.Y {\t\n\t      ^\nThis class must implement the inherited abstract method X.bar(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n\tpublic interface I {\t\n\t\tvoid foo();\t\n\t}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X {\t\n\tvoid foo(){}\t\n}\t\nclass Z extends Y implements p.X.I {\t\n}\t\n"}, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo(){}\t\n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n2. ERROR in q\\Y.java (at line 5)\n\tclass Z extends Y implements p.X.I {\t\n\t      ^\nThis class must implement the inherited abstract method X.foo(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n3. ERROR in q\\Y.java (at line 5)\n\tclass Z extends Y implements p.X.I {\t\n\t      ^\nThe inherited method Y.foo() cannot hide the public abstract method in X.I\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n\tvoid bar(){}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X {\t\n\tvoid foo(){}\t//warn \n\tvoid bar(){}\t//warn \n}\t\nclass Z extends Y {\t\n\tvoid bar(){}\t//nowarn \n}\t\n"}, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo(){}\t//warn \n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n2. WARNING in q\\Y.java (at line 4)\n\tvoid bar(){}\t//warn \n\t     ^^^^^\nThe method Y.bar() does not override the inherited method from X since it is private to a different package\n----------\n3. ERROR in q\\Y.java (at line 6)\n\tclass Z extends Y {\t\n\t      ^\nThis class must implement the inherited abstract method X.foo(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y extends p.X {\t\n\tvoid foo(){}\t//warn \n}\t\nclass Z extends Y {\t\n\tvoid foo(){}\t//error \n}\t\n"}, "----------\n1. WARNING in q\\Y.java (at line 3)\n\tvoid foo(){}\t//warn \n\t     ^^^^^\nThe method Y.foo() does not override the inherited method from X since it is private to a different package\n----------\n2. ERROR in q\\Y.java (at line 5)\n\tclass Z extends Y {\t\n\t      ^\nThis class must implement the inherited abstract method X.foo(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic abstract class X {\t\n\tabstract void foo();\t\n\tabstract void bar();\t\n}\t\n", "p/Y.java", "package p;\t\npublic abstract class Y extends X {\t\n\tpublic void foo(){};\t\n}\t\n", "q/Z.java", "package q;\t\nclass Z extends p.Y {\t\n}\t\n"}, "----------\n1. ERROR in q\\Z.java (at line 2)\n\tclass Z extends p.Y {\t\n\t      ^\nThis class must implement the inherited abstract method X.bar(), but cannot override it since it is not visible from Z. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X extends q.Y.Member {\t\n\t\tvoid baz(){}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y {\t\n\tabstract void foo();\t\n\tabstract void bar();\t\n\tabstract void baz();\t\n\tpublic static abstract class Member extends Y {\t\n\t\tpublic void foo() {}\t\n\t\tvoid bar(){}\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends q.Y.Member {\t\n\t             ^\nThis class must implement the inherited abstract method Y.baz(), but cannot override it since it is not visible from X. Either make the type abstract or make the inherited method visible\n----------\n2. WARNING in p\\X.java (at line 3)\n\tvoid baz(){}\t\n\t     ^^^^^\nThe method X.baz() does not override the inherited method from Y since it is private to a different package\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X extends q.Y.Member {\t\n\tpublic void foo() {}\t\n\tpublic static class M extends X {}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y {\t\n\tabstract void foo();\t\n\tabstract void bar();\t\n\tpublic static abstract class Member extends Y {\t\n\t\tprotected abstract void foo();\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends q.Y.Member {\t\n\t             ^\nThis class must implement the inherited abstract method Y.bar(), but cannot override it since it is not visible from X. Either make the type abstract or make the inherited method visible\n----------\n2. ERROR in p\\X.java (at line 4)\n\tpublic static class M extends X {}\t\n\t                    ^\nThis class must implement the inherited abstract method Y.bar(), but cannot override it since it is not visible from M. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\t\npublic class X extends q.Y.Member {\t\n\tpublic void foo() {}\t\n\tpublic static class M extends X {}\t\n}\t\n", "q/Y.java", "package q;\t\npublic abstract class Y {\t\n\tabstract void foo();\t\n\tabstract void bar();\t\n\tpublic static abstract class Member extends Y {\t\n\t\tvoid foo(){}\t\n\t}\t\n}\t\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends q.Y.Member {\t\n\t             ^\nThis class must implement the inherited abstract method Y.bar(), but cannot override it since it is not visible from X. Either make the type abstract or make the inherited method visible\n----------\n2. WARNING in p\\X.java (at line 3)\n\tpublic void foo() {}\t\n\t            ^^^^^\nThe method X.foo() does not override the inherited method from Y.Member since it is private to a different package\n----------\n3. ERROR in p\\X.java (at line 4)\n\tpublic static class M extends X {}\t\n\t                    ^\nThis class must implement the inherited abstract method Y.bar(), but cannot override it since it is not visible from M. Either make the type abstract or make the inherited method visible\n----------\n");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic interface Copyable extends Cloneable {\n\t\tpublic Object clone() throws CloneNotSupportedException;\n\t}\n\n\tpublic interface TestIf extends Copyable {\n\t}\n\n\tpublic static class ClassA implements Copyable {\n\t\tpublic Object clone() throws CloneNotSupportedException {\n\t\t\treturn super.clone();\n\t\t}\n\t}\n\n\tpublic static class ClassB implements TestIf {\n\t\tpublic Object clone() throws CloneNotSupportedException {\n\t\t\treturn super.clone();\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) throws Exception {\n\t\tCopyable o1 = new ClassA();\n\t\tClassB o2 = new ClassB();\n\t\tTestIf o3 = o2;\n\t\tObject clonedObject;\n\t\tclonedObject = o1.clone();\n\t\tclonedObject = o2.clone();\n\t\tclonedObject = o3.clone();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test044() {
        this.runConformTest(new String[]{"p/Dumbo.java", "package p;\npublic class Dumbo {\n  public class Clyde { }\n\tpublic static void main(String[] args) {\n\t\t  System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
        Util.delete(new File(OUTPUT_DIR, "p" + File.separator + "Dumbo$Clyde.class"));
        this.runConformTest(new String[]{"q/Main.java", "package q;\npublic class Main extends p.Dumbo {\n\tpublic static void main(String[] args) {\n\t\t  p.Dumbo d;\n\t\t  System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test045() {
        this.runConformTest(new String[]{"p/Dumbo.java", "package p;\npublic class Dumbo {\n  public class Clyde {\n  \t  public class Fred {\n\t  }\n\t}\n\tpublic static void main(String[] args) {\n\t\t  System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
        this.runConformTest(new String[]{"q/Main.java", "package q;\npublic class Main extends p.Dumbo {\n\tpublic static void main(String[] args) {\n\t\t  p.Dumbo.Clyde.Fred f;\n\t\t  System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS", null, false, null);
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n     private XY foo(XY t) {\n        System.out.println(t);\n        return t;\n    }\n    public static void main(String[] args) {\n        new X() {\n            void run() {\n                foo(new XY());\n            }\n        }.run();\n    }\n}\nclass XY {\n    public String toString() {\n        return \"SUCCESS\";\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tfoo(new XY());\n\t^^^\nCannot make a static reference to the non-static method foo(XY) from the type X\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X extends SuperTest\n{\n    public X()\n    {\n        super();\n    }\n  \n    static void print(Object obj)\n    {\n        System.out.println(\"Object:\" + obj.toString());\n    }\n    \n    public static void main(String[] args)\n    {\n        print(\"Hello world\");\n    }\n}\nclass SuperTest\n{\n    SuperTest(){};\n    static void print(String s)\n    {\n        System.out.println(\"String: \" + s);\n    }\n}\n"}, "String: Hello world");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "public class X\n{\n    private String foo() {\n        return \"Started \" + java.text.DateFormat.format(new java.util.Date());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\r\n\treturn \"Started \" + java.text.DateFormat.format(new java.util.Date());\r\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot make a static reference to the non-static method format(Date) from the type DateFormat\n----------\n");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String argv[]) {\n    \tX.Y.Z.foo();\n    }\n    static class Y {\n    \tstatic class Z {\n    \t\tstatic void foo() {\n    \t\t\tSystem.out.println(\"SUCCESS\");\n    \t\t}\n    \t}\n    }\n}\n"}, "SUCCESS");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n        args.finalize();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\targs.finalize();\n\t     ^^^^^^^^\nThe method finalize() from the type Object is not visible\n----------\n");
    }

    public void test052() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void test() {\n\t\tclass C {\n\t\t\tpublic C() {\n\t\t\t}\n\t\t\tpublic void foo() {\n\t\t\t\tSystem.out.println(\"hello\");\n\t\t\t}\n\t\t}\n\t\tint n = 0;\n\t\tswitch (n) {\n\t\t\tcase 0 :\n\t\t\t\tif (true) {\n\t\t\t\t\tC c2 = new C();\n\t\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void test() {\n\t\tint l = 1;\n\t\tswitch(l) {\n\t\t\tcase 1: \n\t\t\t\tclass C {\n\t\t\t\t\tpublic C() {\n\t\t\t\t\t}\n\t\t\t\t\tpublic void foo() {\n\t\t\t\t\t\tSystem.out.println(\"hello\");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tint n = 0;\n\t\t\t\tswitch (n) {\n\t\t\t\t\tcase 0 :\n\t\t\t\t\t\tif (true) {\n\t\t\t\t\t\t\tC c2 = new C();\n\t\t\t\t\t\t}\n\t\t\t\t}\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "import java.util.LinkedHashMap;\nimport java.util.Map.Entry;\n\npublic class X {\n    \n    private LinkedHashMap fCache;\n    \n    public X(final int cacheSize) {\n        // start with 100 elements but be able to grow until cacheSize\n        fCache= new LinkedHashMap(100, 0.75f, true) {\n            /** This class is not intended to be serialized. */\n            private static final long serialVersionUID= 1L;\n            protected boolean removeEldestEntry(Entry eldest) {\n                return size() > cacheSize;\n            }\n        };\n    }\n}\n"}, "");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"A.java", "import p.*;\npublic class A {\n    public void errors() {\n    B b = new B();\n        String s1 = b.str;\n        String s2 = B.str;\n    }\n}\n", "p/B.java", "package p;\nclass B {\n    public static String str;\n}\n"}, "----------\n1. ERROR in A.java (at line 4)\r\n\tB b = new B();\r\n\t^\nThe type B is not visible\n----------\n2. ERROR in A.java (at line 4)\r\n\tB b = new B();\r\n\t          ^\nThe type B is not visible\n----------\n3. ERROR in A.java (at line 6)\r\n\tString s2 = B.str;\r\n\t            ^\nThe type B is not visible\n----------\n");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    I x = new Z();\n    x.foo();\n  }\n  static interface I {\n    Y foo();\n  }\n  static class Y {\n    public final Y foo() { \n        System.out.println(\"SUCCESS\");\n        return null; \n    }\n  }\n  static class Z extends Y implements I {\n      // empty\n  }\n}"}, "SUCCESS");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.java", "import java.awt.*;\npublic class X {\n    public void foo(Window w) {\n        // empty\n    }\n    public void foo(Applet a) {\n        // empty\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void foo(Applet a) {\n\t                ^^^^^^\nApplet cannot be resolved to a type\n----------\n");
    }

    public void test058() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n\nimport p.q.Z;\npublic class X { \n  public static void main(String argv[]) {\n     System.out.println(Z.z);\n  }\n}", "p/q/Z.java", "package p.q;\n\npublic class Z extends Y implements I { \n}\nclass Y {\n    protected static int z = 1;\n}\ninterface I {\n    int z = 0;\n}"}, "0");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid aa(int i) {\n\t}\n\tvoid aa(long l) {\n\t}\n\tZork bb() {\n\t}\n\tvoid cc() {\n\t\tthis.bb();\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tZork bb() {\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 10)\n\tthis.bb();\n\t     ^^\nThe method bb() is undefined for the type X\n----------\n");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid aa(int i) {\n\t}\n\tZork aa(long l) {\n\t}\n\tZork bb() {\n\t}\n\tvoid cc() {\n\t\tthis.bb();\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork aa(long l) {\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 7)\n\tZork bb() {\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 10)\n\tthis.bb();\n\t     ^^\nThe method bb() is undefined for the type X\n----------\n");
    }

    public void test061() {
        Map options = this.getCompilerOptions();
        if ("1.3".equals(options.get("org.eclipse.wst.jsdt.core.compiler.compliance"))) {
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
        }
        this.runConformTest(new String[]{"X.java", "interface MyInterface {\n        public void writeToStream();\n        public void readFromStream();\n}\n\npublic abstract class X implements MyInterface {\n        public void b() {\n        }\n        public void a() {\n                writeTypeToStream();\n        }\n        private void writeTypeToStream() {\n        }\n}\n"}, "", null, true, null, options, null);
    }

    public void test062() {
        Map options = this.getCompilerOptions();
        if ("1.3".equals(options.get("org.eclipse.wst.jsdt.core.compiler.compliance"))) {
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
        }
        this.runConformTest(new String[]{"X.java", "interface MyInterface {\n        public void writeToStream();\n        public void readFromStream();\n}\n\npublic abstract class X implements MyInterface {\n        public void b() {\n        }\n        public void a() {\n                writeTypeToStream();\n        }\n        private void writeTypeToStream() {\n        }\n}\n"}, "", null, true, null, options, null);
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.java", "class 56 {\n\n        private static class B {\n                public static final String F = \"\";\n        }\n\n        private static class C {\n        }\n\n        public void foo() {\n                System.out.println(B.F);\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass 56 {\n\t      ^^\nSyntax error on token \"56\", Identifier expected\n----------\n2. ERROR in X.java (at line 3)\n\tprivate static class B {\n\t                     ^\nIllegal modifier for the class B; only public, abstract & final are permitted\n----------\n3. ERROR in X.java (at line 7)\n\tprivate static class C {\n\t                     ^\nIllegal modifier for the class C; only public, abstract & final are permitted\n----------\n4. ERROR in X.java (at line 8)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n5. ERROR in X.java (at line 11)\n\tSystem.out.println(B.F);\n\t                   ^^^\nThe type B is not visible\n----------\n6. ERROR in X.java (at line 13)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n");
    }

    public void test064() {
        Map options = this.getCompilerOptions();
        if ("1.3".equals(options.get("org.eclipse.wst.jsdt.core.compiler.compliance"))) {
            options.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.1");
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\tB a = new C();\n\t\t\n\t\ta.hasKursAt(1);\n\t}\n\n}", "A.java", "abstract public class A implements IA0 {\n\tint t;\n\tpublic A() {\n\t}\n}", "B.java", "abstract public class B extends A implements IA3, IA1 {\n\tint a;\n\tpublic B() {\n\t}\n\tpublic void test() {\t\n\t}\n}", "C.java", "public class C extends B implements IA4, IA2{\n\tint c;\n\tpublic C() {\n\t}\n\tpublic boolean hasKursAt(int zeitpunkt) {\n\t\treturn false;\n\t}\n}", "IA0.java", "public interface IA0 {\n\tpublic void test();\n}", "IA1.java", "public interface IA1 extends IA0 {\n\tpublic boolean hasKursAt(int zeitpunkt);\n}", "IA2.java", "public interface IA2 extends IA0 {\n\tpublic boolean hasKursAt(int zeitpunkt);\n}", "IA3.java", "public interface IA3 extends IA2 {\n}", "IA4.java", "public interface IA4 extends IA3 {\n}"}, "SUCCESS", null, true, null, options, null);
    }

    public void test065() {
        this.runConformTest(new String[]{"com/internap/other/ScopeExample.java", "package com.internap.other;\nimport com.internap.*;\npublic class ScopeExample {\n\tprivate static final String LOGGER = \"SUCCESS\";\n\tpublic static void main(String[] args) {\n\t\tPublicAccessSubclass sub = new PublicAccessSubclass() {\n\t\t\tpublic void implementMe() {\n\t\t\t\tSystem.out.println(LOGGER);\n\t\t\t}\n\t\t};\n\t\tsub.implementMe();\n\t}\n}", "com/internap/PublicAccessSubclass.java", "package com.internap;\npublic abstract class PublicAccessSubclass extends DefaultAccessSuperclass {\n\tpublic abstract void implementMe();\t\t\t\t\n}", "com/internap/DefaultAccessSuperclass.java", "package com.internap;\nclass DefaultAccessSuperclass {\n\tprivate static final String LOGGER = \"FAILED\";\n}"}, "SUCCESS");
    }

    public void test066() {
        this.runConformTest(new String[]{"com/internap/other/ScopeExample.java", "package com.internap.other;\nimport com.internap.*;\npublic class ScopeExample {\n\tprivate static final String LOGGER() { return \"SUCCESS\"; }\n\tpublic static void main(String[] args) {\n\t\tPublicAccessSubclass sub = new PublicAccessSubclass() {\n\t\t\tpublic void implementMe() {\n\t\t\t\tSystem.out.println(LOGGER());\n\t\t\t}\n\t\t};\n\t\tsub.implementMe();\n\t}\n}", "com/internap/PublicAccessSubclass.java", "package com.internap;\npublic abstract class PublicAccessSubclass extends DefaultAccessSuperclass {\n\tpublic abstract void implementMe();\t\t\t\t\n}", "com/internap/DefaultAccessSuperclass.java", "package com.internap;\nclass DefaultAccessSuperclass {\n\tprivate static final String LOGGER() { return \"FAILED\"; }\n}"}, "SUCCESS");
    }

    public void test067() {
        Map options = this.getCompilerOptions();
        if ("1.3".equals(options.get("org.eclipse.wst.jsdt.core.compiler.compliance"))) {
            this.runNegativeTest(new String[]{"com/internap/other/ScopeExample.java", "package com.internap.other;\nimport com.internap.*;\npublic class ScopeExample {\n\tprivate static final String LOGGER = \"FAILED\";\n\tpublic static void main(String[] args) {\n\t\tPublicAccessSubclass sub = new PublicAccessSubclass() {\n\t\t\tpublic void implementMe() {\n\t\t\t\tSystem.out.println(LOGGER);\n\t\t\t}\n\t\t};\n\t\tsub.implementMe();\n\t}\n}", "com/internap/PublicAccessSubclass.java", "package com.internap;\npublic abstract class PublicAccessSubclass extends DefaultAccessSuperclass {\n\tpublic abstract void implementMe();\t\t\t\t\n}", "com/internap/DefaultAccessSuperclass.java", "package com.internap;\nclass DefaultAccessSuperclass {\n\tpublic static final String LOGGER = \"SUCCESS\";\n}"}, "----------\n1. WARNING in com\\internap\\other\\ScopeExample.java (at line 4)\r\n\tprivate static final String LOGGER = \"FAILED\";\r\n\t                            ^^^^^^\nThe field ScopeExample.LOGGER is never read locally\n----------\n2. ERROR in com\\internap\\other\\ScopeExample.java (at line 8)\r\n\tSystem.out.println(LOGGER);\r\n\t                   ^^^^^^\nThe field LOGGER is defined in an inherited type and an enclosing scope \n----------\n");
            return;
        }
        this.runConformTest(new String[]{"com/internap/other/ScopeExample.java", "package com.internap.other;\nimport com.internap.*;\npublic class ScopeExample {\n\tprivate static final String LOGGER = \"FAILED\";\n\tpublic static void main(String[] args) {\n\t\tPublicAccessSubclass sub = new PublicAccessSubclass() {\n\t\t\tpublic void implementMe() {\n\t\t\t\tSystem.out.println(LOGGER);\n\t\t\t}\n\t\t};\n\t\tsub.implementMe();\n\t}\n}", "com/internap/PublicAccessSubclass.java", "package com.internap;\npublic abstract class PublicAccessSubclass extends DefaultAccessSuperclass {\n\tpublic abstract void implementMe();\t\t\t\t\n}", "com/internap/DefaultAccessSuperclass.java", "package com.internap;\nclass DefaultAccessSuperclass {\n\tpublic static final String LOGGER = \"SUCCESS\";\n}"}, "SUCCESS");
    }

    public void test068() {
        Map options = this.getCompilerOptions();
        CompilerOptions compOptions = new CompilerOptions(options);
        if (compOptions.complianceLevel < 0x310000L) {
            return;
        }
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X() {\n    }\n    public static void main(String[] args) {\n        X l = new X();\n        StringBuffer sb = new StringBuffer();\n        sb.append(l);\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test068a() {
        Map options = this.getCompilerOptions();
        CompilerOptions compOptions = new CompilerOptions(options);
        if (compOptions.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X1.java", "public class X1 { X1 foo() { return null; } }\nclass X2 extends X1 { X2 foo() { return null; } }\nclass Y { public X2 foo() { return null; } }\ninterface I { X1 foo(); }\nclass Z extends Y implements I {}"}, "");
        this.runConformTest(new String[]{"Test.java", "public class Test {\n    public static void main(String[] args) {\n        X1 x = new X2().foo();\n        X2 xx = new X2().foo();\n        X1 z = new Z().foo();\n        X2 zz = new Z().foo();\n    }\n}"}, "", null, false, null);
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"Test14.java", "public class Test14 {\n    public static void main(String[] args) {\n        X1 x = new X2().foo();\n        X2 xx = new X2().foo();\n        X1 z = new Z().foo();\n        X2 zz = new Z().foo();\n    }\n}"}, "", null, false, null, options, null);
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X() {\n    }\n    public static void main(String[] args) {\n        X l = new X();\n        StringBuffer sb = new StringBuffer();\n        sb.append(l);\n    }\n}"}, "");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tinterface I {\n\t}\n\n\tvoid test() {\n\t\tnew I() {\n\t\t\tvoid foo() {\n\t\t\t}\n\t\t}.foo(); // compiles OK.\n\t\tnew I() {\n\t\t\tvoid $foo() {\n\t\t\t}\n\t\t}.$foo(); // The method $foo() is undefined for the type new T.I(){}\n\t}\n}"}, "");
    }

    public void test071() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n}", "p/X$X.java", "package p;\npublic class X$X {\n}"}, "");
        this.runConformTest(new String[]{"Y.java", "import p.*;\npublic class Y {\n  X$X f = new X$X();\n}"}, "", null, false, null, null, null, false);
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(AX ax) {\n\t\tax.foo(null);\n\t}\n\t\n}\ninterface IX {\n\tvoid foo(String s);\n}\ninterface JX {\n\tvoid foo(Thread t);\n}\nabstract class AX implements IX, JX {\n\tpublic void foo(String s) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tax.foo(null);\n\t   ^^^\nThe method foo(String) is ambiguous for the type AX\n----------\n");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"E.java", "public class E {\n\tvoid run(int i) {}\n\tstatic class Inner {\n\t\tvoid run() { run(1); }\n\t}\n}\n"}, "----------\n1. ERROR in E.java (at line 4)\n\tvoid run() { run(1); }\n\t             ^^^\nThe method run() in the type E.Inner is not applicable for the arguments (int)\n----------\n");
    }

    public void test074() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \nimport Test2;\t\nimport Test2.Member;\t\npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tSystem.out.println(\"SUCCESS\");\t\n\t} \n} \n", "Test2.java", "public class Test2 { \n\tpublic class Member {\t\n\t} \n} \n"};
        if (this.complianceLevel.equals("1.3")) {
            this.runConformTest(sources, "SUCCESS");
        } else {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 2)\n\timport Test2;\t\n\t       ^^^^^\nThe import Test2 cannot be resolved\n----------\n2. ERROR in p1\\Test.java (at line 3)\n\timport Test2.Member;\t\n\t       ^^^^^\nThe import Test2 cannot be resolved\n----------\n");
        }
    }

    public void test075() {
        this.runConformTest(new String[]{"package1/Test.java", "package package1;\nimport package2.MyList;\npublic class Test {\n        public void reproduce(String sortKey, boolean isAscending) {\n                MyList recList = new MyList();\n                recList.add(null);\n        }\n}\n", "package2/MyList.java", "package package2;\nimport java.util.AbstractList;\nimport java.util.List;\npublic class MyList extends AbstractList implements List {\n        void add(Integer i) {\n        }\n        public Object get(int index) {\n                return null;\n        }\n        public int size() {\n                return 0;\n        }\n}"}, "");
    }

    public void test076() {
        if (this.complianceLevel.compareTo("1.5") >= 0) {
            this.runNegativeTest(new String[]{"p/Y.java", "package p;\npublic class Y {\n  public static void foo(String s) {\n  }\n}\n", "q/X.java", "package q;\nimport static p.Y.foo;\npublic class X {\n        void foo() {\n        }\n        void bar() {\n          foo(\"\");\n        }\n}"}, "----------\n1. ERROR in q\\X.java (at line 7)\n\tfoo(\"\");\n\t^^^\nThe method foo() in the type X is not applicable for the arguments (String)\n----------\n");
        }
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "abstract  class B {\n  public String getValue(){\n    return \"pippo\";\n  }\n}\nclass D {\n  private String value;\n  public D(String p_Value){\n    value = p_Value;\n  }\n  private  String getValue(){\n    return \"pippoD\";\n  }\n}\npublic class X extends B {\n  class C extends D{\n    public C() {\n      super(getValue());\n      String s = getValue();\n    }\n  }\n}\n"}, "");
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "class D {\n  private String value;\n  public D(String p_Value){\n    value = p_Value;\n  }\n  private  String getValue(){\n    return \"pippoD\";\n  }\n}\npublic class X {\n  class C extends D{\n    public C() {\n      super(getValue());\n      String s = getValue();\n    }\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tprivate String value;\n\t               ^^^^^\nThe field D.value is never read locally\n----------\n2. ERROR in X.java (at line 13)\n\tsuper(getValue());\n\t      ^^^^^^^^\nThe method getValue() from the type D is not visible\n----------\n3. ERROR in X.java (at line 14)\n\tString s = getValue();\n\t           ^^^^^^^^\nThe method getValue() from the type D is not visible\n----------\n");
    }

    public void test079() {
        this.runConformTest(new String[]{"X.java", "abstract class Y {\n  private void foo(boolean b) {\n    System.out.println(\"Y\");\n    return;\n  }\n}\npublic class X {\n  private void foo(String s) {\n    System.out.println(\"X\");\n    return;\n  }\n  private class Z extends Y {\n    public void bar(boolean b) {\n      foo(\"Flag \" + b);\n      X.this.foo(\"Flag \" + b);\n    }\n  }\n  Z m = new Z();\n  public static void main(String args[]) {\n    new X().m.bar(true);\n  }\n}"}, "X\nX");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "abstract class Y {\n  private void foo(String s) {\n    System.out.println(\"Y\");\n    return;\n  }\n}\npublic class X {\n  private void foo(String s) {\n    System.out.println(\"X\");\n    return;\n  }\n  private class Z extends Y {\n    public void bar(boolean b) {\n      foo(\"Flag \" + b);\n      X.this.foo(\"Flag \" + b);\n    }\n  }\n  Z m = new Z();\n  public static void main(String args[]) {\n    new X().m.bar(true);\n  }\n}"}, "X\nX");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.LookupTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

