/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter.comment;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.core.tests.formatter.comment.CommentTestCase;

public class MultiLineTestCase
extends CommentTestCase {
    protected static final String INFIX = " * ";
    protected static final String POSTFIX = " */";
    protected static final String PREFIX = "/* ";
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.formatter.comment.MultiLineTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return MultiLineTestCase.buildTestSuite(clazz);
    }

    public MultiLineTestCase(String name) {
        super(name);
    }

    protected int getCommentKind() {
        return 32;
    }

    public void testSingleLineComment1() {
        MultiLineTestCase.assertEquals((String)("/*" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/*\t\t" + DELIMITER + "*\t test*/"));
    }

    public void testSingleLineComment2() {
        MultiLineTestCase.assertEquals((String)("/*" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/* test" + DELIMITER + "\t" + POSTFIX));
    }

    public void testSingleLineComment3() {
        MultiLineTestCase.assertEquals((String)("/*" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat(PREFIX + DELIMITER + "* test\t*/"));
    }

    public void testSingleLineComment4() {
        MultiLineTestCase.assertEquals((String)("/*" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX), (String)this.testFormat("/*test" + DELIMITER + POSTFIX));
    }

    public void testSingleLineCommentSpace1() {
        MultiLineTestCase.assertEquals((String)"/* test */", (String)this.testFormat("/*test*/"));
    }

    public void testSingleLineCommentSpace2() {
        MultiLineTestCase.assertEquals((String)"/* test */", (String)this.testFormat("/*test */"));
    }

    public void testSingleLineCommentSpace3() {
        MultiLineTestCase.assertEquals((String)"/* test */", (String)this.testFormat("/* test*/"));
    }

    public void testSingleLineCommentSpace4() {
        MultiLineTestCase.assertEquals((String)"/* test test */", (String)this.testFormat("/* test   test*/"));
    }

    public void testSingleLineCommentTabs1() {
        MultiLineTestCase.assertEquals((String)"/* test test */", (String)this.testFormat("/*\ttest\ttest */"));
    }

    public void testSingleLineCommentTabs2() {
        MultiLineTestCase.assertEquals((String)"/* test test */", (String)this.testFormat("/*\ttest\ttest*/"));
    }

    public void testMultiLineCommentAsterisk1() {
        String input = "/*  * test1" + DELIMITER + "test2" + INFIX + DELIMITER + "test3" + DELIMITER + "test4" + POSTFIX;
        String result = this.testFormat(input);
        MultiLineTestCase.assertTrue((result.indexOf("test1") != -1 ? 1 : 0) != 0);
        MultiLineTestCase.assertTrue((result.indexOf("test2") != -1 ? 1 : 0) != 0);
        MultiLineTestCase.assertTrue((result.indexOf("test3") != -1 ? 1 : 0) != 0);
        MultiLineTestCase.assertTrue((result.indexOf("test4") != -1 ? 1 : 0) != 0);
    }

    public void testNoChange1() {
        String content = PREFIX + DELIMITER + POSTFIX;
        MultiLineTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testNoFormat1() {
        this.setUserOption("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
        String content = PREFIX + DELIMITER + INFIX + "test" + DELIMITER + INFIX + "test" + DELIMITER + POSTFIX;
        MultiLineTestCase.assertEquals((String)content, (String)this.testFormat(content));
    }

    public void testMultiLineCommentFor145544() {
        this.setUserOption(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        String input = "/**\n * Member comment\n */";
        String result = this.testFormat(input, 0, input.length(), 32, 2);
        String expectedOutput = "/***********************************************************************\n\t * Member comment\n\t */";
        MultiLineTestCase.assertEquals((String)"Different output", (String)expectedOutput, (String)result);
    }

    public void test75460() {
        String input;
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "200");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_source_code", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "false");
        String expected = input = "/*" + DELIMITER + "            var objects = new Array(3);" + DELIMITER + "            objects[0] = new String(\"Hallo Welt !!!\");" + DELIMITER + "            objects[1] = new String(\"Test !!!\");" + DELIMITER + "            objects[2] = new Number(\"1980\");" + DELIMITER + "            var objs = ObjectFile.read(pathname);" + DELIMITER + "            for(int i = 0; i < objs.length; i++)" + DELIMITER + "            {" + DELIMITER + "              alert(objs[i].toString());" + DELIMITER + "            }" + DELIMITER + "*/";
        String result = this.testFormat(input, options);
        MultiLineTestCase.assertEquals((String)expected, (String)result);
    }

    public void test49412() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "200");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "true");
        String input = "/*" + DELIMITER + DELIMITER + " test block comment with a blank line" + DELIMITER + "*/";
        String expected = "/*" + DELIMITER + " * test block comment with a blank line" + DELIMITER + POSTFIX;
        String result = this.testFormat(input, options);
        MultiLineTestCase.assertEquals((String)expected, (String)result);
    }

    public void test49412_2() {
        String input;
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "200");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "true");
        String expected = input = "/*" + DELIMITER + DELIMITER + " test block comment with a blank line" + DELIMITER + "*/";
        String result = this.testFormat(input, options);
        MultiLineTestCase.assertEquals((String)expected, (String)result);
    }

    public void test49412_3() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.line_length", "200");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.comment.clear_blank_lines_in_block_comment", "false");
        String input = "/*" + DELIMITER + DELIMITER + " test block comment with a blank line" + DELIMITER + "*/";
        String expected = "/*" + DELIMITER + INFIX + DELIMITER + " * test block comment with a blank line" + DELIMITER + POSTFIX;
        String result = this.testFormat(input, options);
        MultiLineTestCase.assertEquals((String)expected, (String)result);
    }
}

