/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.eclipse.wst.jsdt.internal.core.UserLibraryManager;

public class JavaProjectTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public JavaProjectTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaProjectTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((suite = (TestSuite)JavaProjectTests.buildModelTestSuite(clazz)).testCount() > 1) {
            suite.addTest((Test)new JavaProjectTests("lastlyTestDeletePackageWithAutobuild"));
        }
        return suite;
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("JavaProjectTests");
        this.setUpJavaProject("JavaProjectSrcTests");
        this.setUpJavaProject("JavaProjectLibTests");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("JavaProjectTests");
        this.deleteProject("JavaProjectSrcTests");
        this.deleteProject("JavaProjectLibTests");
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddNonJavaResourcePackageFragmentRoot() throws JavaScriptModelException, CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("JavaProjectTests", "");
        Object[] resources = root.getNonJavaScriptResources();
        this.assertResourceNamesEqual("unexpected non Java resources", ".project\n.settings\nlib142530.jar\nlib148949.jar", resources);
        IFile resource = (IFile)resources[0];
        IPath newPath = root.getUnderlyingResource().getFullPath().append("TestNonJavaResource.abc");
        try {
            resource.copy(newPath, true, null);
            resources = root.getNonJavaScriptResources();
            this.assertResourcesEqual("incorrect non java resources", "/JavaProjectTests/.project\n/JavaProjectTests/.settings\n/JavaProjectTests/TestNonJavaResource.abc\n/JavaProjectTests/lib142530.jar\n/JavaProjectTests/lib148949.jar", resources);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteResource((IResource)resource.getWorkspace().getRoot().getFile(newPath));
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteResource((IResource)resource.getWorkspace().getRoot().getFile(newPath));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddProjectPrerequisite() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createJavaProject("P2");
            JavaProjectTests.waitForAutoBuild();
            this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"/P1\"/>\n</classpath>");
            this.getProject("P2").build(6, null);
            Object[] referencedProjects = this.getProject("P2").getReferencedProjects();
            this.assertResourcesEqual("Unexpected project references", "/P1", referencedProjects);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testCompilationUnitCorrespondingResource() throws JavaScriptModelException {
        IJavaScriptUnit element = this.getCompilationUnit("JavaProjectTests", "", "q", "A.js");
        IResource corr = element.getCorrespondingResource();
        IFile res = this.getWorkspace().getRoot().getProject("JavaProjectTests").getFolder("q").getFile("A.js");
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (boolean)corr.equals((Object)res));
        JavaProjectTests.assertEquals((String)"Project is incorrect for the compilation unit", (String)"JavaProjectTests", (String)corr.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lastlyTestDeletePackageWithAutobuild() throws CoreException {
        projects = this.getWorkspaceRoot().getProjects();
        i = 0;
        while (true) {
            if (i >= projects.length) {
                workspace = this.getWorkspace();
                autoBuild = workspace.isAutoBuilding();
                description = workspace.getDescription();
                description.setAutoBuilding(true);
                workspace.setDescription(description);
                this.startDeltas();
                frag = this.getPackageFragment("JavaProjectTests", "", "x.y");
                folder = (IFolder)frag.getUnderlyingResource();
                ** try [egrp 0[TRYBLOCK] [0 : 117->136)] { 
lbl14:
                // 1 sources

                break;
            }
            project = projects[i];
            if (!project.getName().equals("JavaProjectTests")) {
                project.close(null);
            }
            ++i;
        }
        {
            this.deleteResource((IResource)folder);
            this.assertDeltas("Unexpected delta", "JavaProjectTests[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\tx.y[-]: {}");
            ** GOTO lbl-1000
        }
lbl23:
        // 1 sources

        catch (Throwable var8_9) {
            var7_10 = null;
            this.stopDeltas();
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            projects = this.getWorkspaceRoot().getProjects();
            i = 0;
        }
        while (true) {
            if (i >= projects.length) {
                throw var8_9;
            }
            project = projects[i];
            if (!project.getName().equals("JavaProjectTests")) {
                project.open(null);
            }
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            var7_11 = null;
        }
        this.stopDeltas();
        description.setAutoBuilding(autoBuild);
        workspace.setDescription(description);
        projects = this.getWorkspaceRoot().getProjects();
        i = 0;
        while (true) {
            if (i >= projects.length) {
                return;
            }
            project = projects[i];
            if (!project.getName().equals("JavaProjectTests")) {
                project.open(null);
            }
            ++i;
        }
    }

    public void testExternalArchiveCorrespondingResource() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IPackageFragmentRoot element = project.getPackageFragmentRoot(this.getSystemJsPathString());
        IResource corr = element.getCorrespondingResource();
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (corr == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testExtraJavaLikeExtension1() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/pack");
            this.createFile("/P/pack/X.js", "function X() {}");
            this.createFile("/P/pack/Y.bar", "function Y() {}");
            IPackageFragment pkg = this.getPackage("/P/pack");
            this.assertSortedElementsEqual("Unexpected children of package pack", "X.js [in pack [in <project root> [in P]]]", pkg.getChildren());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testExtraJavaLikeExtension2() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/pack");
            this.createFile("/P/pack/X.txt", "");
            this.createFile("/P/pack/Y.bar", "function Y() {}");
            IPackageFragment pkg = this.getPackage("/P/pack");
            this.assertResourceNamesEqual("Unexpected non-Java resources of package pack", "X.txt\nY.bar", pkg.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    public void testFindElementCompilationUnit() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IJavaScriptElement element = project.findElement((IPath)new Path("x/y/Main.js"));
        JavaProjectTests.assertTrue((String)"CU not found", (element != null && element.getElementType() == 5 && element.getElementName().equals("Main.js") ? 1 : 0) != 0);
    }

    public void testFindElementCompilationUnitDefaultPackage() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IJavaScriptElement element = project.findElement((IPath)new Path("B.js"));
        JavaProjectTests.assertTrue((String)"CU not found", (element != null && element.getElementType() == 5 && element.getElementName().equals("B.js") ? 1 : 0) != 0);
    }

    public void testFindElementInvalidPath() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        boolean failed = false;
        try {
            project.findElement(null);
        }
        catch (JavaScriptModelException e) {
            failed = true;
            JavaProjectTests.assertTrue((String)"wrong status code", (e.getStatus().getCode() == 979 ? 1 : 0) != 0);
        }
        JavaProjectTests.assertTrue((String)"Shold have failed", (boolean)failed);
        failed = false;
        try {
            project.findElement((IPath)new Path("/something/absolute"));
        }
        catch (JavaScriptModelException e) {
            failed = true;
            JavaProjectTests.assertTrue((String)"wrong status code", (e.getStatus().getCode() == 979 ? 1 : 0) != 0);
        }
        JavaProjectTests.assertTrue((String)"Shold have failed", (boolean)failed);
        IJavaScriptElement element = project.findElement((IPath)new Path("does/not/exist/HelloWorld.js"));
        JavaProjectTests.assertTrue((String)"should get no element", (element == null ? 1 : 0) != 0);
    }

    public void testFindElementPackage() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IJavaScriptElement element = project.findElement((IPath)new Path("x/y"));
        JavaProjectTests.assertTrue((String)"package not found", (element != null && element.getElementType() == 4 && element.getElementName().equals("x.y") ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindElementPrereqSimpleProject() throws CoreException {
        try {
            this.createProject("R");
            IJavaScriptProject project = this.createJavaProject("J", new String[]{"src"}, new String[0], new String[]{"/R"});
            this.createFile("J/src/X.js", "public class X {\n}");
            JavaProjectTests.assertTrue((String)"X.java not found", (project.findElement((IPath)new Path("X.js")) != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("R");
            this.deleteProject("J");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("R");
        this.deleteProject("J");
    }

    public void testFindPackageFragmentRootFromClasspathEntry() {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IIncludePathEntry entry = JavaScriptCore.newLibraryEntry((IPath)new Path("/JavaProjectTests/lib.jar"), null, null);
        IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entry);
        JavaProjectTests.assertEquals((String)"Unexpected number of roots for existing entry", (int)1, (int)roots.length);
        JavaProjectTests.assertEquals((String)"Unexpected root", (String)"/JavaProjectTests/lib.jar", (String)roots[0].getPath().toString());
        entry = JavaScriptCore.newSourceEntry((IPath)new Path("/JavaProjectTests/nonExisting"));
        roots = project.findPackageFragmentRoots(entry);
        JavaProjectTests.assertEquals((String)"Unexpected number of roots for non existing entry", (int)0, (int)roots.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderWithDotName() throws JavaScriptModelException, CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("JavaProjectTests", "");
        IContainer folder = (IContainer)root.getCorrespondingResource();
        try {
            this.startDeltas();
            folder.getFolder((IPath)new Path("org.eclipse")).create(false, true, null);
            JavaProjectTests.assertTrue((String)"should be one Java Delta", (this.deltaListener.deltas.length == 1 ? 1 : 0) != 0);
            this.stopDeltas();
            IJavaScriptElement[] children = root.getChildren();
            IPackageFragment bogus = root.getPackageFragment("org.eclipse");
            int i = 0;
            while (true) {
                block4: {
                    if (i < children.length) break block4;
                }
                JavaProjectTests.assertTrue((String)"org.eclipse should not be present as child", (!children[i].equals(bogus) ? 1 : 0) != 0);
                ++i;
            }
            JavaProjectTests.assertTrue((String)"org.eclipse should not exist", (!bogus.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteResource((IResource)folder.getFolder((IPath)new Path("org.eclipse")));
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteResource((IResource)folder.getFolder((IPath)new Path("org.eclipse")));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetClasspathOnClosedProject() throws CoreException {
        IProject project = this.getProject("JavaProjectTests");
        try {
            boolean gotException;
            block8: {
                IJavaScriptProject javaProject;
                block7: {
                    project.close(null);
                    gotException = false;
                    javaProject = JavaScriptCore.create((IProject)project);
                    try {
                        javaProject.getRawIncludepath();
                    }
                    catch (JavaScriptModelException e) {
                        if (!e.isDoesNotExist()) break block7;
                        gotException = true;
                    }
                }
                JavaProjectTests.assertTrue((String)"Should get a not present exception for getRawClasspath()", (boolean)gotException);
                gotException = false;
                try {
                    javaProject.getResolvedIncludepath(true);
                }
                catch (JavaScriptModelException e) {
                    if (!e.isDoesNotExist()) break block8;
                    gotException = true;
                }
            }
            JavaProjectTests.assertTrue((String)"Should get a not present exception for getResolvedClasspath(true)", (boolean)gotException);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            project.open(null);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        project.open(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetNonJavaResources1() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"});
            this.assertResourcesEqual("Unexpected non-java resources for project", "/P/.project\n/P/.settings", project.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetNonJavaResources2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{"src"}, "bin1", new String[]{"bin2"});
            this.assertResourcesEqual("Unexpected non-java resources for project", "/P/.project\n/P/.settings", project.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetNonJavaResources3() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[]{""});
            this.createFolder("/P/p1");
            this.assertResourcesEqual("Unexpected non-java resources for project", "/P/.project\n/P/.settings", project.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetNonJavaResources4() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P");
            this.createFolder("/P/x.y");
            this.assertResourcesEqual("Unexpected non-java resources for project", "/P/.project\n/P/.settings\n/P/x.y", project.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGetRequiredProjectNames() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P", new String[0], new String[0], new String[]{"/JavaProjectTests", "/P1", "/P0", "/P2", "/JavaProjectSrcTests"});
            String[] requiredProjectNames = project.getRequiredProjectNames();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            int length = requiredProjectNames.length;
            while (true) {
                block5: {
                    if (i < length) break block5;
                    JavaProjectTests.assertEquals((String)"Unexpected required project names", (String)"JavaProjectTests, P1, P0, P2, JavaProjectSrcTests", (String)buffer.toString());
                    break;
                }
                buffer.append(requiredProjectNames[i]);
                if (i != length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P");
    }

    public void testInternalArchiveCorrespondingResource() throws JavaScriptModelException {
        IPackageFragmentRoot element = this.getPackageFragmentRoot("JavaProjectTests", "lib.jar");
        IResource corr = element.getCorrespondingResource();
        IFile res = this.getWorkspace().getRoot().getProject("JavaProjectTests").getFile("lib.jar");
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (boolean)corr.equals((Object)res));
    }

    public void testIsDefaultPackage() throws JavaScriptModelException {
        IPackageFragment def = this.getPackageFragment("JavaProjectTests", "", "");
        JavaProjectTests.assertTrue((String)"should be default package", (boolean)def.isDefaultPackage());
        IPackageFragment y = this.getPackageFragment("JavaProjectTests", "", "x.y");
        JavaProjectTests.assertTrue((String)"x.y should not be default pakackage", (!y.isDefaultPackage() ? 1 : 0) != 0);
        IPackageFragment def2 = this.getPackageFragment("JavaProjectTests", "lib.jar", "");
        JavaProjectTests.assertTrue((String)"lib.jar should have default package", (boolean)def2.isDefaultPackage());
        IPackageFragment p = this.getPackageFragment("JavaProjectTests", "lib.jar", "p");
        JavaProjectTests.assertTrue((String)"p should not be default package", (!p.isDefaultPackage() ? 1 : 0) != 0);
    }

    public void testPackageFragmentCorrespondingResource() throws JavaScriptModelException {
        IPackageFragment element = this.getPackageFragment("JavaProjectTests", "", "x.y");
        IResource corr = element.getCorrespondingResource();
        IFolder res = this.getWorkspace().getRoot().getProject("JavaProjectTests").getFolder("x").getFolder("y");
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (boolean)corr.equals((Object)res));
    }

    public void testPackageFragmentHasSubpackages() throws JavaScriptModelException {
        IPackageFragment def = this.getPackageFragment("JavaProjectTests", "", "");
        IPackageFragment x = this.getPackageFragment("JavaProjectTests", "", "x");
        IPackageFragment y = this.getPackageFragment("JavaProjectTests", "", "x.y");
        JavaProjectTests.assertTrue((String)"default should have subpackages", (boolean)def.hasSubpackages());
        JavaProjectTests.assertTrue((String)"x should have subpackages", (boolean)x.hasSubpackages());
        JavaProjectTests.assertTrue((String)"x.y should NOT have subpackages", (!y.hasSubpackages() ? 1 : 0) != 0);
        IPackageFragment java = this.getPackageFragment("JavaProjectTests", this.getSystemJsPathString(), "java");
        IPackageFragment lang = this.getPackageFragment("JavaProjectTests", this.getSystemJsPathString(), "java.lang");
        JavaProjectTests.assertTrue((String)"java should have subpackages", (boolean)java.hasSubpackages());
        JavaProjectTests.assertTrue((String)"java.lang  should NOT have subpackages", (!lang.hasSubpackages() ? 1 : 0) != 0);
    }

    public void testPackageFragmentIsStructureKnown1() throws CoreException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "", "x");
        JavaProjectTests.assertTrue((String)"Structure of package 'x' should be known", (boolean)pkg.isStructureKnown());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentIsStructureKnown2() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/pack");
            IPackageFragment pkg = this.getPackage("/P/pack");
            this.editFile("/P/.classpath", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n\t<classpathentry excluding=\"pack/\" kind=\"src\" path=\"\"/>\n\t<classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
            JavaScriptModelException exception = null;
            try {
                pkg.isStructureKnown();
            }
            catch (JavaScriptModelException e) {
                exception = e;
            }
            this.assertExceptionEquals("Unexpected exception", "pack [in <project root> [in P]] does not exist", exception);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P");
    }

    public void testPackageFragmentNonJavaResources1() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "", "x");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "/JavaProjectTests/x/readme.txt\n/JavaProjectTests/x/readme2.txt", resources);
    }

    public void testPackageFragmentNonJavaResources2() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "", "x.y");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "", resources);
    }

    public void testPackageFragmentNonJavaResources3() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "", "");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "", resources);
    }

    public void testPackageFragmentNonJavaResources4() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "lib.jar", "p");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "", resources);
    }

    public void testPackageFragmentNonJavaResources5() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "lib.jar", "");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "", resources);
    }

    public void testPackageFragmentNonJavaResources6() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "lib142530.jar", "p");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourcesEqual("Unexpected resources", "x.y/Test.txt", resources);
    }

    public void testPackageFragmentNonJavaResources7() throws JavaScriptModelException {
        IPackageFragment pkg = this.getPackageFragment("JavaProjectTests", "lib148949.jar", "p");
        Object[] resources = pkg.getNonJavaScriptResources();
        this.assertResourceNamesEqual("Unexpected resources", "test.txt", resources);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentPackageInfoClass() throws CoreException {
        try {
            this.createJavaProject("P");
            this.createFolder("/P/p1");
            IPackageFragment pkg = this.getPackage("/P/p1");
            pkg.open(null);
            this.createFile("/P/p1/package-info.class", "");
            this.assertResourceNamesEqual("Unexpected resources of /P/p1", "", pkg.getNonJavaScriptResources());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }

    public void testPackageFragmentRenameAndCreate() throws JavaScriptModelException, CoreException {
        IPackageFragment y = this.getPackageFragment("JavaProjectTests", "", "x.y");
        IFolder yFolder = (IFolder)y.getUnderlyingResource();
        IPath yPath = yFolder.getFullPath();
        IPath fooPath = yPath.removeLastSegments(1).append("foo");
        yFolder.move(fooPath, true, null);
        try {
            yFolder.create(true, true, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            JavaProjectTests.assertTrue((String)"should be able to recreate the y folder", (boolean)false);
        }
        this.deleteResource((IResource)yFolder);
        IPackageFragment foo = this.getPackageFragment("JavaProjectTests", "", "x.foo");
        IFolder fooFolder = (IFolder)foo.getUnderlyingResource();
        fooFolder.move(yPath, true, null);
    }

    public void testPackageFragmentRootCorrespondingResource() throws JavaScriptModelException {
        IPackageFragmentRoot element = this.getPackageFragmentRoot("JavaProjectTests", "");
        IResource corr = element.getCorrespondingResource();
        IProject res = this.getWorkspace().getRoot().getProject("JavaProjectTests");
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (boolean)corr.equals((Object)res));
        JavaProjectTests.assertEquals((String)"Project incorrect for folder resource", (String)"JavaProjectTests", (String)corr.getProject().getName());
    }

    public void testPackageFragmentRootNonJavaResources() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("JavaProjectTests", "");
        Object[] resources = root.getNonJavaScriptResources();
        this.assertResourceNamesEqual("unexpected non java resoures (test case 1)", ".project\n.settings\nlib142530.jar\nlib148949.jar", resources);
        root = this.getPackageFragmentRoot("JavaProjectSrcTests", "src");
        resources = root.getNonJavaScriptResources();
        this.assertResourceNamesEqual("unexpected non java resoures (test case 2)", "", resources);
        root = this.getPackageFragmentRoot("JavaProjectTests", "lib.jar");
        resources = root.getNonJavaScriptResources();
        this.assertResourceNamesEqual("unexpected non java resoures (test case 4)", "MANIFEST.MF", resources);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentRootRawEntry() throws CoreException, IOException {
        block7: {
            File libDir = null;
            try {
                int i;
                IPackageFragmentRoot[] roots;
                String libPath = String.valueOf(this.getExternalPath()) + "lib";
                JavaScriptCore.setIncludepathVariable((String)"MyVar", (IPath)new Path(libPath), null);
                IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
                libDir = new File(libPath);
                libDir.mkdirs();
                IIncludePathEntry[] classpath = new IIncludePathEntry[200];
                int i2 = 0;
                while (true) {
                    if (i2 >= 200) {
                        proj.setRawIncludepath(classpath, null);
                        roots = proj.getPackageFragmentRoots();
                        JavaProjectTests.assertEquals((String)"wrong number of entries:", (int)200, (int)roots.length);
                        i = 0;
                        break;
                    }
                    File libJar = new File(libDir, "lib" + i2 + ".jar");
                    libJar.createNewFile();
                    classpath[i2] = JavaScriptCore.newVariableEntry((IPath)new Path("/MyVar/lib" + i2 + ".jar"), null, null);
                    ++i2;
                }
                while (i < roots.length) {
                    IIncludePathEntry rawEntry = roots[i].getRawIncludepathEntry();
                    JavaProjectTests.assertEquals((String)"unexpected root raw entry:", (Object)classpath[i], (Object)rawEntry);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (libDir != null) {
                    Util.delete(libDir);
                }
                this.deleteProject("P");
                JavaScriptCore.removeIncludepathVariable((String)"MyVar", null);
                throw throwable;
            }
            {
                Object var8_12 = null;
                if (libDir == null) break block7;
            }
            Util.delete((File)libDir);
        }
        this.deleteProject("P");
        JavaScriptCore.removeIncludepathVariable((String)"MyVar", null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentRootRawEntryWhenDuplicate() throws CoreException, IOException {
        block4: {
            File libDir = null;
            try {
                String externalPath = this.getExternalPath();
                String libPath = String.valueOf(externalPath) + "lib";
                JavaScriptCore.setIncludepathVariable((String)"MyVar", (IPath)new Path(externalPath), null);
                IJavaScriptProject proj = this.createJavaProject("P", new String[0]);
                libDir = new File(libPath);
                libDir.mkdirs();
                IIncludePathEntry[] classpath = new IIncludePathEntry[2];
                File libJar = new File(libDir, "lib.jar");
                libJar.createNewFile();
                classpath[0] = JavaScriptCore.newLibraryEntry((IPath)new Path(libPath).append("lib.jar"), null, null);
                classpath[1] = JavaScriptCore.newVariableEntry((IPath)new Path("/MyVar").append("lib.jar"), null, null);
                proj.setRawIncludepath(classpath, null);
                JavaScriptCore.setIncludepathVariable((String)"MyVar", (IPath)new Path(libPath), null);
                IPackageFragmentRoot[] roots = proj.getPackageFragmentRoots();
                JavaProjectTests.assertEquals((String)"wrong number of entries:", (int)1, (int)roots.length);
                IIncludePathEntry rawEntry = roots[0].getRawIncludepathEntry();
                JavaProjectTests.assertEquals((String)"unexpected root raw entry:", (Object)classpath[0], (Object)rawEntry);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (libDir != null) {
                    Util.delete(libDir);
                }
                this.deleteProject("P");
                JavaScriptCore.removeIncludepathVariable((String)"MyVar", null);
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (libDir == null) break block4;
            }
            Util.delete((File)libDir);
        }
        this.deleteProject("P");
        JavaScriptCore.removeIncludepathVariable((String)"MyVar", null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectOpen() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createJavaProject("P2", new String[0], new String[0], new String[]{"/P1"});
            IProject p2 = this.getProject("P2");
            p2.close(null);
            p2.open(null);
            Object[] references = p2.getDescription().getDynamicReferences();
            this.assertResourcesEqual("Unexpected referenced projects", "/P1", references);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectClose() throws JavaScriptModelException, CoreException {
        jproject = this.getJavaProject("JavaProjectTests");
        originalRoots = jproject.getPackageFragmentRoots();
        project = jproject.getProject();
        try {
            this.startDeltas();
            project.close(null);
            this.assertDeltas("Unexpected delta 1", "JavaProjectTests[*]: {CLOSED}\nResourceDelta(/JavaProjectTests)");
            ** GOTO lbl-1000
        }
        catch (Throwable var5_4) {
            var4_5 = null;
            try {
                this.clearDeltas();
                project.open(null);
                this.assertDeltas("Unexpected delta 2", "JavaProjectTests[*]: {OPENED}\nResourceDelta(/JavaProjectTests)");
                openRoots = jproject.getPackageFragmentRoots();
                JavaProjectTests.assertTrue((String)"should have same number of roots", (boolean)(openRoots.length == originalRoots.length));
                i = 0;
                while (i < openRoots.length) {
                    JavaProjectTests.assertTrue((String)"root not the same", (boolean)openRoots[i].equals(originalRoots[i]));
                    ++i;
                }
            }
            catch (Throwable var9_11) {
                v0 = null;
lbl26:
                // 2 sources

                while (true) {
                    var8_13 = v0;
                    this.stopDeltas();
                    throw var5_4;
                }
            }
        }
        {
            block11: {
                v0 = null;
                ** continue;
lbl-1000:
                // 1 sources

                {
                    var4_6 = null;
                }
                ** try [egrp 1[TRYBLOCK] [2 : 55->141)] { 
lbl34:
                // 1 sources

                this.clearDeltas();
                project.open(null);
                this.assertDeltas("Unexpected delta 2", "JavaProjectTests[*]: {OPENED}\nResourceDelta(/JavaProjectTests)");
                openRoots = jproject.getPackageFragmentRoots();
                JavaProjectTests.assertTrue((String)"should have same number of roots", (boolean)(openRoots.length == originalRoots.length));
                i = 0;
                while (i < openRoots.length) {
                    JavaProjectTests.assertTrue((String)"root not the same", (boolean)openRoots[i].equals(originalRoots[i]));
                    ++i;
                }
                break block11;
lbl45:
                // 1 sources

                catch (Throwable var9_12) {
                    v1 = null;
lbl47:
                    // 2 sources

                    while (true) {
                        var8_14 = v1;
                        this.stopDeltas();
                        return;
                    }
                }
            }
            v1 = null;
            ** continue;
        }
    }

    public void testProjectCorrespondingResource() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IResource corr = project.getCorrespondingResource();
        IProject res = this.getWorkspace().getRoot().getProject("JavaProjectTests");
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (boolean)corr.equals((Object)res));
    }

    public void testProjectGetChildren() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IJavaScriptElement[] roots = project.getChildren();
        this.assertElementsEqual("Unexpected package fragment roots", "<project root> [in JavaProjectTests]\n" + this.getSystemJsPathString() + "\n" + "lib.jar [in JavaProjectTests]\n" + "lib142530.jar [in JavaProjectTests]\n" + "lib148949.jar [in JavaProjectTests]", roots);
    }

    public void testProjectGetPackageFragments() throws JavaScriptModelException {
        IJavaScriptProject project = this.getJavaProject("JavaProjectTests");
        IPackageFragment[] fragments = project.getPackageFragments();
        this.assertSortedElementsEqual("unexpected package fragments", "<default> [in " + this.getSystemJsPathString() + "]\n" + "q [in <project root> [in JavaProjectTests]]\n" + "x [in <project root> [in JavaProjectTests]]\n" + "x/y [in <project root> [in JavaProjectTests]]", (IJavaScriptElement[])fragments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testProjectImport() throws CoreException {
        try {
            this.createJavaProject("P1");
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    JavaProjectTests.this.createJavaProject("P2");
                    JavaProjectTests.this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"/P1\"/>\n    <classpathentry kind=\"output\" path=\"\"/>\n</classpath>");
                }
            };
            this.getWorkspace().run(runnable, null);
            JavaProjectTests.waitForAutoBuild();
            Object[] referencedProjects = this.getProject("P2").getReferencedProjects();
            this.assertResourcesEqual("Unexpected project references", "/P1", referencedProjects);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProjects(new String[]{"P1", "P2"});
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    public void testRootGetPackageFragments() throws JavaScriptModelException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("JavaProjectTests", "");
        IJavaScriptElement[] fragments = root.getChildren();
        this.assertElementsEqual("unexpected package fragments in source folder", "<default> [in <project root> [in JavaProjectTests]]\nq [in <project root> [in JavaProjectTests]]\nx [in <project root> [in JavaProjectTests]]\nx/y [in <project root> [in JavaProjectTests]]", fragments);
        root = this.getPackageFragmentRoot("JavaProjectTests", "lib.jar");
        fragments = root.getChildren();
        this.assertSortedElementsEqual("unexpected package fragments in library", "<default> [in lib.jar [in JavaProjectTests]]\np [in lib.jar [in JavaProjectTests]]", fragments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRootGetPackageFragments3() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1");
            this.createFile("/P1/X.js", "function X() {\n}");
            this.getProject("P1").build(6, null);
            IJavaScriptProject p2 = this.createJavaProject("P2");
            this.editFile("/P2/.settings/.jsdtscope", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<classpath>\n    <classpathentry kind=\"src\" path=\"\"/>\n    <classpathentry kind=\"lib\" path=\"/P1\"/>\n</classpath>");
            IPackageFragment pkg = p1.getPackageFragmentRoot((IResource)p1.getProject()).getPackageFragment("");
            this.assertElementsEqual("Unexpected packages for P1", "X.js [in <default> [in <project root> [in P1]]]", pkg.getChildren());
            pkg = p2.getPackageFragmentRoot((IResource)p1.getProject()).getPackageFragment("");
            this.assertElementsEqual("Unexpected packages for P2", "X.js [in <default> [in /P1 [in P2]]]", pkg.getChildren());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSourceFolderWithJarName() throws CoreException {
        try {
            try {
                this.createJavaProject("P", new String[]{"src.jar"});
                IFile file = this.createFile("/P/src.jar/X.js", "class X {}");
                IJavaScriptUnit unit = (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
                unit.getAllTypes();
            }
            catch (CoreException coreException) {
                JavaProjectTests.assertTrue((String)"unable to open unit in 'src.jar' source folder", (boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    public void testSourceMethodCorrespondingResource() throws JavaScriptModelException {
        IJavaScriptUnit element = this.getCompilationUnit("JavaProjectTests", "", "q", "A.js");
        IFunction[] methods = element.getFunctions();
        JavaProjectTests.assertTrue((String)"missing methods", (methods.length > 0 ? 1 : 0) != 0);
        IResource corr = methods[0].getCorrespondingResource();
        JavaProjectTests.assertTrue((String)"incorrect corresponding resource", (corr == null ? 1 : 0) != 0);
    }

    public void testUserLibrary() throws JavaScriptModelException {
        IIncludePathEntry[] userEntries = new IIncludePathEntry[2];
        Path path = new Path("/tmp/test.jar");
        IAccessRule[] pathRules = new IAccessRule[]{JavaScriptCore.newAccessRule((IPath)new Path("**/forbidden/**"), (int)1), JavaScriptCore.newAccessRule((IPath)new Path("**/discouraged/**"), (int)2), JavaScriptCore.newAccessRule((IPath)new Path("**/accessible/**"), (int)0)};
        IIncludePathAttribute[] extraAttributes = new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"javadoc_location", (String)"http://www.sample-url.org/doc/"), JavaScriptCore.newIncludepathAttribute((String)"org.eclipse.wst.jsdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", (String)"/tmp")};
        userEntries[0] = JavaScriptCore.newLibraryEntry((IPath)path, null, null, (IAccessRule[])pathRules, (IIncludePathAttribute[])extraAttributes, (boolean)false);
        path = new Path("/tmp/test.jar");
        pathRules = new IAccessRule[]{JavaScriptCore.newAccessRule((IPath)new Path("/org/eclipse/forbidden/**"), (int)1), JavaScriptCore.newAccessRule((IPath)new Path("/org/eclipse/discouraged/**"), (int)2), JavaScriptCore.newAccessRule((IPath)new Path("/org/eclipse/accessible/**"), (int)0)};
        extraAttributes = new IIncludePathAttribute[]{JavaScriptCore.newIncludepathAttribute((String)"javadoc_location", (String)"http://www.sample-url.org/doc/"), JavaScriptCore.newIncludepathAttribute((String)"org.eclipse.wst.jsdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", (String)"/tmp")};
        userEntries[1] = JavaScriptCore.newLibraryEntry((IPath)path, null, null, (IAccessRule[])pathRules, (IIncludePathAttribute[])extraAttributes, (boolean)false);
        UserLibrary library = new UserLibrary(userEntries, false);
        UserLibraryManager.setUserLibrary((String)"TEST", (UserLibrary)library, null);
        IEclipsePreferences instancePreferences = JavaModelManager.getJavaModelManager().getInstancePreferences();
        String containerKey = "org.eclipse.wst.jsdt.core.userLibrary.TEST";
        String libraryPreference = instancePreferences.get(containerKey, null);
        JavaProjectTests.assertNotNull((String)"Should get a preference for TEST user library", (Object)libraryPreference);
        this.assertSourceEquals("Invalid library contents", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<userlibrary systemlibrary=\"false\" version=\"1\">\n\t<archive path=\"/tmp/test.jar\">\n\t\t<attributes>\n\t\t\t<attribute name=\"javadoc_location\" value=\"http://www.sample-url.org/doc/\"/>\n\t\t\t<attribute name=\"org.eclipse.wst.jsdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY\" value=\"/tmp\"/>\n\t\t</attributes>\n\t\t<accessrules>\n\t\t\t<accessrule kind=\"nonaccessible\" pattern=\"**/forbidden/**\"/>\n\t\t\t<accessrule kind=\"discouraged\" pattern=\"**/discouraged/**\"/>\n\t\t\t<accessrule kind=\"accessible\" pattern=\"**/accessible/**\"/>\n\t\t</accessrules>\n\t</archive>\n\t<archive path=\"/tmp/test.jar\">\n\t\t<attributes>\n\t\t\t<attribute name=\"javadoc_location\" value=\"http://www.sample-url.org/doc/\"/>\n\t\t\t<attribute name=\"org.eclipse.wst.jsdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY\" value=\"/tmp\"/>\n\t\t</attributes>\n\t\t<accessrules>\n\t\t\t<accessrule kind=\"nonaccessible\" pattern=\"/org/eclipse/forbidden/**\"/>\n\t\t\t<accessrule kind=\"discouraged\" pattern=\"/org/eclipse/discouraged/**\"/>\n\t\t\t<accessrule kind=\"accessible\" pattern=\"/org/eclipse/accessible/**\"/>\n\t\t</accessrules>\n\t</archive>\n</userlibrary>\n", libraryPreference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug148859() throws CoreException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IJavaScriptProject project = JavaProjectTests.this.createJavaProject("P");
                    project.findType("X");
                    JavaProjectTests.this.createFolder("/P/pack");
                }
            }, null);
            IPackageFragmentRoot root = this.getPackageFragmentRoot("P", "");
            this.assertElementsEqual("Unexpected children size in 'P' default source folder", "<default> [in <project root> [in P]]\npack [in <project root> [in P]]", root.getChildren());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P");
    }
}

