/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.ComparisonFailure;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.model.CompletionTestsRequestor2;
import org.eclipse.wst.jsdt.internal.codeassist.RelevanceConstants;

public class SnippetCompletionTests
extends AbstractJavaModelTests
implements RelevanceConstants {
    static /* synthetic */ Class class$0;

    public SnippetCompletionTests(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("SnippetCompletion");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("SnippetCompletion");
        super.tearDownSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.SnippetCompletionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return SnippetCompletionTests.buildModelTestSuite(clazz);
    }

    protected void assertResults(String expected, String actual) {
        try {
            SnippetCompletionTests.assertEquals((String)expected, (String)actual);
        }
        catch (ComparisonFailure c) {
            System.out.println(actual);
            System.out.println();
            throw c;
        }
    }

    public void testCodeSnippetAssistForClassFile() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "aa.bb.cc", "AClass.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        type.codeComplete(snippet.toCharArray(), -1, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, Laa.bb.cc.SuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForCompilationUnit() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IJavaScriptUnit cu = this.getCompilationUnit("SnippetCompletion", "src", "aa.bb.cc", "BClass.js");
        IType type = cu.getTypes()[0];
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        String insertAftrer = "Victory{}";
        String s = cu.getSource();
        int insertion = -1;
        if (s != null) {
            insertion = s.lastIndexOf(insertAftrer) + insertAftrer.length();
        }
        type.codeComplete(snippet.toCharArray(), insertion, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("Victory[TYPE_REF]{Victory, aa.bb.cc, LVictory;, null, [" + tokenStart + ", " + tokenEnd + "], " + 11 + "}\n" + "void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, Laa.bb.cc.SuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForClassFileWithSource() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "aa.bb.cc", "CClass.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        String insertAftrer = "Victory{}";
        String s = cf.getSource();
        int insertion = -1;
        if (s != null) {
            insertion = s.lastIndexOf(insertAftrer) + insertAftrer.length();
        }
        type.codeComplete(snippet.toCharArray(), insertion, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("Victory[TYPE_REF]{Victory, aa.bb.cc, LVictory;, null, [" + tokenStart + ", " + tokenEnd + "], " + 11 + "}\n" + "void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, Laa.bb.cc.SuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForCompilationUnitWithoutSource() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IJavaScriptUnit cu = this.getCompilationUnit("SnippetCompletion", "src", "aa.bb.cc", "BClass.js");
        IType type = cu.getTypes()[0];
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        int insertion = -1;
        type.codeComplete(snippet.toCharArray(), insertion, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, Laa.bb.cc.SuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForClassFileInInnerClass() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "aa.bb.cc", "AClass$Inner.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        String insertAftrer = "Victory{}";
        String s = cf.getSource();
        int insertion = -1;
        if (s != null) {
            insertion = s.lastIndexOf(insertAftrer) + insertAftrer.length();
        }
        type.codeComplete(snippet.toCharArray(), insertion, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, Laa.bb.cc.SuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForClassFileInInterface() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "xx.yy", "MyInterface.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        type.codeComplete(snippet.toCharArray(), -1, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, LSuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForClassFileInInterface2() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "xx.yy", "MyInterface2.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        type.codeComplete(snippet.toCharArray(), -1, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "var[LOCAL_VARIABLE_REF]{var, null, I, var, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varFoo[FUNCTION_REF]{varFoo(), Lxx.yy.MyInterface2;, ()V, varFoo, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varsc[LOCAL_VARIABLE_REF]{varsc, null, LSuperClass;, varsc, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistForClassFileWithDollar() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "test00XX", "Test.class");
        IType type = cf.getType();
        String snippet = "int varX;\nint varY;\nvar";
        char[][] typeNames = new char[][]{};
        char[][] names = new char[][]{};
        int[] modifiers = new int[]{};
        type.codeComplete(snippet.toCharArray(), -1, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        int tokenStart = snippet.lastIndexOf("var");
        int tokenEnd = tokenStart + "var".length();
        this.assertResults("void[KEYWORD]{void, null, null, void, [" + tokenStart + ", " + tokenEnd + "], " + 18 + "}\n" + "varX[LOCAL_VARIABLE_REF]{varX, null, I, varX, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}\n" + "varY[LOCAL_VARIABLE_REF]{varY, null, I, varY, [" + tokenStart + ", " + tokenEnd + "], " + 21 + "}", requestor.getResults());
    }

    public void testCodeSnippetAssistInsideNumber() throws JavaScriptModelException {
        CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(false, false, true);
        IClassFile cf = this.getClassFile("SnippetCompletion", "class-folder", "aa.bb.cc", "AClass.class");
        IType type = cf.getType();
        String snippet = "new double[] {1.2, 3.\n";
        char[][] typeNames = new char[][]{"SuperClass".toCharArray(), "int".toCharArray()};
        char[][] names = new char[][]{"varsc".toCharArray(), "var".toCharArray()};
        int[] nArray = new int[2];
        nArray[1] = 16;
        int[] modifiers = nArray;
        type.codeComplete(snippet.toCharArray(), -1, snippet.length() - 2, (char[][])typeNames, (char[][])names, modifiers, false, (CompletionRequestor)requestor);
        this.assertResults("", requestor.getResults());
    }
}

