/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.ui.tests.utils.FileUtil;
import org.eclipse.wst.jsdt.ui.tests.utils.ProjectUnzipUtility;
import org.eclipse.wst.jsdt.ui.tests.utils.StringUtils;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class ContentAssistTests
extends TestCase {
    private static final String PROJECT_NAME = "ContentAssist";
    private static final String CONTENT_DIR = "root";
    private static final String ZIP_FOLDER = "testresources";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        fFileToEditorMap = new HashMap();
    }

    public ContentAssistTests() {
        super("Test JavaScript Content Assist");
    }

    public ContentAssistTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Test JavaScript Content Assist");
        return new ContentAssistTestsSetup((Test)ts);
    }

    public void testFindFunctions_ThisFile_EmptyLine() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcOne()", "funcTwo()", "funcThree(paramOne)", "funcFour(paramOne, paramTwo)"}};
        ContentAssistTests.runProposalTest("test1.js", 16, 0, expectedProposals);
    }

    public void testFindFunctions_ThisFile_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcOne()", "funcTwo()", "funcThree(paramOne)", "funcFour(paramOne, paramTwo)"}};
        ContentAssistTests.runProposalTest("test1.js", 18, 3, expectedProposals);
    }

    public void testFindFunctions_ThisFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTwo()", "funcThree(paramOne)"}};
        ContentAssistTests.runProposalTest("test1.js", 20, 5, expectedProposals);
    }

    public void testFindFunctions_OtherFile_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcOne()", "funcTwo()", "funcThree(paramOne)", "funcFour(paramOne, paramTwo)"}};
        ContentAssistTests.runProposalTest("test2.js", 0, 1, expectedProposals);
    }

    public void testFindFunctions_OtherFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"funcTwo()", "funcThree(paramOne)"}};
        ContentAssistTests.runProposalTest("test2.js", 2, 5, expectedProposals);
    }

    public void testFindAnonymousTypeField_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse", "eclipse2"}};
        ContentAssistTests.runProposalTest("test8_0.js", 6, 4, expectedProposals);
    }

    public void testFindAnonymousTypeField_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse", "eclipse2"}};
        ContentAssistTests.runProposalTest("test8_1.js", 6, 8, expectedProposals);
    }

    public void testFindFunctionOnAnonymousTypeField_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun()", "crazy()"}};
        ContentAssistTests.runProposalTest("test8_2.js", 6, 12, expectedProposals);
    }

    public void testFindFunctionOnAnonymousTypeField_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun()"}};
        ContentAssistTests.runProposalTest("test8_1.js", 8, 13, expectedProposals);
    }

    public void testFindConstructors_ThisFile_JustNew() throws Exception {
        String[][] expectedProposals = new String[][]{{"Awesome(param1, param2)", "bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 17, 4, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Awesome(param1, param2)"}};
        ContentAssistTests.runProposalTest("test3.js", 19, 6, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 21, 6, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)"}};
        ContentAssistTests.runProposalTest("test3.js", 23, 9, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 25, 10, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 27, 13, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 29, 5, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ExpressionStarted_6() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test3.js", 31, 9, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Awesome(param1, param2)"}};
        ContentAssistTests.runProposalTest("test4.js", 0, 6, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test4.js", 2, 6, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)"}};
        ContentAssistTests.runProposalTest("test4.js", 4, 9, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test4.js", 6, 10, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test4.js", 8, 13, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test4.js", 10, 5, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ExpressionStarted_6() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.Class1(a, b)", "bar.Class2(c, d, e)", "bar.foo.Class3(param1, param2, param3, param4)"}};
        ContentAssistTests.runProposalTest("test4.js", 12, 9, expectedProposals);
    }

    public void testFindConstructors_ThisFile_VarDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"MyClass1(a)", "MyClass2()"}};
        ContentAssistTests.runProposalTest("test5.js", 7, 8, expectedProposals);
    }

    public void testFindConstructors_OtherFile_VarDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"MyClass1(a)", "MyClass2()"}};
        ContentAssistTests.runProposalTest("test6.js", 0, 8, expectedProposals);
    }

    public void testFindConstructors_ThisFile_NestedVarDeclaration_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"MyClass7(a)"}};
        ContentAssistTests.runProposalTest("test7.js", 5, 8, expectedProposals);
    }

    public void testFindConstructors_ThisFileAndOtherFile_NestedVarDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"MyClass7(a)", "MyClass1(a)", "MyClass2()"}};
        ContentAssistTests.runProposalTest("test7.js", 10, 11, expectedProposals);
    }

    public void testFindConstructors_ThisFile_ArrayReferenceDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"test.Foo(x, y, z)"}};
        ContentAssistTests.runProposalTest("test9_0.js", 7, 7, expectedProposals);
    }

    public void testFindConstructors_OtherFile_ArrayReferenceDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"test.Foo(x, y, z)"}};
        ContentAssistTests.runProposalTest("test9_1.js", 0, 7, expectedProposals);
    }

    private static void runProposalTest(String fileName, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals) throws Exception {
        IFile file = ContentAssistTests.getFile(fileName);
        JavaEditor editor = ContentAssistTests.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = ContentAssistTests.getProposals(editor, offset, expectedProposals.length);
        ContentAssistTests.verifyExpectedProposal(pages, expectedProposals);
    }

    private static ICompletionProposal[][] getProposals(JavaEditor editor, int offset, int pageCount) throws Exception {
        JavaScriptSourceViewerConfiguration configuration = new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), JavaScriptPlugin.getDefault().getCombinedPreferenceStore(), (ITextEditor)editor, "___java_partitioning");
        ISourceViewer viewer = editor.getViewer();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant(viewer);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionBeginEventMethod = clazz.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionEndEventMethod = clazz2.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        return pages;
    }

    private static void verifyExpectedProposal(ICompletionProposal[][] pages, String[][] expectedProposals) {
        StringBuffer error = new StringBuffer();
        int page = 0;
        while (page < expectedProposals.length) {
            int expected = 0;
            while (expected < expectedProposals[page].length) {
                String expectedProposal = expectedProposals[page][expected];
                boolean found = false;
                int suggestion = 0;
                while (suggestion < pages[page].length && !found) {
                    found = pages[page][suggestion].getDisplayString().startsWith(expectedProposal);
                    ++suggestion;
                }
                if (!found) {
                    error.append("\nExpected proposal was not found on page " + page + ": '" + expectedProposal + "'");
                }
                ++expected;
            }
            ++page;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile("root/" + name);
        ContentAssistTests.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private static JavaEditor getEditor(IFile file) {
        JavaEditor editor = (JavaEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.jsdt.ui.CompilationUnitEditor", (boolean)true);
                if (editorPart instanceof JavaEditor) {
                    editor = (JavaEditor)editorPart;
                } else {
                    ContentAssistTests.fail((String)("Unable to open intended editor: " + editorPart.getClass().getName()));
                }
                if (editor != null) {
                    ContentAssistTests.standardizeLineEndings((ITextEditor)editor);
                    fFileToEditorMap.put(file, editor);
                } else {
                    ContentAssistTests.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                ContentAssistTests.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private static void standardizeLineEndings(ITextEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String contents = doc.get();
        contents = StringUtils.replace(contents, "\r\n", "\n");
        contents = StringUtils.replace(contents, "\r", "\n");
        doc.set(contents);
    }

    private static class ContentAssistTestsSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public ContentAssistTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
            ProjectUnzipUtility fProjUtil = new ProjectUnzipUtility();
            Location platformLocation = Platform.getInstanceLocation();
            if (platformLocation != null) {
                File zipFile = FileUtil.makeFileFor(ContentAssistTests.ZIP_FOLDER, "ContentAssist.zip", ContentAssistTests.ZIP_FOLDER);
                fProjUtil.unzipAndImport(zipFile, platformLocation.getURL().getPath());
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                fProject = root.getProject(ContentAssistTests.PROJECT_NAME);
                if (!fProject.exists()) {
                    fProject.create((IProgressMonitor)new NullProgressMonitor());
                }
                if (!fProject.isOpen()) {
                    fProject.open((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                JavaEditor editor = (JavaEditor)iter.next();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

