/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttachmentRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlAttributeMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlAttributeMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute");
            }
        });
    }

    private ICompilationUnit createTypeWithCollectionXmlAttribute() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlAttribute;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlType;").append(CR);
                sb.append(CR);
                sb.append("@XmlType").append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" {").append(CR);
                sb.append("    @XmlAttribute").append(CR);
                sb.append("    public List<String> list;").append(CR);
                sb.append("}").append(CR);
            }
        };
        return this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getDefaultName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getName());
        xmlAttributeMapping.getQName().setSpecifiedName("foo");
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getSpecifiedName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"id", (String)xmlAttributeMapping.getQName().getDefaultName());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getName());
        xmlAttributeMapping.getQName().setSpecifiedName(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedName());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
        xmlAttributeMapping.getQName().setSpecifiedNamespace("foo");
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeAnnotation.getNamespace());
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getNamespace());
        xmlAttributeMapping.getQName().setSpecifiedNamespace(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getNamespace());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((String)"foo", (String)xmlAttributeMapping.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getQName().getSpecifiedNamespace());
    }

    public void testModifyRequired() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
        xmlAttributeMapping.setSpecifiedRequired(Boolean.TRUE);
        XmlAttributeAnnotation xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeAnnotation.getRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)true, (boolean)xmlAttributeMapping.isRequired());
        xmlAttributeMapping.setSpecifiedRequired(null);
        xmlAttributeAnnotation = (XmlAttributeAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeAnnotation.getName());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
    }

    public void testUpdateRequired() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addXmlAttributeMemberValuePair(declaration, "required", true);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)true, (boolean)xmlAttributeMapping.isRequired());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlAttributeAnnotation = (NormalAnnotation)GenericJavaXmlAttributeMappingTests.this.getXmlAttributeAnnotation(declaration);
                GenericJavaXmlAttributeMappingTests.this.values(xmlAttributeAnnotation).remove(0);
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getSpecifiedRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isDefaultRequired());
        GenericJavaXmlAttributeMappingTests.assertEquals((boolean)false, (boolean)xmlAttributeMapping.isRequired());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping attributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = attributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        attributeMapping.addXmlJavaTypeAdapter();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        attributeMapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testModifyXmlSchemaType() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        xmlAttributeMapping.addXmlSchemaType();
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType"));
        xmlAttributeMapping.removeXmlSchemaType();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
    }

    public void testUpdateXmlSchemaType() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlSchemaType());
        GenericJavaXmlAttributeMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
    }

    protected void addXmlAttributeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, value);
    }

    protected void addXmlAttributeMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, value);
    }

    protected void addXmlAttributeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlAttributeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlAttributeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlAttribute");
    }

    public void testModifyXmlList1() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlAttributeMapping.setSpecifiedXmlList(true);
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlAttributeMapping.setSpecifiedXmlList(false);
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testModifyXmlList2() throws Exception {
        this.createTypeWithCollectionXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlAttributeMapping.setSpecifiedXmlList(true);
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlAttributeMapping.setSpecifiedXmlList(false);
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList1() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList2() throws Exception {
        this.createTypeWithCollectionXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isXmlList());
        GenericJavaXmlAttributeMappingTests.assertTrue((boolean)xmlAttributeMapping.isDefaultXmlList());
        GenericJavaXmlAttributeMappingTests.assertFalse((boolean)xmlAttributeMapping.isSpecifiedXmlList());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testModifyXmlID() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
        xmlAttributeMapping.addXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDAnnotation);
        xmlAttributeMapping.removeXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
    }

    public void testUpdateXmlID() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlID());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDAnnotation);
    }

    public void testModifyXmlIDREF() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
        xmlAttributeMapping.addXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        xmlAttributeMapping.removeXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
    }

    public void testUpdateXmlIDREF() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlIDREF());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testModifyXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        xmlAttributeMapping.addXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        xmlAttributeMapping.removeXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
    }

    public void testUpdateXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaXmlAttributeMapping xmlAttributeMapping = (JavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlAttributeMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttributeMapping.getXmlAttachmentRef());
        GenericJavaXmlAttributeMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
    }
}

