/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.core.tests.PreferencesTests;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPreferencesTests
extends PreferencesTests {
    private static final String WORKSPACE_PREFS_FILE_NAME = "org.eclipse.jpt.core.prefs";
    private static final String PROJECT_PREFS_FILE_NAME = "org.eclipse.jpt.core.prefs";
    private static final String JPA_PLATFORM = "org.eclipse.jpt.core.platform";
    private static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.jpa.core.discoverAnnotatedClasses";
    private static final String METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.jpa.core.metamodelSourceFolderName";
    private static final String ENTITY_GEN_DEFAULT_PACKAGE_NAME = "entitygen.DEFAULT_PACKAGE";
    private static final String JPQL_IDENTIFIER_CASE = "jpqlIdentifier.CASE";
    private static final String JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE = "jpqlIdentifier.MATCH_FIRST_CHARACTER_CASE";
    private static final String WORKSPACE_PREFERENCES_OVERRIDDEN = "workspace_validation_preferences_overridden";
    private static final String PROBLEM_NO_JPA_PROJECT = "problem.NO_JPA_PROJECT";

    public JpaPreferencesTests(String name) {
        super(name);
    }

    protected String getWorkspacePrefsFileName() {
        return "org.eclipse.jpt.core.prefs";
    }

    protected String getProjectPrefsFileName() {
        return "org.eclipse.jpt.core.prefs";
    }

    protected Class<?> getPreferencesClass() {
        return JpaPreferences.class;
    }

    public void testJpaPlatformID() throws Exception {
        String value = "FOO";
        JpaPreferences.setJpaPlatformID((IProject)this.getProject(), (String)value);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertEquals((String)value, (String)JpaPreferences.getJpaPlatformID((IProject)this.getProject()));
        JpaPreferencesTests.assertEquals((String)value, (String)this.readProjectPrefs().getProperty(JPA_PLATFORM));
    }

    public void testDiscoverAnnotatedClasses() throws Exception {
        JpaPreferences.setDiscoverAnnotatedClasses((IProject)this.getProject(), (boolean)true);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertTrue((boolean)JpaPreferences.getDiscoverAnnotatedClasses((IProject)this.getProject()));
        JpaPreferencesTests.assertTrue((boolean)Boolean.parseBoolean(this.readProjectPrefs().getProperty(DISCOVER_ANNOTATED_CLASSES)));
    }

    public void testMetamodelSourceFolderName() throws Exception {
        String value = "gen";
        JpaPreferences.setMetamodelSourceFolderName((IProject)this.getProject(), (String)value);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertEquals((String)value, (String)JpaPreferences.getMetamodelSourceFolderName((IProject)this.getProject()));
        JpaPreferencesTests.assertEquals((String)value, (String)this.readProjectPrefs().getProperty(METAMODEL_SOURCE_FOLDER_NAME));
    }

    public void testEntityGenDefaultPackageName_Project() throws Exception {
        String value = "entitygen";
        JpaPreferences.setEntityGenDefaultPackageName((IProject)this.getProject(), (String)value);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertEquals((String)value, (String)JpaPreferences.getEntityGenDefaultPackageName((IProject)this.getProject()));
        JpaPreferencesTests.assertEquals((String)value, (String)this.readProjectPrefs().getProperty(ENTITY_GEN_DEFAULT_PACKAGE_NAME));
    }

    public void testEntityGenDefaultPackageName_Workspace() throws Exception {
        String value = "wsentitygen";
        JpaPreferences.setEntityGenDefaultPackageName((String)value);
        this.flushWorkspacePrefs();
        JpaPreferencesTests.assertEquals((String)value, (String)JpaPreferences.getEntityGenDefaultPackageName((IProject)this.getProject()));
        JpaPreferencesTests.assertEquals((String)value, (String)JpaPreferences.getEntityGenDefaultPackageName());
        JpaPreferencesTests.assertEquals((String)value, (String)this.readWorkspacePrefs().getProperty(ENTITY_GEN_DEFAULT_PACKAGE_NAME));
    }

    public void testJpqlIdentifierLowercase() throws Exception {
        JpaPreferences.setJpqlIdentifierLowercase((boolean)false);
        this.flushWorkspacePrefs();
        JpaPreferencesTests.assertFalse((boolean)JpaPreferences.getJpqlIdentifierLowercase());
        JpaPreferencesTests.assertEquals((String)"uppercase", (String)this.readWorkspacePrefs().getProperty(JPQL_IDENTIFIER_CASE));
    }

    public void testJpqlIdentifierMatchFirstCharacterCase() throws Exception {
        JpaPreferences.setJpqlIdentifierMatchFirstCharacterCase((boolean)false);
        this.flushWorkspacePrefs();
        JpaPreferencesTests.assertFalse((boolean)JpaPreferences.getJpqlIdentifierMatchFirstCharacterCase());
        JpaPreferencesTests.assertFalse((boolean)Boolean.parseBoolean(this.readWorkspacePrefs().getProperty(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE)));
    }

    public void testWorkspaceValidationPreferencesOverridden() throws Exception {
        JpaPreferences.setWorkspaceValidationOverridden((IProject)this.getProject(), (boolean)true);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertTrue((boolean)JpaPreferences.getWorkspaceValidationOverridden((IProject)this.getProject()));
        JpaPreferencesTests.assertTrue((boolean)Boolean.parseBoolean(this.readProjectPrefs().getProperty(WORKSPACE_PREFERENCES_OVERRIDDEN)));
    }

    public void testProblemSeverity_Project() throws Exception {
        JpaPreferences.setValidationMessageSeverity((IProject)this.getProject(), (String)JptJpaCoreValidationMessages.NO_JPA_PROJECT.getID(), (int)4);
        this.flushProjectPrefs();
        JpaPreferencesTests.assertEquals((int)4, (int)JpaPreferences.getValidationMessageSeverity((IProject)this.getProject(), (String)JptJpaCoreValidationMessages.NO_JPA_PROJECT.getID()));
        JpaPreferencesTests.assertEquals((Object)ClassTools.get(JptPlugin.class, (String)"PROBLEM_INFO"), (Object)this.readProjectPrefs().getProperty(PROBLEM_NO_JPA_PROJECT));
    }

    public void testProblemSeverity_Workspace() throws Exception {
        JpaPreferences.setValidationMessageSeverity((String)JptJpaCoreValidationMessages.NO_JPA_PROJECT.getID(), (int)2);
        this.flushWorkspacePrefs();
        JpaPreferencesTests.assertEquals((int)2, (int)JpaPreferences.getValidationMessageSeverity((IProject)this.getProject(), (String)JptJpaCoreValidationMessages.NO_JPA_PROJECT.getID()));
        JpaPreferencesTests.assertEquals((int)2, (int)JpaPreferences.getValidationMessageSeverity((String)JptJpaCoreValidationMessages.NO_JPA_PROJECT.getID()));
        JpaPreferencesTests.assertEquals((Object)ClassTools.get(JptPlugin.class, (String)"PROBLEM_WARNING"), (Object)this.readWorkspacePrefs().getProperty(PROBLEM_NO_JPA_PROJECT));
    }
}

