/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.CacheableReference2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CacheableAnnotation2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaMappedSuperclassTests
extends EclipseLink2_0ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_0JavaMappedSuperclassTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createTestMappedSuperclassWithReadOnly() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@ReadOnly").append(CR);
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    public EclipseLink2_0JavaMappedSuperclassTests(String name) {
        super(name);
    }

    public void testGetReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
    }

    public void testGetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetDefaultReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
    }

    public void testSetSpecifiedReadOnly() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.FALSE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLink2_0JavaMappedSuperclassTests.assertNotNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(null);
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testSpecifiedReadOnlyUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)readOnly.getSpecifiedReadOnly());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
        resourceType.addAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestMappedSuperclassWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkCustomizer customizer = mappedSuperclass.getCustomizer();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestMappedSuperclassWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkMappedSuperclass mappedSuperclass = (EclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = mappedSuperclass.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLink2_0JavaMappedSuperclassTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaPersistentType().getMapping()).getCacheable();
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheable.setSpecifiedCacheable(null);
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testGetSpecifiedCacheable() throws Exception {
        ICompilationUnit cu = this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaPersistentType().getMapping()).getCacheable();
        CacheableAnnotation2_0 cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation);
        this.getJavaPersistentType().getJavaResourceType().addAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        cacheableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.FALSE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(false)", cu);
        cacheableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable(true)", cu);
        cacheableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)Boolean.TRUE, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation.getValue());
        this.assertSourceContains("@Cacheable", cu);
        this.getJavaPersistentType().getJavaResourceType().removeAnnotation("javax.persistence.Cacheable");
        this.getJpaProject().synchronizeContextModel();
        cacheableAnnotation = (CacheableAnnotation2_0)this.getJavaPersistentType().getJavaResourceType().getAnnotation("javax.persistence.Cacheable");
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheable.getSpecifiedCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals(null, (Object)cacheableAnnotation);
        this.assertSourceDoesNotContain("@Cacheable", cu);
    }

    public void testIsDefaultCacheable() throws Exception {
        this.createTestMappedSuperclass();
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaPersistentType().getMapping()).getCacheable();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((Object)SharedCacheMode2_0.DISABLE_SELECTIVE, (Object)persistenceUnit.getSharedCacheMode());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ALL);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ENABLE_SELECTIVE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.DISABLE_SELECTIVE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit.setSpecifiedSharedCacheMode(SharedCacheMode2_0.UNSPECIFIED);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
    }

    public void testInheritedIsDefaultCacheable() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        Cacheable2_0 subCacheable = ((CacheableReference2_0)this.getJavaPersistentType().getMapping()).getCacheable();
        Cacheable2_0 cacheable = ((CacheableReference2_0)this.getJavaPersistentType().getSuperPersistentType().getMapping()).getCacheable();
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        EclipseLinkPersistenceUnit persistenceUnit2_0 = this.getPersistenceUnit();
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(null);
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.DISABLE_SELECTIVE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.FALSE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.ENABLE_SELECTIVE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        cacheable.setSpecifiedCacheable(Boolean.TRUE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
        persistenceUnit2_0.setSpecifiedSharedCacheMode(SharedCacheMode2_0.NONE);
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)true, (boolean)subCacheable.isDefaultCacheable());
        EclipseLink2_0JavaMappedSuperclassTests.assertEquals((boolean)false, (boolean)cacheable.isDefaultCacheable());
    }
}

