/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsIdAnnotation2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOneAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaOneToOneMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0JavaOneToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(orphanRemoval=false)");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)annotation.getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"bar", (String)annotation.getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceField.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("address");
        OneToOneMapping2_0 contextMapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        MapsIdAnnotation2_0 annotation = (MapsIdAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapsId");
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)annotation.getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"bar", (String)annotation.getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaSpecifiedPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)((OneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)((ManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey(null);
        resourceField.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)(contextAttribute.getMapping() instanceof OneToOneMapping2_0));
        contextAttribute.setMappingKey("manyToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)(contextAttribute.getMapping() instanceof ManyToOneMapping2_0));
        contextAttribute.setMappingKey("basic");
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private OrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return oneToOneMapping.getOrphanRemoval();
    }

    public void testDefaultOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)this.getOrphanRemovalOf(oneToOneMapping).getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        OrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation2_0 oneToOne = (OneToOneAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToOne.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        EclipseLink2_0JavaOneToOneMappingTests.assertSame((Object)oneToOneMapping, (Object)persistentAttribute.getMapping());
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        resourceField.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationship2_0 rel = (OneToOneRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToPrimaryKeyJoinColumn();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToMappedBy();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceField.getAnnotation("javax.persistence.OneToOne");
        SpecifiedPersistentAttribute contextAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationship2_0 rel = (OneToOneRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.PrimaryKeyJoinColumn"));
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)annotation.getMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        EclipseLink2_0JavaOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }
}

