/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MutableAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaBasicMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasic() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaBasicMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        basicMapping.setConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)basicMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        TemporalAnnotation temporal = (TemporalAnnotation)resourceField.getAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        basicMapping.setConverter(null);
        EclipseLinkJavaBasicMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithBasicMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        BasicMapping basicMapping = (BasicMapping)persistentAttribute.getMapping();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ConvertAnnotation convert = (ConvertAnnotation)resourceField.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)basicMapping.getConverter()).getConverterName());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        EclipseLinkJavaBasicMappingTests.assertSame((Object)basicMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        resourceField.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MutableAnnotation mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (MutableAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getEclipseLinkOptions().setTemporalMutable(null);
        EclipseLinkJavaBasicMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableBasic();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkBasicMapping basicMapping = (EclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = basicMapping.getMutable();
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaBasicMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

