/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmManyToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmManyToOneMappingTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkOrmManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToOne").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Employee employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestTypeWithManyToOneAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("    private Foo manyToOne;").append(CR);
            }
        });
    }

    public void testUpdateJoinFetch() throws Exception {
        this.createTestTypeWithManyToOneAttribute();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToOne"), "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        resourceManyToOne.setJoinFetch(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        this.createTestTypeWithManyToOneAttribute();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("manyToOne"), "manyToOne");
        EclipseLinkRelationshipMapping contextManyToOne = (EclipseLinkRelationshipMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextManyToOne.getJoinFetch().getValue());
        contextManyToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getJoinFetch());
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)contextManyToOne.getJoinFetch().getValue());
    }

    public void testJoinFetchDefaultFromJava() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        EclipseLinkRelationshipMapping manyToOneMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOneMapping.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLinkOneToOneMapping oneToOne = (EclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employee").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        manyToOneMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertNull((Object)manyToOneMapping.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        manyToOneMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)manyToOneMapping.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLinkOrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToOneMapping virtualManyToOneMapping = (ManyToOneMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"address", (String)virtualManyToOneMapping.getName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualManyToOneMapping.getSpecifiedFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualManyToOneMapping.getSpecifiedOptional());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"Address", (String)virtualManyToOneMapping.getSpecifiedTargetEntity());
        SpecifiedJoinColumn virtualJoinColumn = (SpecifiedJoinColumn)virtualManyToOneMapping.getRelationship().getJoinColumnStrategy().getSpecifiedJoinColumns().iterator().next();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTableName());
        Cascade cascade = virtualManyToOneMapping.getCascade();
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualManyToOneMapping).getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"oneToOne", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLinkOrmManyToOneMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = virtualPersistentAttribute.addToXml("manyToOne");
        EclipseLinkOrmManyToOneMapping ormManyToOneMapping = (EclipseLinkOrmManyToOneMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        EclipseLinkOrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmCascade2_0 cascade = ormManyToOneMapping.getCascade();
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmManyToOneMappingTests.assertEquals(null, (Object)ormManyToOneMapping.getJoinFetch().getValue());
    }
}

