/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeListValueModel<E1, E2>
extends ListValueModelWrapper<E1>
implements ListValueModel<E2> {
    private final Transformer<E1, ? extends ListValueModel<? extends E2>> transformer;
    private final ArrayList<Info> infoList = new ArrayList();
    private final ListChangeListener componentLVMListener;
    private int size;

    public static <E1 extends ListValueModel<? extends E2>, E2> CompositeListValueModel<E1, E2> forModels(CollectionValueModel<E1> collectionModel) {
        return CompositeListValueModel.forModels(new CollectionListValueModelAdapter<E1>(collectionModel));
    }

    public static <E1 extends ListValueModel<? extends E2>, E2> CompositeListValueModel<E1, E2> forModels(List<E1> list) {
        return CompositeListValueModel.forModels(new StaticListValueModel<E1>(list));
    }

    public static <E1 extends ListValueModel<? extends E2>, E2> CompositeListValueModel<E1, E2> forModels(E1 ... list) {
        return CompositeListValueModel.forModels(new StaticListValueModel<E1>(list));
    }

    public static <E1 extends ListValueModel<? extends E2>, E2> CompositeListValueModel<E1, E2> forModels(ListValueModel<E1> listModel) {
        return new CompositeListValueModel<E1, E2>(listModel, TransformerTools.passThruTransformer());
    }

    public CompositeListValueModel(CollectionValueModel<? extends E1> collectionModel, Transformer<E1, ? extends ListValueModel<? extends E2>> transformer) {
        this(new CollectionListValueModelAdapter<E1>(collectionModel), transformer);
    }

    public CompositeListValueModel(List<? extends E1> list, Transformer<E1, ? extends ListValueModel<? extends E2>> transformer) {
        this(new StaticListValueModel<E1>(list), transformer);
    }

    public CompositeListValueModel(E1[] list, Transformer<E1, ? extends ListValueModel<? extends E2>> transformer) {
        this(new StaticListValueModel<E1>(list), transformer);
    }

    public CompositeListValueModel(ListValueModel<? extends E1> listModel, Transformer<E1, ? extends ListValueModel<? extends E2>> transformer) {
        super(listModel);
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.componentLVMListener = this.buildComponentLVMListener();
        this.size = 0;
    }

    protected ListChangeListener buildComponentLVMListener() {
        return new ComponentListener();
    }

    @Override
    public E2 get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int i = this.infoList.size();
        while (i-- > 0) {
            Info info = this.infoList.get(i);
            if (index < info.begin) continue;
            return info.items.get(index - info.begin);
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<E2> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E2> listIterator() {
        return this.buildListIterable().iterator();
    }

    protected ListIterable<E2> buildListIterable() {
        return new ReadOnlyCompositeListIterable<E2>(this.buildListsIterables());
    }

    protected ListIterable<ListIterable<E2>> buildListsIterables() {
        return IterableTools.transform(IterableTools.listIterable(this.infoList), new InfoTransformer());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return ArrayTools.array(this.listIterator(), this.size);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.addComponentSources(0, this.listModel, this.listModel.size(), false);
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        for (Info info : this.infoList) {
            info.componentLVM.removeListChangeListener("list values", this.componentLVMListener);
        }
        this.infoList.clear();
        this.size = 0;
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.addComponentSources(event.getIndex(), this.getItems(event), event.getItemsSize(), true);
    }

    protected void addComponentSources(int addedSourcesIndex, Iterable<? extends E1> addedSources, int addedSourcesSize, boolean fireEvent) {
        int movedInfosIndex;
        int newItemsIndex;
        ArrayList<Info> newInfoList = new ArrayList<Info>(addedSourcesSize);
        int begin = newItemsIndex = addedSourcesIndex == this.infoList.size() ? this.size : this.infoList.get((int)addedSourcesIndex).begin;
        for (E1 source : addedSources) {
            ListValueModel<E2> componentLVM = this.transformer.transform(source);
            componentLVM.addListChangeListener("list values", this.componentLVMListener);
            ArrayList items = new ArrayList(componentLVM.size());
            CollectionTools.addAll(items, componentLVM.listIterator());
            newInfoList.add(new Info(source, componentLVM, items, begin));
            begin += items.size();
        }
        this.infoList.addAll(addedSourcesIndex, newInfoList);
        int newItemsSize = begin - newItemsIndex;
        this.size += newItemsSize;
        int i = movedInfosIndex = addedSourcesIndex + addedSourcesSize;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin += newItemsSize;
            ++i;
        }
        if (fireEvent) {
            ArrayList newItems = new ArrayList(newItemsSize);
            int i2 = addedSourcesIndex;
            while (i2 < movedInfosIndex) {
                newItems.addAll(this.infoList.get((int)i2).items);
                ++i2;
            }
            this.fireItemsAdded("list values", newItemsIndex, newItems);
        }
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.removeComponentSources(event.getIndex(), event.getItemsSize(), true);
    }

    protected void removeComponentSources(int removedSourcesIndex, int removedSourcesSize, boolean fireEvent) {
        int removedItemsIndex = this.infoList.get((int)removedSourcesIndex).begin;
        int movedSourcesIndex = removedSourcesIndex + removedSourcesSize;
        int movedItemsIndex = movedSourcesIndex == this.infoList.size() ? this.size : this.infoList.get((int)movedSourcesIndex).begin;
        int removedItemsSize = movedItemsIndex - removedItemsIndex;
        this.size -= removedItemsSize;
        List<Info> subList = this.infoList.subList(removedSourcesIndex, removedSourcesIndex + removedSourcesSize);
        ArrayList<Info> removedInfoList = new ArrayList<Info>(subList);
        subList.clear();
        int i = removedSourcesIndex;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        for (Info removedInfo : removedInfoList) {
            removedInfo.componentLVM.removeListChangeListener("list values", this.componentLVMListener);
        }
        if (fireEvent) {
            ArrayList removedItems = new ArrayList(removedItemsSize);
            for (Info removedInfo : removedInfoList) {
                removedItems.addAll(removedInfo.items);
            }
            this.fireItemsRemoved("list values", removedItemsIndex, removedItems);
        }
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.replaceComponentSources(event.getIndex(), this.getNewItems(event), event.getItemsSize(), true);
    }

    protected void replaceComponentSources(int replacedSourcesIndex, Iterable<? extends E1> newSources, int replacedSourcesSize, boolean fireEvent) {
        this.removeComponentSources(replacedSourcesIndex, replacedSourcesSize, fireEvent);
        this.addComponentSources(replacedSourcesIndex, newSources, replacedSourcesSize, fireEvent);
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.moveComponentSources(event.getTargetIndex(), event.getSourceIndex(), event.getLength(), true);
    }

    protected void moveComponentSources(int targetSourcesIndex, int sourceSourcesIndex, int movedSourcesLength, boolean fireEvent) {
        int sourceItemsIndex = this.infoList.get((int)sourceSourcesIndex).begin;
        int nextSourceSourceIndex = sourceSourcesIndex + movedSourcesLength;
        int nextSourceItemIndex = nextSourceSourceIndex == this.infoList.size() ? this.size : this.infoList.get((int)nextSourceSourceIndex).begin;
        int moveItemsLength = nextSourceItemIndex - sourceItemsIndex;
        int targetItemsIndex = -1;
        if (sourceSourcesIndex > targetSourcesIndex) {
            targetItemsIndex = this.infoList.get((int)targetSourcesIndex).begin;
        } else {
            int nextTargetSourceIndex = targetSourcesIndex + movedSourcesLength;
            targetItemsIndex = nextTargetSourceIndex == this.infoList.size() ? this.size : this.infoList.get((int)nextTargetSourceIndex).begin;
            targetItemsIndex -= moveItemsLength;
        }
        ListTools.move(this.infoList, targetSourcesIndex, sourceSourcesIndex, movedSourcesLength);
        int min = Math.min(targetSourcesIndex, sourceSourcesIndex);
        int max = Math.max(targetSourcesIndex, sourceSourcesIndex) + movedSourcesLength;
        int begin = Math.min(targetItemsIndex, sourceItemsIndex);
        int i = min;
        while (i < max) {
            Info info = this.infoList.get(i);
            info.begin = begin;
            begin += info.componentLVM.size();
            ++i;
        }
        if (fireEvent) {
            this.fireItemsMoved("list values", targetItemsIndex, sourceItemsIndex, moveItemsLength);
        }
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.clearComponentSources();
    }

    protected void clearComponentSources() {
        this.removeComponentSources(0, this.infoList.size(), false);
        this.fireListCleared("list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        int newSize = this.listModel.size();
        if (newSize == 0) {
            this.clearComponentSources();
            return;
        }
        int oldSize = this.infoList.size();
        if (oldSize == 0) {
            this.addComponentSources(0, this.listModel, newSize, true);
            return;
        }
        int min = Math.min(newSize, oldSize);
        int i = 0;
        while (i < min) {
            Object oldSource;
            Object newSource = this.listModel.get(i);
            if (this.valuesAreDifferent(newSource, oldSource = this.infoList.get((int)i).source)) {
                this.replaceComponentSources(i, new SingleElementIterable(newSource), 1, true);
            }
            ++i;
        }
        if (newSize == oldSize) {
            return;
        }
        if (newSize < oldSize) {
            this.removeComponentSources(min, oldSize - newSize, true);
            return;
        }
        this.addComponentSources(min, this.buildSubListHolder(min), newSize - oldSize, true);
    }

    protected Iterable<? extends E1> buildSubListHolder(int fromIndex) {
        int listModelSize = this.listModel.size();
        return ListTools.list(this.listModel, listModelSize).subList(fromIndex, listModelSize);
    }

    protected Iterable<? extends E1> buildSubListHolder(int fromIndex, int toIndex) {
        int listModelSize = this.listModel.size();
        return fromIndex == 0 && toIndex == listModelSize ? this.listModel : ListTools.list(this.listModel, listModelSize).subList(fromIndex, toIndex);
    }

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }

    protected int indexOf(ListValueModel<E2> componentLVM) {
        int i = 0;
        while (i < this.infoList.size()) {
            if (this.infoList.get((int)i).componentLVM == componentLVM) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("invalid component LVM: " + componentLVM);
    }

    protected int indexFor(ListEvent event) {
        return this.indexOf(this.getComponentLVM(event));
    }

    protected void componentItemsAdded(ListAddEvent event) {
        int componentLVMIndex = this.indexFor(event);
        this.addComponentItems(componentLVMIndex, this.infoList.get(componentLVMIndex), event.getIndex(), this.getComponentItems(event), event.getItemsSize());
    }

    protected void addComponentItems(int componentLVMIndex, Info info, int addedItemsIndex, Iterable<? extends E2> addedItems, int addedItemsSize) {
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin += addedItemsSize;
            ++i;
        }
        this.size += addedItemsSize;
        ListTools.addAll(info.items, addedItemsIndex, addedItems, addedItemsSize);
        this.fireItemsAdded("list values", info.begin + addedItemsIndex, info.items.subList(addedItemsIndex, addedItemsIndex + addedItemsSize));
    }

    protected void componentItemsRemoved(ListRemoveEvent event) {
        int componentLVMIndex = this.indexFor(event);
        int removedItemsSize = event.getItemsSize();
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        this.size -= removedItemsSize;
        Info info = this.infoList.get(componentLVMIndex);
        int itemIndex = event.getIndex();
        info.items.subList(itemIndex, itemIndex + event.getItemsSize()).clear();
        this.fireItemsRemoved(event.clone(this, "list values", info.begin));
    }

    protected void componentItemsReplaced(ListReplaceEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        int i = event.getIndex();
        for (E2 item : this.getComponentItems(event)) {
            info.items.set(i++, item);
        }
        this.fireItemsReplaced(event.clone(this, "list values", info.begin));
    }

    protected void componentItemsMoved(ListMoveEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        ListTools.move(info.items, event.getTargetIndex(), event.getSourceIndex(), event.getLength());
        this.fireItemsMoved(event.clone(this, "list values", info.begin));
    }

    protected void componentListCleared(ListClearEvent event) {
        int componentLVMIndex = this.indexFor(event);
        this.clearComponentList(componentLVMIndex, this.infoList.get(componentLVMIndex));
    }

    protected void clearComponentList(int componentLVMIndex, Info info) {
        int removedItemsSize = info.items.size();
        if (removedItemsSize == 0) {
            return;
        }
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        this.size -= removedItemsSize;
        ArrayList items = new ArrayList(info.items);
        info.items.clear();
        this.fireItemsRemoved("list values", info.begin, items);
    }

    protected void componentListChanged(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        int newItemsSize = info.componentLVM.size();
        if (newItemsSize == 0) {
            this.clearComponentList(componentLVMIndex, info);
            return;
        }
        int oldItemsSize = info.items.size();
        if (oldItemsSize == 0) {
            this.addComponentItems(componentLVMIndex, info, 0, info.componentLVM, newItemsSize);
            return;
        }
        int min = Math.min(newItemsSize, oldItemsSize);
        int i = 0;
        while (i < min) {
            Object newItem = info.componentLVM.get(i);
            Object oldItem = info.items.set(i, newItem);
            this.fireItemReplaced("list values", info.begin + i, newItem, oldItem);
            ++i;
        }
        int delta = newItemsSize - oldItemsSize;
        if (delta == 0) {
            return;
        }
        int i2 = componentLVMIndex + 1;
        while (i2 < this.infoList.size()) {
            this.infoList.get((int)i2).begin += delta;
            ++i2;
        }
        this.size += delta;
        if (delta < 0) {
            List subList = info.items.subList(newItemsSize, oldItemsSize);
            ArrayList removedItems = new ArrayList(subList);
            subList.clear();
            this.fireItemsRemoved("list values", info.begin + newItemsSize, removedItems);
            return;
        }
        ArrayList addedItems = new ArrayList(delta);
        int i3 = oldItemsSize;
        while (i3 < newItemsSize) {
            addedItems.add(info.componentLVM.get(i3));
            ++i3;
        }
        info.items.addAll(addedItems);
        this.fireItemsAdded("list values", info.begin + oldItemsSize, addedItems);
    }

    protected Iterable<E2> getComponentItems(ListAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E2> getComponentItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    protected ListValueModel<E2> getComponentLVM(ListEvent event) {
        return (ListValueModel)event.getSource();
    }

    protected class ComponentListener
    extends ListChangeAdapter {
        protected ComponentListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            CompositeListValueModel.this.componentItemsAdded(event);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            CompositeListValueModel.this.componentItemsRemoved(event);
        }

        public void itemsReplaced(ListReplaceEvent event) {
            CompositeListValueModel.this.componentItemsReplaced(event);
        }

        public void itemsMoved(ListMoveEvent event) {
            CompositeListValueModel.this.componentItemsMoved(event);
        }

        public void listCleared(ListClearEvent event) {
            CompositeListValueModel.this.componentListCleared(event);
        }

        public void listChanged(ListChangeEvent event) {
            CompositeListValueModel.this.componentListChanged(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Info {
        final E1 source;
        final ListValueModel<? extends E2> componentLVM;
        final ArrayList<E2> items;
        int begin;

        protected Info(E1 source, ListValueModel<? extends E2> componentLVM, ArrayList<E2> items, int begin) {
            this.source = source;
            this.componentLVM = componentLVM;
            this.items = items;
            this.begin = begin;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InfoTransformer
    extends TransformerAdapter<Info, ListIterable<E2>> {
        protected InfoTransformer() {
        }

        @Override
        public ListIterable<E2> transform(Info info) {
            return IterableTools.listIterable(info.items);
        }
    }
}

