/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.prefs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JpaPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean lowercase;
    private Button lowerCaseRadioButton;
    private boolean matchFirstCharacterCase;
    private Spinner numberOfLinesInJpqlQuerySpinner;
    private int numberOfLinesInJpqlQueryTextArea;
    private Button matchFirstCharacterCaseCheckBox;
    private Button upperCaseRadioButton;
    private Text defaultPackageText;
    private static final String JPQL_IDENTIFIER_CASE_PREF_KEY = String.valueOf(JptJpaUiPlugin.instance().getPluginID()) + ".jpqlIdentifier.case";
    private static final String JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE_PREF_KEY = String.valueOf(JptJpaUiPlugin.instance().getPluginID()) + ".jpqlIdentifier.matchFirstCharacterCase";

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        Label description = new Label(parent, 0);
        description.setText(JptJpaUiMessages.JpaPreferencesPage_description);
        this.addEntityGenGroup(parent);
        this.addJpqlEditorGroup(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void performDefaults() {
        this.setDefaultPackage(JpaPreferences.getEntityGenDefaultPackageName());
        this.numberOfLinesInJpqlQueryTextArea = this.getJpqlQueryTextAreaNumberOfLinesDefault();
        this.numberOfLinesInJpqlQuerySpinner.setSelection(this.numberOfLinesInJpqlQueryTextArea);
        this.lowercase = this.isDefaultJpqlIdentifierLowercase();
        this.matchFirstCharacterCase = this.shouldMatchFirstCharacterCaseDefault();
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
        super.performDefaults();
    }

    public boolean performOk() {
        JpaPreferences.setEntityGenDefaultPackageName((String)this.getDefaultPackage());
        JpaPreferences.setJpqlQueryTextAreaNumberOfLines((int)this.numberOfLinesInJpqlQueryTextArea);
        JpaPreferences.setJpqlIdentifierLowercase((boolean)this.lowercase);
        JpaPreferences.setJpqlIdentifierMatchFirstCharacterCase((boolean)this.matchFirstCharacterCase);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.migrateLegacyJpqlWorkspacePreferences();
        this.numberOfLinesInJpqlQueryTextArea = this.getJpqlQueryTextAreaNumberOfLines();
        this.lowercase = this.shouldUseLowercaseIdentifiers();
        this.matchFirstCharacterCase = this.shouldMatchFirstCharacterCase();
    }

    private void addEntityGenGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JptJpaUiMessages.JpaPreferencesPage_entityGen);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.buildLabel((Composite)group, 1, JptJpaUiMessages.JpaPreferencesPage_entityGen_defaultPackageLabel);
        this.defaultPackageText = this.buildText((Composite)group, 1);
        this.defaultPackageText.setText(JpaPreferences.getEntityGenDefaultPackageName());
    }

    private void addJpqlEditorGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JptJpaUiMessages.JpaPreferencesPage_jpqlEditor);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Composite jpqlQueryTextAreaComposite = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        jpqlQueryTextAreaComposite.setLayout((Layout)layout);
        this.buildLabel(jpqlQueryTextAreaComposite, 1, JptJpaUiMessages.JpaPreferencesPage_jpqlEditor_textAreaNumberOfLines);
        this.numberOfLinesInJpqlQuerySpinner = new Spinner(jpqlQueryTextAreaComposite, 2048);
        this.numberOfLinesInJpqlQuerySpinner.setValues(this.numberOfLinesInJpqlQueryTextArea, 0, 100, 0, 1, 10);
        this.numberOfLinesInJpqlQuerySpinner.addSelectionListener(this.buildNumberOfLinesInJpqlQuerySelectionListener());
        Label description = new Label((Composite)group, 0);
        description.setText(JptJpaUiMessages.JpaPreferencesPage_jpqlEditor_description);
        this.lowerCaseRadioButton = new Button((Composite)group, 16);
        this.lowerCaseRadioButton.setText(JptJpaUiMessages.JpaPreferencesPage_jpqlEditor_lowerCaseRadioButton);
        this.lowerCaseRadioButton.addSelectionListener(this.buildLowercaseSelectionListener());
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton = new Button((Composite)group, 16);
        this.upperCaseRadioButton.setText(JptJpaUiMessages.JpaPreferencesPage_jpqlEditor_upperCaseRadioButton);
        this.upperCaseRadioButton.addSelectionListener(this.buildUppercaseSelectionListener());
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        new Label((Composite)group, 0);
        this.matchFirstCharacterCaseCheckBox = new Button((Composite)group, 32);
        this.matchFirstCharacterCaseCheckBox.setText(JptJpaUiMessages.JpaPreferencesPage_jpqlEditor_matchFirstCharacterCaseRadioButton);
        this.matchFirstCharacterCaseCheckBox.addSelectionListener(this.buildMatchFirstCharacterCaseSelectionListener());
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
    }

    private SelectionListener buildNumberOfLinesInJpqlQuerySelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Spinner spinner = (Spinner)e.widget;
                JpaPreferencesPage.this.numberOfLinesInJpqlQueryTextArea = spinner.getSelection();
            }
        };
    }

    private SelectionListener buildLowercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = button.getSelection();
            }
        };
    }

    private SelectionListener buildMatchFirstCharacterCaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.matchFirstCharacterCase = button.getSelection();
            }
        };
    }

    private SelectionListener buildUppercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = !button.getSelection();
            }
        };
    }

    private boolean isDefaultJpqlIdentifierLowercase() {
        return JpaPreferences.getJpqlIdentifierLowercaseDefault();
    }

    private boolean shouldMatchFirstCharacterCase() {
        return JpaPreferences.getJpqlIdentifierMatchFirstCharacterCase();
    }

    private boolean shouldMatchFirstCharacterCaseDefault() {
        return JpaPreferences.getJpqlIdentifierMatchFirstCharacterCaseDefault();
    }

    private boolean shouldUseLowercaseIdentifiers() {
        return JpaPreferences.getJpqlIdentifierLowercase();
    }

    private int getJpqlQueryTextAreaNumberOfLinesDefault() {
        return JpaPreferences.getJpqlQueryTextAreaNumberOfLinesDefault();
    }

    private int getJpqlQueryTextAreaNumberOfLines() {
        return JpaPreferences.getJpqlQueryTextAreaNumberOfLines();
    }

    private String getDefaultPackage() {
        if (this.defaultPackageText == null) {
            return null;
        }
        return StringTools.isBlank((String)this.defaultPackageText.getText()) ? null : this.defaultPackageText.getText();
    }

    private void setDefaultPackage(String defaultPackage) {
        if (this.defaultPackageText == null) {
            return;
        }
        this.defaultPackageText.setText(defaultPackage);
    }

    private void migrateLegacyJpqlWorkspacePreferences() {
        boolean legacyMatchFirstCharacterCase;
        IPreferenceStore preferences = JptJpaUiPlugin.instance().getPreferenceStore();
        String legacyCase = preferences.getString(JPQL_IDENTIFIER_CASE_PREF_KEY);
        if (StringTools.isNotBlank((String)legacyCase)) {
            JpaPreferences.setJpqlIdentifierLowercase((boolean)legacyCase.equals("lowercase"));
        }
        if (legacyMatchFirstCharacterCase = preferences.getBoolean(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE_PREF_KEY)) {
            JpaPreferences.setJpqlIdentifierMatchFirstCharacterCase((boolean)legacyMatchFirstCharacterCase);
        }
        this.removeLegacyJpqlPreferences();
    }

    private void removeLegacyJpqlPreferences() {
        IPreferenceStore preferences = JptJpaUiPlugin.instance().getPreferenceStore();
        preferences.setToDefault(JPQL_IDENTIFIER_CASE_PREF_KEY);
        preferences.setToDefault(JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE_PREF_KEY);
    }

    private Text buildText(Composite parent, int horizontalSpan) {
        Text text = new Text(parent, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Label buildLabel(Composite parent, int span, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        return label;
    }
}

