/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.NullExceptionHandler;
import org.eclipse.jpt.common.utility.internal.RuntimeExceptionHandler;

public class ExceptionHandlerTests
extends TestCase {
    public ExceptionHandlerTests(String name) {
        super(name);
    }

    public void testNullExceptionHandler() {
        ExceptionHandler exceptionHandler = NullExceptionHandler.instance();
        exceptionHandler.handleException((Throwable)new NullPointerException());
    }

    public void testNullExceptionHandlerToString() {
        ExceptionHandler exceptionHandler = NullExceptionHandler.instance();
        ExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }

    public void testRuntimeExceptionHandler1() {
        Exception npe = new Exception();
        ExceptionHandler exceptionHandler = RuntimeExceptionHandler.instance();
        boolean exCaught = false;
        try {
            exceptionHandler.handleException((Throwable)npe);
            ExceptionHandlerTests.fail();
        }
        catch (RuntimeException ex) {
            ExceptionHandlerTests.assertSame((Object)npe, (Object)ex.getCause());
            exCaught = true;
        }
        ExceptionHandlerTests.assertTrue((boolean)exCaught);
    }

    public void testRuntimeExceptionHandler2() {
        NullPointerException npe = new NullPointerException();
        ExceptionHandler exceptionHandler = RuntimeExceptionHandler.instance();
        boolean exCaught = false;
        try {
            exceptionHandler.handleException((Throwable)npe);
            ExceptionHandlerTests.fail();
        }
        catch (RuntimeException ex) {
            ExceptionHandlerTests.assertSame((Object)npe, (Object)ex);
            exCaught = true;
        }
        ExceptionHandlerTests.assertTrue((boolean)exCaught);
    }

    public void testRuntimeExceptionHandlerToString() {
        ExceptionHandler exceptionHandler = RuntimeExceptionHandler.instance();
        ExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }
}

