/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.io.Serializable;
import java.util.EventListener;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.SystemTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ListenerListTests
extends TestCase {
    public ListenerListTests(String name) {
        super(name);
    }

    public void testGetListeners() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        Iterable listeners = listenerList.getListeners();
        ListenerListTests.assertEquals((int)0, (int)IterableTools.size((Iterable)listeners));
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        listeners = listenerList.getListeners();
        ListenerListTests.assertEquals((int)2, (int)IterableTools.size((Iterable)listeners));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listeners, (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listeners, (Object)listener2));
    }

    public void testSize() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertEquals((int)0, (int)listenerList.size());
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertEquals((int)2, (int)listenerList.size());
    }

    public void testIsEmpty() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        ListenerListTests.assertTrue((boolean)listenerList.isEmpty());
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertFalse((boolean)listenerList.isEmpty());
    }

    public void testAdd_null() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        boolean exCaught = false;
        try {
            listenerList.add(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testAdd_duplicate() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener = new LocalListener();
        listenerList.add((Object)listener);
        boolean exCaught = false;
        try {
            listenerList.add((Object)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener2));
        listenerList.remove((Object)listener1);
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener2));
        listenerList.remove((Object)listener2);
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener2));
    }

    public void testRemove_null() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        boolean exCaught = false;
        try {
            listenerList.remove(null);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testRemove_unregistered() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener = new LocalListener();
        listenerList.add((Object)listener);
        listenerList.remove((Object)listener);
        boolean exCaught = false;
        try {
            listenerList.remove((Object)listener);
            ListenerListTests.fail((String)("invalid listener list: " + listenerList));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ListenerListTests.assertTrue((boolean)exCaught);
    }

    public void testClear() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertTrue((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener2));
        listenerList.clear();
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener1));
        ListenerListTests.assertFalse((boolean)IterableTools.contains((Iterable)listenerList.getListeners(), (Object)listener2));
    }

    public void testSerialization() throws Exception {
        if (SystemTools.jvmIsSun()) {
            this.verifySerialization();
        }
    }

    private void verifySerialization() throws Exception {
        ListenerList listenerList = new ListenerList(Listener.class);
        LocalListener listener1 = new LocalListener();
        LocalListener listener2 = new LocalListener();
        listenerList.add((Object)listener1);
        listenerList.add((Object)listener2);
        ListenerList listenerList2 = TestTools.serialize(listenerList);
        ListenerListTests.assertNotSame((Object)listenerList, (Object)listenerList2);
        ListenerListTests.assertEquals((int)2, (int)listenerList2.size());
        NonSerializableListener listener3 = new NonSerializableListener();
        listenerList.add((Object)listener3);
        listenerList2 = TestTools.serialize(listenerList);
        ListenerListTests.assertNotSame((Object)listenerList, (Object)listenerList2);
        ListenerListTests.assertEquals((int)2, (int)listenerList2.size());
    }

    static interface Listener
    extends EventListener {
        public void somethingHappened();
    }

    static class LocalListener
    implements Listener,
    Serializable {
        private static final long serialVersionUID = 1L;

        LocalListener() {
        }

        public void somethingHappened() {
        }
    }

    static class NonSerializableListener
    implements Listener {
        NonSerializableListener() {
        }

        public void somethingHappened() {
        }
    }
}

