/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ReverseComparator;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.EmptyBag;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.ArrayToolsTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToolsTests
extends TestCase {
    public CollectionToolsTests(String name) {
        super(name);
    }

    public void testAddAllCollectionIterable_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterable_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterable_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(iterable2));
    }

    public void testAddAllCollectionIterable_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(iterable3));
    }

    public void testAddAllCollectionIterable_EmptyIterable() {
        Set<Object> set1 = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, (Iterable)EmptyIterable.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
    }

    public void testAddAllCollectionIterableInt_Modified() {
        List<String> list2;
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2, (int)list2.size()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterableInt_Unmodified() {
        List<String> list1;
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3, (int)list1.size()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterator_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionIteratorInt_Modified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIteratorInt_Unmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIteratorInt_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionObjectArray_StringModified() {
        List<String> list = this.buildStringList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_StringListEmptyArray() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringUnmodified() {
        Set<String> set = this.buildStringSet1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringSetEmptyArray() {
        Set<String> set = this.buildStringSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_ObjectModified() {
        List<Object> list = this.buildObjectList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_ObjectUnmodified() {
        Object[] a = this.buildStringArray1();
        Set<Object> set = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testBagIterable() {
        List<String> iterable = this.buildStringList1();
        HashBag b = CollectionTools.bag(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterableInt() {
        List<String> iterable = this.buildStringList1();
        HashBag b = CollectionTools.bag(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_String() {
        HashBag b = CollectionTools.bag(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_StringObject() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        HashBag b = CollectionTools.bag(c.iterator());
        CollectionToolsTests.assertEquals((int)4, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(c));
    }

    public void testBagIterator_Empty() {
        HashBag b = CollectionTools.bag((Iterator)EmptyIterator.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagIteratorInt() {
        HashBag b = CollectionTools.bag(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIteratorInt_Empty() {
        HashBag b = CollectionTools.bag((Iterator)EmptyIterator.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagObjectArray() {
        HashBag b = CollectionTools.bag((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])this.buildStringArray1()));
    }

    public void testBagObjectArray_Vararg() {
        HashBag b = CollectionTools.bag((Object[])new String[]{"foo", "bar", "baz"});
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])new Object[]{"foo", "bar", "baz"}));
    }

    public void testBagObjectArray_Empty() {
        HashBag b = CollectionTools.bag((Iterable)EmptyBag.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        HashBag c = CollectionTools.collection(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterableInt() {
        List<String> iterable = this.buildStringList1();
        HashBag c = CollectionTools.collection(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator_ObjectString() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIteratorInt() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionObjectArray() {
        HashBag c = CollectionTools.collection((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)c, (Object[])this.buildStringArray1()));
    }

    public void testContainsAllCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), iterable));
    }

    public void testContainsAllCollectionIterator_String() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), this.buildStringList1().iterator()));
    }

    public void testContainsAllCollectionIterator_Object() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("two");
        c2.add("zero");
        c2.add("one");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1, c2.iterator()));
    }

    public void testContainsAllCollectionObjectArray_StringObject() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllCollectionObjectArray() {
        Object[] a = new Object[]{"zero", "one", "two"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])a));
    }

    public void testFilterCollectionFilter() {
        HashBag c = CollectionTools.collection((Object[])new String[]{"zero", "one", "two", "three", "four"});
        HashBag actual = CollectionTools.filter((Collection)c, (Predicate)new ArrayToolsTests.StringLengthEquals(3));
        HashBag expected = CollectionTools.collection((Object[])new String[]{"one", "two"});
        CollectionToolsTests.assertEquals((Object)expected, (Object)actual);
    }

    public void testFilterCollectionFilterTransparent() {
        HashBag c = CollectionTools.collection((Object[])new String[]{"zero", "one", "two", "three", "four"});
        HashBag actual = CollectionTools.filter((Collection)c, (Predicate)PredicateTools.true_());
        HashBag expected = CollectionTools.collection((Object[])new String[]{"zero", "one", "two", "three", "four"});
        CollectionToolsTests.assertEquals((Object)expected, (Object)actual);
        CollectionToolsTests.assertNotSame((Object)expected, (Object)actual);
    }

    public void testRemoveAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable, (int)4));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable, (int)55));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIteratorInt_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator(), (int)5));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator(), (int)5));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = IteratorTools.iterator((Object[])a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = IteratorTools.iterator((Object[])a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionIterator_ObjectString() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = IteratorTools.iterator((Object[])a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = IteratorTools.iterator((Object[])a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionObjectArray_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])new Object[0]));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionObjectArray_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllCollectionObjectArray_MoreDuplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("a");
        c.add("d");
        c.add("d");
        c.add("a");
        c.add("c");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllOccurrencesCollectionObject() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add("five");
        c.add("five");
        c.add("five");
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add(null);
        c.add(null);
        c.add(null);
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
    }

    public void testRetainAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable, (int)7));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c1, c2.iterator()));
        CollectionToolsTests.assertEquals((int)c2.size(), (int)c1.size());
        CollectionToolsTests.assertEquals(c2, c1);
        ArrayList<String> c3 = new ArrayList<String>();
        c3.add("three");
        c3.add("four");
        c3.add("five");
    }

    public void testRetainAllCollectionIterator_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIterator_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIterator_EmptyCollectionEmptyIterator() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)8));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator(), (int)9));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIteratorInt_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt_EmptyCollectionEmptyIterator() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionObjectArray_EmptyObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])new Object[0]));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])new String[]{"foo"}));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray_EmptyCollectionEmptyObjectArray() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])new String[0]));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testTransformCollectionTransformer() {
        List<String> list = Arrays.asList("zero", "one", "two");
        HashBag actual = CollectionTools.transform(list, ArrayToolsTests.UPPER_CASE_TRANSFORMER);
        CollectionToolsTests.assertEquals((int)3, (int)actual.size());
        CollectionToolsTests.assertTrue((boolean)actual.contains("ZERO"));
        CollectionToolsTests.assertTrue((boolean)actual.contains("ONE"));
        CollectionToolsTests.assertTrue((boolean)actual.contains("TWO"));
    }

    public void testSetIterable() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable));
    }

    public void testSetIterableInt() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable, (int)22));
    }

    public void testSetIterator_String() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator()));
    }

    public void testSetIterator_Object() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        HashSet<String> set = new HashSet<String>();
        set.addAll(list);
        CollectionToolsTests.assertEquals(set, (Object)CollectionTools.set(list.iterator()));
    }

    public void testSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator(), (int)3));
    }

    public void testSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set((Object[])this.buildStringSet1().toArray()));
    }

    public void testSortedSetIterable() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (int)5);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (Comparator)new ReverseComparator(), (int)5);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterator() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator()));
    }

    public void testSortedSetIterator_TreeSet() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        TreeSet set2 = CollectionTools.sortedSet(ss1.iterator());
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator(), (int)8));
    }

    public void testSortedSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet((Comparable[])this.buildStringSet1().toArray(new String[0])));
    }

    public void testSortedSetObjectArrayComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        Object[] array = list.toArray(new String[list.size()]);
        TreeSet ss2 = CollectionTools.sortedSet((Object[])array, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testVectorIterable() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterableInt() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable, (int)8);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_String() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_Object() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIteratorInt() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator(), (int)7);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorObjectArray() {
        Vector v = CollectionTools.vector((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(CollectionTools.class);
                CollectionToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Set<String> buildStringSet1() {
        HashSet<String> s = new HashSet<String>();
        this.addToCollection1(s);
        return s;
    }

    private Set<Object> buildObjectSet1() {
        HashSet<Object> s = new HashSet<Object>();
        this.addToCollection1(s);
        return s;
    }

    private SortedSet<String> buildSortedStringSet1() {
        TreeSet<String> s = new TreeSet<String>();
        this.addToCollection1(s);
        return s;
    }
}

