/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterableTests
extends TestCase {
    public ArrayIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        int i = 1;
        for (String string : this.buildIterable()) {
            ArrayIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testSubIterator() {
        int i = 3;
        for (String string : this.buildIterable(2)) {
            ArrayIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    private void triggerIllegalArgumentException(int start, int end) {
        boolean exCaught = false;
        try {
            Iterable<String> iterable = this.buildIterable(start, end);
            ArrayIterableTests.fail((String)("bogus iterable: " + iterable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayIterableTests.assertTrue((boolean)exCaught);
    }

    private Iterable<String> buildIterable() {
        return this.buildIterable(0);
    }

    private Iterable<String> buildIterable(int start) {
        return this.buildIterable(this.buildArray(), start);
    }

    private Iterable<String> buildIterable(String[] array, int start) {
        return IterableTools.iterable((Object[])array, (int)start);
    }

    private Iterable<String> buildIterable(int start, int end) {
        return this.buildIterable(this.buildArray(), start, end);
    }

    private Iterable<String> buildIterable(String[] array, int start, int end) {
        return new ArrayIterable((Object[])array, start, end);
    }

    private String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

