/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainIterableTests
extends TestCase {
    private static final Class<?>[] VECTOR_HIERARCHY = new Class[]{Vector.class, AbstractList.class, AbstractCollection.class, Object.class};
    private static final TransformerAdapter<Class<?>, Class<?>> SUPERCLASS_TRANSFORMER = new SuperclassTransformer();

    public ChainIterableTests(String name) {
        super(name);
    }

    public void testNextLink() {
        int i = 0;
        for (Class<?> clazz : this.buildIterable()) {
            ChainIterableTests.assertEquals(VECTOR_HIERARCHY[i++], clazz);
        }
    }

    public void testException() {
        ChainIterable iterable = IterableTools.chainIterable(Vector.class, (Transformer)DisabledTransformer.instance());
        Iterator iterator = iterable.iterator();
        boolean exCaught = false;
        try {
            Class clazz = (Class)iterator.next();
            ChainIterableTests.fail((String)("bogus class: " + clazz));
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        ChainIterableTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        ChainIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    private Iterable<Class<?>> buildIterable() {
        return IterableTools.chainIterable(Vector.class, SUPERCLASS_TRANSFORMER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SuperclassTransformer
    extends TransformerAdapter<Class<?>, Class<?>> {
        SuperclassTransformer() {
        }

        public Class<?> transform(Class<?> clazz) {
            return clazz.getSuperclass();
        }
    }
}

