/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.DisabledPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterableTests
extends TestCase {
    private static final String PREFIX = "prefix";

    public FilteringIterableTests(String name) {
        super(name);
    }

    public void testAccept() {
        int i = 0;
        for (String s : this.buildIterable()) {
            FilteringIterableTests.assertTrue((boolean)s.contains(PREFIX));
            ++i;
        }
        FilteringIterableTests.assertEquals((int)6, (int)i);
    }

    public void testFilter() {
        Predicate<String> filter = this.buildFilter();
        int i = 0;
        for (String s : IterableTools.filter(this.buildNestedIterable(), filter)) {
            FilteringIterableTests.assertTrue((boolean)s.contains(PREFIX));
            ++i;
        }
        FilteringIterableTests.assertEquals((int)6, (int)i);
    }

    public void testSuperFilter() {
        Predicate<Object> filter = this.buildSuperFilter();
        int i = 0;
        for (String s : IterableTools.filter(this.buildNestedIterable(), filter)) {
            FilteringIterableTests.assertTrue((boolean)s.contains(PREFIX));
            ++i;
        }
        FilteringIterableTests.assertEquals((int)6, (int)i);
    }

    public void testToString() {
        FilteringIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    public void testMissingFilter() {
        boolean exCaught = false;
        FilteringIterable iterable = IterableTools.filter(this.buildNestedIterable(), (Predicate)DisabledPredicate.instance());
        try {
            Iterator iterator = iterable.iterator();
            FilteringIterableTests.fail((String)("bogus iterator: " + iterator));
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        FilteringIterableTests.assertTrue((boolean)exCaught);
    }

    private Iterable<String> buildIterable() {
        return IterableTools.filter(this.buildNestedIterable(), this.buildFilter());
    }

    private Predicate<String> buildFilter() {
        return new StringStartsWith();
    }

    private Predicate<Object> buildSuperFilter() {
        return new ObjectToStringStartsWith();
    }

    private Iterable<String> buildNestedIterable() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("prefix1");
        c.add("prefix2");
        c.add("prefix3");
        c.add("4");
        c.add("prefix5");
        c.add("prefix6");
        c.add("prefix7");
        c.add("8");
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectToStringStartsWith
    extends PredicateAdapter<Object> {
        ObjectToStringStartsWith() {
        }

        public boolean evaluate(Object o) {
            return o.toString().startsWith(FilteringIterableTests.PREFIX);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringStartsWith
    extends PredicateAdapter<String> {
        StringStartsWith() {
        }

        public boolean evaluate(String s) {
            return s.startsWith(FilteringIterableTests.PREFIX);
        }
    }
}

