/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.iterator.CloneIteratorTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneListIteratorTests
extends MultiThreadedTestCase {
    List<String> originalList;
    private List<String> concurrentList;

    public CloneListIteratorTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.originalList = this.buildList();
    }

    public void testHasNext() {
        int originalSize = this.originalList.size();
        int i = 0;
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalList.add("foo");
            ++i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        CloneListIteratorTests.assertEquals((int)originalSize, (int)i);
    }

    public void testNext() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            CloneListIteratorTests.assertEquals((String)"bogus element", (String)nestedListIterator.next(), (String)stream.next());
        }
    }

    public void testIndex() {
        ListIterator<String> cloneListIterator = this.buildCloneListIterator();
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        int i = 0;
        while (i < 7) {
            nestedListIterator.next();
            cloneListIterator.next();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
            ++i;
        }
        i = 0;
        while (i < 3) {
            nestedListIterator.previous();
            cloneListIterator.previous();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
            ++i;
        }
        while (nestedListIterator.hasNext()) {
            nestedListIterator.next();
            cloneListIterator.next();
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.nextIndex(), (int)cloneListIterator.nextIndex());
            CloneListIteratorTests.assertEquals((String)"bogus index", (int)nestedListIterator.previousIndex(), (int)cloneListIterator.previousIndex());
        }
    }

    public void testHasPrevious() {
        int originalSize = this.originalList.size();
        int i = 0;
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalList.add("foo");
            ++i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        originalSize = this.originalList.size();
        while (stream.hasPrevious()) {
            stream.previous();
            this.originalList.add("bar");
            --i;
        }
        CloneListIteratorTests.assertTrue((originalSize != this.originalList.size() ? 1 : 0) != 0);
        CloneListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testPrevious() {
        ListIterator<String> nestedListIterator = this.buildNestedListIterator();
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            nestedListIterator.next();
            stream.next();
        }
        while (stream.hasPrevious()) {
            CloneListIteratorTests.assertEquals((String)"bogus element", (String)nestedListIterator.previous(), (String)stream.previous());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildCloneListIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
        exCaught = false;
        while (stream.hasPrevious()) {
            string = stream.previous();
        }
        try {
            string = stream.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testModifyDefault() {
        boolean exCaught = false;
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
        exCaught = false;
        stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.add("three and a half");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
        exCaught = false;
        stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.set("another three");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testModifyMutatorNext() {
        this.verifyModifyNext((ListIterator<String>)IteratorTools.clone(this.originalList, this.buildMutator()));
    }

    public void testModifyMutatorPrevious() {
        this.verifyModifyPrevious((ListIterator<String>)IteratorTools.clone(this.originalList, this.buildMutator()));
    }

    private CloneListIterator.Adapter<String> buildMutator() {
        return new CloneListIterator.Adapter<String>(){

            public void add(int index, String o) {
                CloneListIteratorTests.this.originalList.add(index, o);
            }

            public void remove(int index) {
                CloneListIteratorTests.this.originalList.remove(index);
            }

            public void set(int index, String o) {
                CloneListIteratorTests.this.originalList.set(index, o);
            }
        };
    }

    private void verifyModifyNext(ListIterator<String> iterator) {
        String removed = "three";
        String addedAfter = "five";
        String added = "five and a half";
        String replaced = "seven";
        String replacement = "another seven";
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(addedAfter));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replaced));
        boolean exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CloneListIteratorTests.assertTrue((boolean)exCaught);
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (next.equals(addedAfter)) {
                iterator.add(added);
            }
            if (next.equals(removed)) {
                iterator.remove();
                exCaught = false;
                try {
                    iterator.remove();
                }
                catch (IllegalStateException illegalStateException) {
                    exCaught = true;
                }
                CloneListIteratorTests.assertTrue((boolean)exCaught);
            }
            if (!next.equals(replaced)) continue;
            iterator.set(replacement);
        }
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(added));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(replaced));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replacement));
    }

    private void verifyModifyPrevious(ListIterator<String> iterator) {
        String removed = "three";
        String addedBefore = "five";
        String added = "four and a half";
        String replaced = "seven";
        String replacement = "another seven";
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(addedBefore));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replaced));
        while (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasPrevious()) {
            String previous = iterator.previous();
            if (previous.equals(addedBefore)) {
                iterator.add(added);
            }
            if (previous.equals(removed)) {
                iterator.remove();
                boolean exCaught = false;
                try {
                    iterator.remove();
                }
                catch (IllegalStateException illegalStateException) {
                    exCaught = true;
                }
                CloneListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
            }
            if (!previous.equals(replaced)) continue;
            iterator.set(replacement);
        }
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(added));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(removed));
        CloneListIteratorTests.assertFalse((boolean)this.originalList.contains(replaced));
        CloneListIteratorTests.assertTrue((boolean)this.originalList.contains(replacement));
    }

    private ListIterator<String> buildCloneListIterator() {
        return this.buildCloneListIterator(this.originalList);
    }

    private ListIterator<String> buildCloneListIterator(List<String> list) {
        return IteratorTools.clone(list);
    }

    private ListIterator<String> buildNestedListIterator() {
        return this.originalList.listIterator();
    }

    private List<String> buildList() {
        List<String> list = this.buildEmptyList();
        this.populateList(list);
        return list;
    }

    private void populateList(List<String> list) {
        list.add("zero");
        list.add("one");
        list.add("two");
        list.add("three");
        list.add("four");
        list.add("five");
        list.add("six");
        list.add("seven");
        list.add("eight");
        list.add("nine");
    }

    protected List<String> buildEmptyList() {
        return new ArrayList<String>();
    }

    public void testConcurrentAccess() throws Exception {
        CloneIteratorTests.SlowCollection<String> slow = new CloneIteratorTests.SlowCollection<String>();
        this.populateList(slow);
        this.originalList = Collections.synchronizedList(slow);
        this.concurrentList = new ArrayList<String>();
        Thread thread = this.buildThread(this.buildRunnable());
        thread.start();
        while (!slow.hasStartedClone()) {
            Thread.yield();
        }
        this.originalList.add("seventeen");
        thread.join();
        ArrayList<String> expected = new ArrayList<String>();
        this.populateList(expected);
        CloneListIteratorTests.assertEquals(expected, this.concurrentList);
    }

    private Runnable buildRunnable() {
        return new MultiThreadedTestCase.TestRunnable(this){

            protected void run_() throws Throwable {
                CloneListIteratorTests.this.loopWithCloneListIterator();
            }
        };
    }

    void loopWithCloneListIterator() {
        ListIterator<String> stream = this.buildCloneListIterator();
        while (stream.hasNext()) {
            this.concurrentList.add(stream.next());
        }
    }
}

