/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoublePropertyValueModelTests
extends TestCase {
    protected ModifiablePropertyValueModel<String> stringModel;
    protected ChangeListener stringModelListener;
    protected PropertyChangeEvent stringModelEvent;
    protected ModifiablePropertyValueModel<ModifiablePropertyValueModel<String>> stringModelModel;
    protected ChangeListener stringModelModelListener;
    protected PropertyChangeEvent stringModelModelEvent;
    protected PropertyValueModel<String> doubleModel;
    protected ChangeListener doubleModelListener;
    protected PropertyChangeEvent doubleModelEvent;

    public DoublePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.stringModel = new SimplePropertyValueModel((Object)"foo");
        this.stringModelListener = new StringModelListener();
        this.stringModelModel = new SimplePropertyValueModel(this.stringModel);
        this.stringModelModelListener = new StringModelModelListener();
        this.doubleModel = this.buildDoubleModel();
        this.doubleModelListener = new DoubleModelListener();
    }

    protected PropertyValueModel<String> buildDoubleModel() {
        return new DoublePropertyValueModel(this.stringModelModel);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetValue1() {
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.stringModel.getValue()));
        DoublePropertyValueModelTests.assertEquals(this.stringModel, (Object)this.stringModelModel.getValue());
        DoublePropertyValueModelTests.assertNull((Object)this.doubleModel.getValue());
        this.doubleModel.addPropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.doubleModel.getValue()));
        this.stringModel.setValue((Object)"bar");
        DoublePropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.stringModel.getValue()));
        DoublePropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.doubleModel.getValue()));
        this.stringModel.setValue((Object)"baz");
        DoublePropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.stringModel.getValue()));
        DoublePropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.doubleModel.getValue()));
        this.stringModel.setValue(null);
        DoublePropertyValueModelTests.assertNull((Object)this.stringModel.getValue());
        DoublePropertyValueModelTests.assertNull((Object)this.doubleModel.getValue());
        this.stringModel.setValue((Object)"foo");
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.stringModel.getValue()));
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.doubleModel.getValue()));
    }

    public void testGetValue2() {
        DoublePropertyValueModelTests.assertNull((Object)this.doubleModel.getValue());
        this.doubleModel.addPropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.doubleModel.getValue()));
        this.stringModelModel.setValue(null);
        DoublePropertyValueModelTests.assertNull((Object)this.doubleModel.getValue());
        SimplePropertyValueModel stringModel2 = new SimplePropertyValueModel((Object)"TTT");
        this.stringModelModel.setValue((Object)stringModel2);
        DoublePropertyValueModelTests.assertEquals((String)"TTT", (String)((String)this.doubleModel.getValue()));
        this.stringModelModel.setValue(this.stringModel);
        DoublePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.doubleModel.getValue()));
    }

    public void testLazyListening() {
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasNoPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModelModel).hasNoPropertyChangeListeners("value"));
        this.doubleModel.addChangeListener(this.doubleModelListener);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasAnyPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModelModel).hasAnyPropertyChangeListeners("value"));
        this.doubleModel.removeChangeListener(this.doubleModelListener);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasNoPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModelModel).hasNoPropertyChangeListeners("value"));
        this.doubleModel.addPropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasAnyPropertyChangeListeners("value"));
        this.doubleModel.removePropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasNoPropertyChangeListeners("value"));
        this.doubleModel.addPropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        SimplePropertyValueModel stringModel2 = new SimplePropertyValueModel((Object)"TTT");
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasAnyPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)stringModel2).hasNoPropertyChangeListeners("value"));
        this.stringModelModel.setValue((Object)stringModel2);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasNoPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)stringModel2).hasAnyPropertyChangeListeners("value"));
        this.stringModelModel.setValue(this.stringModel);
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.stringModel).hasAnyPropertyChangeListeners("value"));
        DoublePropertyValueModelTests.assertTrue((boolean)((AbstractModel)stringModel2).hasNoPropertyChangeListeners("value"));
    }

    public void testPropertyChange1() {
        this.stringModel.addChangeListener(this.stringModelListener);
        this.stringModelModel.addChangeListener(this.stringModelModelListener);
        this.doubleModel.addChangeListener(this.doubleModelListener);
        this.verifyPropertyChanges1();
    }

    public void testPropertyChange2() {
        this.stringModel.addPropertyChangeListener("value", (PropertyChangeListener)this.stringModelListener);
        this.stringModelModel.addPropertyChangeListener("value", (PropertyChangeListener)this.stringModelModelListener);
        this.doubleModel.addPropertyChangeListener("value", (PropertyChangeListener)this.doubleModelListener);
        this.verifyPropertyChanges1();
    }

    protected void verifyPropertyChanges1() {
        this.stringModelEvent = null;
        this.stringModelModelEvent = null;
        this.doubleModelEvent = null;
        this.stringModel.setValue((Object)"bar");
        this.verifyEvent(this.stringModelEvent, this.stringModel, "foo", "bar");
        DoublePropertyValueModelTests.assertNull((Object)this.stringModelModelEvent);
        this.verifyEvent(this.doubleModelEvent, this.doubleModel, "foo", "bar");
        this.stringModelEvent = null;
        this.stringModelModelEvent = null;
        this.doubleModelEvent = null;
        this.stringModel.setValue(null);
        this.verifyEvent(this.stringModelEvent, this.stringModel, "bar", null);
        DoublePropertyValueModelTests.assertNull((Object)this.stringModelModelEvent);
        this.verifyEvent(this.doubleModelEvent, this.doubleModel, "bar", null);
        this.stringModelEvent = null;
        this.stringModelModelEvent = null;
        this.doubleModelEvent = null;
        this.stringModel.setValue((Object)"foo");
        this.verifyEvent(this.stringModelEvent, this.stringModel, null, "foo");
        DoublePropertyValueModelTests.assertNull((Object)this.stringModelModelEvent);
        this.verifyEvent(this.doubleModelEvent, this.doubleModel, null, "foo");
        this.stringModelEvent = null;
        this.stringModelModelEvent = null;
        this.doubleModelEvent = null;
        SimplePropertyValueModel stringModel2 = new SimplePropertyValueModel((Object)"TTT");
        this.stringModelModel.setValue((Object)stringModel2);
        DoublePropertyValueModelTests.assertNull((Object)this.stringModelEvent);
        this.verifyEvent(this.stringModelModelEvent, this.stringModelModel, this.stringModel, stringModel2);
        this.verifyEvent(this.doubleModelEvent, this.doubleModel, "foo", "TTT");
        this.stringModelEvent = null;
        this.stringModelModelEvent = null;
        this.doubleModelEvent = null;
        this.stringModelModel.setValue(this.stringModel);
        DoublePropertyValueModelTests.assertNull((Object)this.stringModelEvent);
        this.verifyEvent(this.stringModelModelEvent, this.stringModelModel, stringModel2, this.stringModel);
        this.verifyEvent(this.doubleModelEvent, this.doubleModel, "TTT", "foo");
    }

    protected void verifyEvent(PropertyChangeEvent event, Object source, Object oldValue, Object newValue) {
        DoublePropertyValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        DoublePropertyValueModelTests.assertEquals((String)"value", (String)event.getPropertyName());
        DoublePropertyValueModelTests.assertEquals((Object)oldValue, (Object)event.getOldValue());
        DoublePropertyValueModelTests.assertEquals((Object)newValue, (Object)event.getNewValue());
    }

    protected class DoubleModelListener
    extends ChangeAdapter {
        protected DoubleModelListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            DoublePropertyValueModelTests.this.doubleModelEvent = event;
        }
    }

    protected class StringModelListener
    extends ChangeAdapter {
        protected StringModelListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            DoublePropertyValueModelTests.this.stringModelEvent = event;
        }
    }

    protected class StringModelModelListener
    extends ChangeAdapter {
        protected StringModelModelListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            DoublePropertyValueModelTests.this.stringModelModelEvent = event;
        }
    }
}

